/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.resources;

import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import java.util.SortedMap;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;

@Path(value="health")
public class HealthcheckResource {
    private HealthCheckRegistry registry;

    @Inject
    public HealthcheckResource(HealthCheckRegistry registry) {
        this.registry = registry;
    }

    @GET
    public Response doGet() {
        SortedMap<String, HealthCheck.Result> results = this.registry.runHealthChecks();
        for (HealthCheck.Result result : results.values()) {
            if (result.isHealthy()) continue;
            return Response.status(500).entity("UNHEALTHY").build();
        }
        return Response.ok("OK").build();
    }
}

