/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.carrotsearch.hppc.IntSet;
import com.graphhopper.coll.GHBitSet;
import com.graphhopper.coll.GHBitSetImpl;
import com.graphhopper.coll.GHIntHashSet;
import com.graphhopper.coll.GHTBitSet;
import com.graphhopper.reader.dem.ElevationInterpolator;
import com.graphhopper.reader.dem.NodeElevationInterpolator;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RoadEnvironment;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.BreadthFirstSearch;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.PointList;

public class EdgeElevationInterpolator {
    private final GraphHopperStorage storage;
    protected final EnumEncodedValue<RoadEnvironment> roadEnvironmentEnc;
    private final NodeElevationInterpolator nodeElevationInterpolator;
    private final RoadEnvironment interpolateKey;
    private final ElevationInterpolator elevationInterpolator = new ElevationInterpolator();

    public EdgeElevationInterpolator(GraphHopperStorage storage, EnumEncodedValue<RoadEnvironment> roadEnvironmentEnc, RoadEnvironment interpolateKey) {
        this.storage = storage;
        this.roadEnvironmentEnc = roadEnvironmentEnc;
        this.interpolateKey = interpolateKey;
        this.nodeElevationInterpolator = new NodeElevationInterpolator(storage);
    }

    protected boolean isInterpolatableEdge(EdgeIteratorState edge) {
        return edge.get(this.roadEnvironmentEnc) == this.interpolateKey;
    }

    public GraphHopperStorage getStorage() {
        return this.storage;
    }

    public void execute() {
        this.interpolateElevationsOfTowerNodes();
        this.interpolateElevationsOfPillarNodes();
    }

    private void interpolateElevationsOfTowerNodes() {
        AllEdgesIterator edge = this.storage.getAllEdges();
        GHBitSetImpl visitedEdgeIds = new GHBitSetImpl(edge.length());
        EdgeExplorer edgeExplorer = this.storage.createEdgeExplorer();
        while (edge.next()) {
            int edgeId = edge.getEdge();
            if (this.isInterpolatableEdge(edge) && !visitedEdgeIds.contains(edgeId)) {
                this.interpolateEdge(edge, visitedEdgeIds, edgeExplorer);
            }
            visitedEdgeIds.add(edgeId);
        }
    }

    private void interpolateEdge(EdgeIteratorState interpolatableEdge, GHBitSet visitedEdgeIds, EdgeExplorer edgeExplorer) {
        GHIntHashSet outerNodeIds = new GHIntHashSet();
        GHIntHashSet innerNodeIds = new GHIntHashSet();
        this.gatherOuterAndInnerNodeIds(edgeExplorer, interpolatableEdge, visitedEdgeIds, outerNodeIds, innerNodeIds);
        this.nodeElevationInterpolator.interpolateElevationsOfInnerNodes(outerNodeIds.toArray(), innerNodeIds.toArray());
    }

    public void gatherOuterAndInnerNodeIds(EdgeExplorer edgeExplorer, EdgeIteratorState interpolatableEdge, final GHBitSet visitedEdgesIds, final IntSet outerNodeIds, final GHIntHashSet innerNodeIds) {
        BreadthFirstSearch gatherOuterAndInnerNodeIdsSearch = new BreadthFirstSearch(){

            @Override
            protected GHBitSet createBitSet() {
                return new GHTBitSet();
            }

            @Override
            protected boolean checkAdjacent(EdgeIteratorState edge) {
                visitedEdgesIds.add(edge.getEdge());
                int baseNodeId = edge.getBaseNode();
                boolean isInterpolatableEdge = EdgeElevationInterpolator.this.isInterpolatableEdge(edge);
                if (!isInterpolatableEdge) {
                    innerNodeIds.remove(baseNodeId);
                    outerNodeIds.add(baseNodeId);
                } else if (!outerNodeIds.contains(baseNodeId)) {
                    innerNodeIds.add(baseNodeId);
                }
                return isInterpolatableEdge;
            }
        };
        gatherOuterAndInnerNodeIdsSearch.start(edgeExplorer, interpolatableEdge.getBaseNode());
    }

    private void interpolateElevationsOfPillarNodes() {
        AllEdgesIterator edge = this.storage.getAllEdges();
        NodeAccess nodeAccess = this.storage.getNodeAccess();
        while (edge.next()) {
            if (!this.isInterpolatableEdge(edge)) continue;
            int firstNodeId = edge.getBaseNode();
            int secondNodeId = edge.getAdjNode();
            double lat0 = nodeAccess.getLat(firstNodeId);
            double lon0 = nodeAccess.getLon(firstNodeId);
            double ele0 = nodeAccess.getEle(firstNodeId);
            double lat1 = nodeAccess.getLat(secondNodeId);
            double lon1 = nodeAccess.getLon(secondNodeId);
            double ele1 = nodeAccess.getEle(secondNodeId);
            PointList pointList = edge.fetchWayGeometry(FetchMode.ALL);
            int count = pointList.size();
            for (int index = 1; index < count - 1; ++index) {
                double lat = pointList.getLat(index);
                double lon = pointList.getLon(index);
                double ele = this.elevationInterpolator.calculateElevationBasedOnTwoPoints(lat, lon, lat0, lon0, ele0, lat1, lon1, ele1);
                pointList.set(index, lat, lon, ele);
            }
            if (count > 2) {
                edge.setWayGeometry(pointList.shallowCopy(1, count - 1, false));
            }
            edge.setDistance(DistanceCalcEarth.DIST_EARTH.calcDistance(pointList));
        }
    }
}

