/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs;

import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.ev.SimpleBooleanEncodedValue;
import com.graphhopper.routing.ev.UnsignedIntEncodedValue;
import com.graphhopper.routing.util.EncodingManager;

public class PtEncodedValues {
    private BooleanEncodedValue accessEnc;
    private IntEncodedValue timeEnc;
    private IntEncodedValue transfersEnc;
    private IntEncodedValue validityIdEnc;
    private EnumEncodedValue<GtfsStorage.EdgeType> typeEnc;

    private PtEncodedValues(EncodingManager encodingManager) {
        this.accessEnc = encodingManager.getBooleanEncodedValue("is_forward_pt_edge");
        this.validityIdEnc = encodingManager.getIntEncodedValue("pt_validity_id");
        this.transfersEnc = encodingManager.getIntEncodedValue("pt_transfers");
        this.typeEnc = encodingManager.getEnumEncodedValue("pt_edge_type", GtfsStorage.EdgeType.class);
        this.timeEnc = encodingManager.getIntEncodedValue("pt_time");
    }

    public static PtEncodedValues fromEncodingManager(EncodingManager encodingManager) {
        return new PtEncodedValues(encodingManager);
    }

    public static EncodingManager.Builder createAndAddEncodedValues(EncodingManager.Builder builder) {
        builder.add(new SimpleBooleanEncodedValue("is_forward_pt_edge", true));
        builder.add(new UnsignedIntEncodedValue("pt_validity_id", 20, false));
        builder.add(new UnsignedIntEncodedValue("pt_transfers", 1, false));
        builder.add(new EnumEncodedValue<GtfsStorage.EdgeType>("pt_edge_type", GtfsStorage.EdgeType.class));
        builder.add(new UnsignedIntEncodedValue("pt_time", 17, false));
        return builder;
    }

    public IntEncodedValue getTimeEnc() {
        return this.timeEnc;
    }

    public IntEncodedValue getTransfersEnc() {
        return this.transfersEnc;
    }

    public IntEncodedValue getValidityIdEnc() {
        return this.validityIdEnc;
    }

    public EnumEncodedValue<GtfsStorage.EdgeType> getTypeEnc() {
        return this.typeEnc;
    }

    public BooleanEncodedValue getAccessEnc() {
        return this.accessEnc;
    }
}

