/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.config;

import com.graphhopper.config.Profile;

public class LMProfile {
    private String profile = "";
    private String preparationProfile = "this";
    private double maximumLMWeight = -1.0;

    private LMProfile() {
    }

    public LMProfile(String profile) {
        this.setProfile(profile);
    }

    public String getProfile() {
        return this.profile;
    }

    void setProfile(String profile) {
        Profile.validateProfileName(profile);
        this.profile = profile;
    }

    public boolean usesOtherPreparation() {
        return !this.preparationProfile.equals("this");
    }

    public String getPreparationProfile() {
        return this.preparationProfile;
    }

    public LMProfile setPreparationProfile(String preparationProfile) {
        Profile.validateProfileName(preparationProfile);
        if (this.maximumLMWeight >= 0.0) {
            throw new IllegalArgumentException("Using non-default maximum_lm_weight and preparation_profile at the same time is not allowed");
        }
        this.preparationProfile = preparationProfile;
        return this;
    }

    public double getMaximumLMWeight() {
        return this.maximumLMWeight;
    }

    public LMProfile setMaximumLMWeight(double maximumLMWeight) {
        if (this.usesOtherPreparation()) {
            throw new IllegalArgumentException("Using non-default maximum_lm_weight and preparation_profile at the same time is not allowed");
        }
        this.maximumLMWeight = maximumLMWeight;
        return this;
    }

    public String toString() {
        return this.profile + "|preparation_profile=" + this.preparationProfile + "|maximum_lm_weight=" + this.maximumLMWeight;
    }
}

