/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.spatialrules.countries;

import com.graphhopper.routing.ev.Country;
import com.graphhopper.routing.ev.RoadAccess;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.util.spatialrules.AbstractSpatialRule;
import java.util.List;
import org.locationtech.jts.geom.Polygon;

public class AustriaSpatialRule
extends AbstractSpatialRule {
    public AustriaSpatialRule(List<Polygon> borders) {
        super(borders);
    }

    @Override
    public double getMaxSpeed(RoadClass roadClass, TransportationMode transport, double currentMaxSpeed) {
        if (!Double.isNaN(currentMaxSpeed) || !transport.isMotorVehicle()) {
            return currentMaxSpeed;
        }
        switch (roadClass) {
            case MOTORWAY: {
                return 130.0;
            }
            case TRUNK: {
                return 100.0;
            }
            case PRIMARY: {
                return 100.0;
            }
            case SECONDARY: {
                return 100.0;
            }
            case TERTIARY: {
                return 100.0;
            }
            case UNCLASSIFIED: {
                return 100.0;
            }
            case RESIDENTIAL: {
                return 50.0;
            }
            case LIVING_STREET: {
                return 20.0;
            }
        }
        return Double.NaN;
    }

    @Override
    public RoadAccess getAccess(RoadClass roadClass, TransportationMode transport, RoadAccess currentRoadAccess) {
        if (currentRoadAccess != RoadAccess.YES) {
            return currentRoadAccess;
        }
        if (!transport.isMotorVehicle()) {
            return RoadAccess.YES;
        }
        switch (roadClass) {
            case LIVING_STREET: {
                return RoadAccess.DESTINATION;
            }
            case TRACK: {
                return RoadAccess.FORESTRY;
            }
            case PATH: 
            case BRIDLEWAY: 
            case CYCLEWAY: 
            case FOOTWAY: 
            case PEDESTRIAN: {
                return RoadAccess.NO;
            }
        }
        return RoadAccess.YES;
    }

    @Override
    public String getId() {
        return Country.AUT.toString();
    }
}

