/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.spatialrules;

import com.graphhopper.routing.util.spatialrules.SpatialRule;
import com.graphhopper.routing.util.spatialrules.SpatialRuleContainer;
import com.graphhopper.routing.util.spatialrules.SpatialRuleLookup;
import com.graphhopper.routing.util.spatialrules.SpatialRuleSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.index.strtree.STRtree;

public class SpatialRuleLookupJTS
implements SpatialRuleLookup {
    private static final Comparator<SpatialRule> RULE_COMP = new Comparator<SpatialRule>(){

        @Override
        public int compare(SpatialRule o1, SpatialRule o2) {
            int comp = Integer.compare(o1.getPriority(), o2.getPriority());
            if (comp != 0) {
                return comp;
            }
            return o1.getId().compareTo(o2.getId());
        }
    };
    private final GeometryFactory geometryFactory = new GeometryFactory();
    private final List<SpatialRule> rules;
    private final Envelope maxBounds;
    private final STRtree index = new STRtree();

    public SpatialRuleLookupJTS(List<SpatialRule> spatialRules) {
        this.maxBounds = new Envelope();
        HashMap<Polygon, SpatialRuleContainer> containerMap = new HashMap<Polygon, SpatialRuleContainer>();
        ArrayList<SpatialRule> registeredRules = new ArrayList<SpatialRule>();
        HashSet<String> ruleIDs = new HashSet<String>();
        for (SpatialRule rule : spatialRules) {
            if (rule == null) {
                throw new IllegalArgumentException("rule cannot be null");
            }
            if (!ruleIDs.add(rule.getId())) {
                throw new IllegalArgumentException("Duplicate rule ID: \"" + rule.getId() + "\"");
            }
            boolean registered = false;
            for (Polygon border : rule.getBorders()) {
                Envelope borderEnvelope = border.getEnvelopeInternal();
                SpatialRuleContainer container = (SpatialRuleContainer)containerMap.get(border);
                if (container == null) {
                    container = new SpatialRuleContainer(border);
                    containerMap.put(border, container);
                    this.index.insert(borderEnvelope, (Object)container);
                }
                container.addRule(rule);
                this.maxBounds.expandToInclude(borderEnvelope);
                registered = true;
            }
            if (!registered) continue;
            registeredRules.add(rule);
        }
        this.index.build();
        this.rules = Collections.unmodifiableList(registeredRules);
    }

    @Override
    public SpatialRuleSet lookupRules(double lat, double lon) {
        if (!this.maxBounds.covers(lon, lat)) {
            return SpatialRuleSet.EMPTY;
        }
        Envelope searchEnv = new Envelope(lon, lon, lat, lat);
        List containers = this.index.query(searchEnv);
        if (containers.isEmpty()) {
            return SpatialRuleSet.EMPTY;
        }
        Point point = this.geometryFactory.createPoint(new Coordinate(lon, lat));
        ArrayList<SpatialRule> applicableRules = new ArrayList<SpatialRule>();
        for (SpatialRuleContainer container : containers) {
            if (!container.covers(point)) continue;
            applicableRules.addAll(container.getRules());
        }
        if (applicableRules.isEmpty()) {
            return SpatialRuleSet.EMPTY;
        }
        Collections.sort(applicableRules, RULE_COMP);
        int spatialId = this.rules.indexOf(applicableRules.get(applicableRules.size() - 1)) + 1;
        return new SpatialRuleSet(applicableRules, spatialId);
    }

    @Override
    public List<SpatialRule> getRules() {
        return this.rules;
    }

    @Override
    public Envelope getBounds() {
        return this.maxBounds;
    }
}

