/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.UnsignedDecimalEncodedValue;
import com.graphhopper.routing.util.CarFlagEncoder;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.util.parsers.helpers.OSMValueExtractor;
import com.graphhopper.routing.weighting.CurvatureWeighting;
import com.graphhopper.routing.weighting.PriorityWeighting;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class MotorcycleFlagEncoder
extends CarFlagEncoder {
    private final HashSet<String> avoidSet = new HashSet();
    private final HashSet<String> preferSet = new HashSet();
    private DecimalEncodedValue priorityWayEncoder;
    private DecimalEncodedValue curvatureEncoder;

    public MotorcycleFlagEncoder() {
        this(new PMap());
    }

    public MotorcycleFlagEncoder(PMap properties) {
        super(properties.putObject("speed_two_directions", true));
        this.absoluteBarriers.remove("bus_trap");
        this.absoluteBarriers.remove("sump_buster");
        this.trackTypeSpeedMap.clear();
        this.defaultSpeedMap.clear();
        this.trackTypeSpeedMap.put("grade1", 20);
        this.trackTypeSpeedMap.put("grade2", 15);
        this.trackTypeSpeedMap.put("grade3", 10);
        this.trackTypeSpeedMap.put("grade4", 5);
        this.trackTypeSpeedMap.put("grade5", 5);
        this.avoidSet.add("motorway");
        this.avoidSet.add("trunk");
        this.avoidSet.add("motorroad");
        this.avoidSet.add("residential");
        this.preferSet.add("primary");
        this.preferSet.add("secondary");
        this.preferSet.add("tertiary");
        this.maxPossibleSpeed = 120;
        this.defaultSpeedMap.put("motorway", 100);
        this.defaultSpeedMap.put("motorway_link", 70);
        this.defaultSpeedMap.put("motorroad", 90);
        this.defaultSpeedMap.put("trunk", 80);
        this.defaultSpeedMap.put("trunk_link", 75);
        this.defaultSpeedMap.put("primary", 65);
        this.defaultSpeedMap.put("primary_link", 60);
        this.defaultSpeedMap.put("secondary", 60);
        this.defaultSpeedMap.put("secondary_link", 50);
        this.defaultSpeedMap.put("tertiary", 50);
        this.defaultSpeedMap.put("tertiary_link", 40);
        this.defaultSpeedMap.put("unclassified", 30);
        this.defaultSpeedMap.put("residential", 30);
        this.defaultSpeedMap.put("living_street", 5);
        this.defaultSpeedMap.put("service", 20);
        this.defaultSpeedMap.put("road", 20);
        this.defaultSpeedMap.put("track", 15);
    }

    @Override
    public int getVersion() {
        return 3;
    }

    @Override
    public void createEncodedValues(List<EncodedValue> registerNewEncodedValue, String prefix, int index) {
        super.createEncodedValues(registerNewEncodedValue, prefix, index);
        this.priorityWayEncoder = new UnsignedDecimalEncodedValue(EncodingManager.getKey(prefix, "priority"), 3, PriorityCode.getFactor(1), false);
        registerNewEncodedValue.add(this.priorityWayEncoder);
        this.curvatureEncoder = new UnsignedDecimalEncodedValue(EncodingManager.getKey(prefix, "curvature"), 4, 0.1, false);
        registerNewEncodedValue.add(this.curvatureEncoder);
    }

    @Override
    public EncodingManager.Access getAccess(ReaderWay way) {
        String tt;
        String highwayValue = way.getTag("highway");
        String firstValue = way.getFirstPriorityTag(this.restrictions);
        if (highwayValue == null) {
            if (way.hasTag("route", (Collection<String>)this.ferries)) {
                if (this.restrictedValues.contains(firstValue)) {
                    return EncodingManager.Access.CAN_SKIP;
                }
                if (this.intendedValues.contains(firstValue) || firstValue.isEmpty() && !way.hasTag("foot", new String[0]) && !way.hasTag("bicycle", new String[0])) {
                    return EncodingManager.Access.FERRY;
                }
            }
            return EncodingManager.Access.CAN_SKIP;
        }
        if ("track".equals(highwayValue) && (tt = way.getTag("tracktype")) != null && !tt.equals("grade1")) {
            return EncodingManager.Access.CAN_SKIP;
        }
        if (!this.defaultSpeedMap.containsKey(highwayValue)) {
            return EncodingManager.Access.CAN_SKIP;
        }
        if (way.hasTag("impassable", (Object)"yes") || way.hasTag("status", (Object)"impassable")) {
            return EncodingManager.Access.CAN_SKIP;
        }
        if (!firstValue.isEmpty()) {
            if (this.restrictedValues.contains(firstValue) && !this.getConditionalTagInspector().isRestrictedWayConditionallyPermitted(way)) {
                return EncodingManager.Access.CAN_SKIP;
            }
            if (this.intendedValues.contains(firstValue)) {
                return EncodingManager.Access.WAY;
            }
        }
        if (this.isBlockFords() && ("ford".equals(highwayValue) || way.hasTag("ford", new String[0]))) {
            return EncodingManager.Access.CAN_SKIP;
        }
        if (this.getConditionalTagInspector().isPermittedWayConditionallyRestricted(way)) {
            return EncodingManager.Access.CAN_SKIP;
        }
        return EncodingManager.Access.WAY;
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way, EncodingManager.Access accept) {
        if (accept.canSkip()) {
            return edgeFlags;
        }
        if (!accept.isFerry()) {
            double speed = this.getSpeed(way);
            speed = this.applyMaxSpeed(way, speed);
            double maxMCSpeed = OSMValueExtractor.stringToKmh(way.getTag("maxspeed:motorcycle"));
            if (this.isValidSpeed(maxMCSpeed) && maxMCSpeed < speed) {
                speed = maxMCSpeed * 0.9;
            }
            if (this.isValidSpeed(speed) && speed > 30.0 && way.hasTag("surface", (Collection<String>)this.badSurfaceSpeedMap)) {
                speed = 30.0;
            }
            boolean isRoundabout = this.roundaboutEnc.getBool(false, edgeFlags);
            if (way.hasTag("oneway", (Collection<String>)this.oneways) || isRoundabout) {
                if (way.hasTag("oneway", (Object)"-1")) {
                    this.accessEnc.setBool(true, edgeFlags, true);
                    this.setSpeed(true, edgeFlags, speed);
                } else {
                    this.accessEnc.setBool(false, edgeFlags, true);
                    this.setSpeed(false, edgeFlags, speed);
                }
            } else {
                this.accessEnc.setBool(false, edgeFlags, true);
                this.accessEnc.setBool(true, edgeFlags, true);
                this.setSpeed(false, edgeFlags, speed);
                this.setSpeed(true, edgeFlags, speed);
            }
        } else {
            this.accessEnc.setBool(false, edgeFlags, true);
            this.accessEnc.setBool(true, edgeFlags, true);
            double ferrySpeed = this.ferrySpeedCalc.getSpeed(way);
            this.setSpeed(false, edgeFlags, ferrySpeed);
            this.setSpeed(true, edgeFlags, ferrySpeed);
        }
        this.priorityWayEncoder.setDecimal(false, edgeFlags, PriorityCode.getFactor(this.handlePriority(way)));
        this.curvatureEncoder.setDecimal(false, edgeFlags, PriorityCode.getFactor(10));
        return edgeFlags;
    }

    private int handlePriority(ReaderWay way) {
        String highway = way.getTag("highway", "");
        if (this.avoidSet.contains(highway)) {
            return PriorityCode.WORST.getValue();
        }
        if (this.preferSet.contains(highway)) {
            return PriorityCode.BEST.getValue();
        }
        return PriorityCode.UNCHANGED.getValue();
    }

    @Override
    public void applyWayTags(ReaderWay way, EdgeIteratorState edge) {
        double speed = edge.get(this.avgSpeedEnc);
        double roadDistance = edge.getDistance();
        double beelineDistance = this.getBeelineDistance(way);
        double bendiness = beelineDistance / roadDistance;
        bendiness = this.discriminateSlowStreets(bendiness, speed);
        bendiness = this.increaseBendinessImpact(bendiness);
        bendiness = this.correctErrors(bendiness);
        edge.set(this.curvatureEncoder, bendiness);
    }

    private double getBeelineDistance(ReaderWay way) {
        return way.getTag("estimated_distance", Double.POSITIVE_INFINITY);
    }

    protected double discriminateSlowStreets(double bendiness, double speed) {
        if (speed < 51.0) {
            return 1.0;
        }
        return bendiness;
    }

    protected double correctErrors(double bendiness) {
        if (bendiness < 0.01 || bendiness > 1.0) {
            return 1.0;
        }
        return bendiness;
    }

    protected double increaseBendinessImpact(double bendiness) {
        return Math.pow(bendiness, 2.0);
    }

    @Override
    public TransportationMode getTransportationMode() {
        return TransportationMode.MOTORCYCLE;
    }

    @Override
    public boolean supports(Class<?> feature) {
        if (super.supports(feature)) {
            return true;
        }
        if (CurvatureWeighting.class.isAssignableFrom(feature)) {
            return true;
        }
        return PriorityWeighting.class.isAssignableFrom(feature);
    }

    @Override
    public String toString() {
        return "motorcycle";
    }
}

