/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.IntSet;
import com.carrotsearch.hppc.LongHashSet;
import com.carrotsearch.hppc.LongSet;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.graphhopper.routing.ch.CHPreparationGraph;
import com.graphhopper.routing.ch.EdgeBasedWitnessPathSearcher;
import com.graphhopper.routing.ch.NodeContractor;
import com.graphhopper.routing.ch.PrepareCHEntry;
import com.graphhopper.routing.ch.PrepareGraphEdgeExplorer;
import com.graphhopper.routing.ch.PrepareGraphEdgeIterator;
import com.graphhopper.routing.ch.PrepareGraphOrigEdgeExplorer;
import com.graphhopper.routing.ch.PrepareGraphOrigEdgeIterator;
import com.graphhopper.util.BitUtil;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import com.graphhopper.util.StopWatch;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EdgeBasedNodeContractor
implements NodeContractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(EdgeBasedNodeContractor.class);
    private final CHPreparationGraph prepareGraph;
    private PrepareGraphEdgeExplorer inEdgeExplorer;
    private PrepareGraphEdgeExplorer outEdgeExplorer;
    private PrepareGraphEdgeExplorer existingShortcutExplorer;
    private PrepareGraphOrigEdgeExplorer sourceNodeOrigInEdgeExplorer;
    private PrepareGraphOrigEdgeExplorer targetNodeOrigOutEdgeExplorer;
    private ShortcutHandler shortcutHandler;
    private final Params params = new Params();
    private final PMap pMap;
    private final StopWatch dijkstraSW = new StopWatch();
    private final IntSet sourceNodes = new IntHashSet(10);
    private final IntSet targetNodes = new IntHashSet(10);
    private final LongSet addedShortcuts = new LongHashSet();
    private final Stats addingStats = new Stats();
    private final Stats countingStats = new Stats();
    private Stats activeStats;
    private int[] hierarchyDepths;
    private EdgeBasedWitnessPathSearcher witnessPathSearcher;
    private int addedShortcutsCount;
    private int numShortcuts;
    private int numPrevEdges;
    private int numOrigEdges;
    private int numPrevOrigEdges;
    private int numAllEdges;
    private int numPolledEdges;

    public EdgeBasedNodeContractor(CHPreparationGraph prepareGraph, ShortcutHandler shortcutHandler, PMap pMap) {
        this.prepareGraph = prepareGraph;
        this.shortcutHandler = shortcutHandler;
        this.pMap = pMap;
        this.extractParams(pMap);
    }

    private void extractParams(PMap pMap) {
        this.params.edgeQuotientWeight = pMap.getFloat("prepare.ch.edge.edge_quotient_weight", this.params.edgeQuotientWeight);
        this.params.originalEdgeQuotientWeight = pMap.getFloat("prepare.ch.edge.original_edge_quotient_weight", this.params.originalEdgeQuotientWeight);
        this.params.hierarchyDepthWeight = pMap.getFloat("prepare.ch.edge.hierarchy_depth_weight", this.params.hierarchyDepthWeight);
    }

    @Override
    public void initFromGraph() {
        this.inEdgeExplorer = this.prepareGraph.createInEdgeExplorer();
        this.outEdgeExplorer = this.prepareGraph.createOutEdgeExplorer();
        this.existingShortcutExplorer = this.prepareGraph.createOutEdgeExplorer();
        this.sourceNodeOrigInEdgeExplorer = this.prepareGraph.createInOrigEdgeExplorer();
        this.targetNodeOrigOutEdgeExplorer = this.prepareGraph.createOutOrigEdgeExplorer();
        this.witnessPathSearcher = new EdgeBasedWitnessPathSearcher(this.prepareGraph, this.pMap);
        this.hierarchyDepths = new int[this.prepareGraph.getNodes()];
    }

    @Override
    public void prepareContraction() {
    }

    @Override
    public float calculatePriority(int node) {
        this.activeStats = this.countingStats;
        this.resetEdgeCounters();
        this.countPreviousEdges(node);
        if (this.numAllEdges == 0) {
            return Float.NEGATIVE_INFINITY;
        }
        this.stats().stopWatch.start();
        this.findAndHandlePrepareShortcuts(node, this::countShortcuts);
        this.stats().stopWatch.stop();
        float edgeQuotient = (float)this.numShortcuts / (float)this.numPrevEdges;
        float origEdgeQuotient = (float)this.numOrigEdges / (float)this.numPrevOrigEdges;
        int hierarchyDepth = this.hierarchyDepths[node];
        float priority = this.params.edgeQuotientWeight * edgeQuotient + this.params.originalEdgeQuotientWeight * origEdgeQuotient + this.params.hierarchyDepthWeight * (float)hierarchyDepth;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("node: {}, eq: {} / {} = {}, oeq: {} / {} = {}, depth: {} --> {}", node, this.numShortcuts, this.numPrevEdges, Float.valueOf(edgeQuotient), this.numOrigEdges, this.numPrevOrigEdges, Float.valueOf(origEdgeQuotient), hierarchyDepth, Float.valueOf(priority));
        }
        return priority;
    }

    @Override
    public IntContainer contractNode(int node) {
        this.activeStats = this.addingStats;
        this.stats().stopWatch.start();
        this.findAndHandlePrepareShortcuts(node, this::addShortcutsToPrepareGraph);
        this.insertShortcuts(node);
        IntContainer neighbors = this.prepareGraph.disconnect(node);
        this.updateHierarchyDepthsOfNeighbors(node, neighbors);
        this.stats().stopWatch.stop();
        return neighbors;
    }

    @Override
    public void finishContraction() {
        this.shortcutHandler.finishContraction();
    }

    @Override
    public long getAddedShortcutsCount() {
        return this.addedShortcutsCount;
    }

    @Override
    public long getDijkstraCount() {
        return this.witnessPathSearcher.getTotalNumSearches();
    }

    @Override
    public float getDijkstraSeconds() {
        return this.dijkstraSW.getCurrentSeconds();
    }

    @Override
    public String getStatisticsString() {
        String result = "sc-handler-count: " + this.countingStats + ", sc-handler-contract: " + this.addingStats + ", " + this.witnessPathSearcher.getStatisticsString();
        this.witnessPathSearcher.resetStats();
        return result;
    }

    public int getNumPolledEdges() {
        return this.numPolledEdges;
    }

    private void findAndHandlePrepareShortcuts(int node, PrepareShortcutHandler shortcutHandler) {
        this.numPolledEdges = 0;
        ++this.stats().nodes;
        this.addedShortcuts.clear();
        this.sourceNodes.clear();
        PrepareGraphEdgeIterator incomingEdges = this.inEdgeExplorer.setBaseNode(node);
        while (incomingEdges.next()) {
            boolean isNewSourceNode;
            int sourceNode = incomingEdges.getAdjNode();
            if (sourceNode == node || !(isNewSourceNode = this.sourceNodes.add(sourceNode))) continue;
            PrepareGraphOrigEdgeIterator origInIter = this.sourceNodeOrigInEdgeExplorer.setBaseNode(sourceNode);
            while (origInIter.next()) {
                int numInitialEntries = this.witnessPathSearcher.initSearch(node, sourceNode, GHUtility.getEdgeFromEdgeKey(origInIter.getOrigEdgeKeyLast()));
                if (numInitialEntries < 1) continue;
                this.targetNodes.clear();
                PrepareGraphEdgeIterator outgoingEdges = this.outEdgeExplorer.setBaseNode(node);
                while (outgoingEdges.next()) {
                    boolean isNewTargetNode;
                    int targetNode = outgoingEdges.getAdjNode();
                    if (targetNode == node || !(isNewTargetNode = this.targetNodes.add(targetNode))) continue;
                    PrepareGraphOrigEdgeIterator targetEdgeIter = this.targetNodeOrigOutEdgeExplorer.setBaseNode(targetNode);
                    while (targetEdgeIter.next()) {
                        this.dijkstraSW.start();
                        PrepareCHEntry entry = this.witnessPathSearcher.runSearch(targetNode, GHUtility.getEdgeFromEdgeKey(targetEdgeIter.getOrigEdgeKeyFirst()));
                        this.dijkstraSW.stop();
                        if (entry == null || Double.isInfinite(entry.weight)) continue;
                        PrepareCHEntry root = entry.getParent();
                        while (EdgeIterator.Edge.isValid(root.parent.prepareEdge)) {
                            root = root.getParent();
                        }
                        long addedShortcutKey = BitUtil.LITTLE.combineIntsToLong(root.getParent().incEdgeKey, entry.incEdgeKey);
                        if (!this.addedShortcuts.add(addedShortcutKey)) continue;
                        double initialTurnCost = root.getParent().weight;
                        entry.weight -= initialTurnCost;
                        LOGGER.trace("Adding shortcuts for target entry {}", (Object)entry);
                        shortcutHandler.handleShortcut(root, entry, incomingEdges.getOrigEdgeCount() + outgoingEdges.getOrigEdgeCount());
                    }
                }
                this.numPolledEdges = (int)((long)this.numPolledEdges + this.witnessPathSearcher.getNumPolledEdges());
            }
        }
    }

    private void insertShortcuts(int node) {
        this.shortcutHandler.startContractingNode();
        PrepareGraphEdgeIterator iter = this.outEdgeExplorer.setBaseNode(node);
        while (iter.next()) {
            if (!iter.isShortcut()) continue;
            this.shortcutHandler.addShortcut(iter.getPrepareEdge(), node, iter.getAdjNode(), GHUtility.getEdgeFromEdgeKey(iter.getOrigEdgeKeyFirst()), GHUtility.getEdgeFromEdgeKey(iter.getOrigEdgeKeyLast()), iter.getSkipped1(), iter.getSkipped2(), iter.getWeight(), false);
        }
        iter = this.inEdgeExplorer.setBaseNode(node);
        while (iter.next()) {
            if (!iter.isShortcut() || iter.getAdjNode() == node) continue;
            this.shortcutHandler.addShortcut(iter.getPrepareEdge(), node, iter.getAdjNode(), GHUtility.getEdgeFromEdgeKey(iter.getOrigEdgeKeyFirst()), GHUtility.getEdgeFromEdgeKey(iter.getOrigEdgeKeyLast()), iter.getSkipped1(), iter.getSkipped2(), iter.getWeight(), true);
        }
        this.addedShortcutsCount += this.shortcutHandler.finishContractingNode();
    }

    private void countPreviousEdges(int node) {
        PrepareGraphEdgeIterator outIter = this.outEdgeExplorer.setBaseNode(node);
        while (outIter.next()) {
            ++this.numAllEdges;
            ++this.numPrevEdges;
            this.numPrevOrigEdges += outIter.getOrigEdgeCount();
        }
        PrepareGraphEdgeIterator inIter = this.inEdgeExplorer.setBaseNode(node);
        while (inIter.next()) {
            ++this.numAllEdges;
            if (inIter.getBaseNode() == inIter.getAdjNode()) continue;
            ++this.numPrevEdges;
            this.numPrevOrigEdges += inIter.getOrigEdgeCount();
        }
    }

    private void updateHierarchyDepthsOfNeighbors(int node, IntContainer neighbors) {
        int level = this.hierarchyDepths[node];
        for (IntCursor n : neighbors) {
            if (n.value == node) continue;
            this.hierarchyDepths[n.value] = Math.max(this.hierarchyDepths[n.value], level + 1);
        }
    }

    private PrepareCHEntry addShortcutsToPrepareGraph(PrepareCHEntry edgeFrom, PrepareCHEntry edgeTo, int origEdgeCount) {
        if (edgeTo.parent.prepareEdge != edgeFrom.prepareEdge) {
            PrepareCHEntry prev = this.addShortcutsToPrepareGraph(edgeFrom, edgeTo.getParent(), origEdgeCount);
            return this.doAddShortcut(prev, edgeTo, origEdgeCount);
        }
        return this.doAddShortcut(edgeFrom, edgeTo, origEdgeCount);
    }

    private PrepareCHEntry doAddShortcut(PrepareCHEntry edgeFrom, PrepareCHEntry edgeTo, int origEdgeCount) {
        int from = edgeFrom.parent.adjNode;
        int adjNode = edgeTo.adjNode;
        PrepareGraphEdgeIterator iter = this.existingShortcutExplorer.setBaseNode(from);
        while (iter.next()) {
            if (!this.isSameShortcut(iter, adjNode, edgeFrom.getParent().incEdgeKey, edgeTo.incEdgeKey)) continue;
            double existingWeight = iter.getWeight();
            if (existingWeight <= edgeTo.weight) {
                PrepareCHEntry entry = new PrepareCHEntry(iter.getPrepareEdge(), iter.getOrigEdgeKeyLast(), adjNode, existingWeight);
                entry.parent = edgeFrom.parent;
                return entry;
            }
            iter.setSkippedEdges(edgeFrom.prepareEdge, edgeTo.prepareEdge);
            iter.setWeight(edgeTo.weight);
            iter.setOrigEdgeCount(origEdgeCount);
            PrepareCHEntry entry = new PrepareCHEntry(iter.getPrepareEdge(), iter.getOrigEdgeKeyLast(), adjNode, edgeTo.weight);
            entry.parent = edgeFrom.parent;
            return entry;
        }
        int origFirstKey = edgeFrom.getParent().incEdgeKey;
        LOGGER.trace("Adding shortcut from {} to {}, weight: {}, firstOrigEdgeKey: {}, lastOrigEdgeKey: {}", from, adjNode, edgeTo.weight, origFirstKey, edgeTo.incEdgeKey);
        int prepareEdge = this.prepareGraph.addShortcut(from, adjNode, origFirstKey, edgeTo.incEdgeKey, edgeFrom.prepareEdge, edgeTo.prepareEdge, edgeTo.weight, origEdgeCount);
        int incEdgeKey = -1;
        PrepareCHEntry entry = new PrepareCHEntry(prepareEdge, incEdgeKey, edgeTo.adjNode, edgeTo.weight);
        entry.parent = edgeFrom.parent;
        return entry;
    }

    private boolean isSameShortcut(PrepareGraphEdgeIterator iter, int adjNode, int firstOrigEdgeKey, int lastOrigEdgeKey) {
        return iter.isShortcut() && iter.getAdjNode() == adjNode && iter.getOrigEdgeKeyFirst() == firstOrigEdgeKey && iter.getOrigEdgeKeyLast() == lastOrigEdgeKey;
    }

    private void resetEdgeCounters() {
        this.numShortcuts = 0;
        this.numPrevEdges = 0;
        this.numOrigEdges = 0;
        this.numPrevOrigEdges = 0;
        this.numAllEdges = 0;
    }

    @Override
    public void close() {
        this.prepareGraph.close();
        this.inEdgeExplorer = null;
        this.outEdgeExplorer = null;
        this.existingShortcutExplorer = null;
        this.sourceNodeOrigInEdgeExplorer = null;
        this.targetNodeOrigOutEdgeExplorer = null;
        this.shortcutHandler = null;
        this.witnessPathSearcher.close();
        this.sourceNodes.release();
        this.targetNodes.release();
        this.addedShortcuts.release();
        this.hierarchyDepths = null;
    }

    private Stats stats() {
        return this.activeStats;
    }

    private void countShortcuts(PrepareCHEntry edgeFrom, PrepareCHEntry edgeTo, int origEdgeCount) {
        int fromNode = edgeFrom.parent.adjNode;
        int toNode = edgeTo.adjNode;
        int firstOrigEdgeKey = edgeFrom.getParent().incEdgeKey;
        int lastOrigEdgeKey = edgeTo.incEdgeKey;
        PrepareGraphEdgeIterator iter = this.existingShortcutExplorer.setBaseNode(fromNode);
        while (iter.next()) {
            if (!this.isSameShortcut(iter, toNode, firstOrigEdgeKey, lastOrigEdgeKey)) continue;
            return;
        }
        ++this.numShortcuts;
        this.numOrigEdges += origEdgeCount;
    }

    public static interface ShortcutHandler {
        public void startContractingNode();

        public void addShortcut(int var1, int var2, int var3, int var4, int var5, int var6, int var7, double var8, boolean var10);

        public int finishContractingNode();

        public void finishContraction();
    }

    private static class Stats {
        int nodes;
        StopWatch stopWatch = new StopWatch();

        private Stats() {
        }

        public String toString() {
            return String.format(Locale.ROOT, "time: %7.2fs, nodes-handled: %10s", Float.valueOf(this.stopWatch.getCurrentSeconds()), Helper.nf(this.nodes));
        }
    }

    public static class Params {
        private float edgeQuotientWeight = 1.0f;
        private float originalEdgeQuotientWeight = 3.0f;
        private float hierarchyDepthWeight = 2.0f;
    }

    @FunctionalInterface
    private static interface PrepareShortcutHandler {
        public void handleShortcut(PrepareCHEntry var1, PrepareCHEntry var2, int var3);
    }
}

