/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.matching;

import com.bmw.hmm.SequenceState;
import com.bmw.hmm.Transition;
import com.bmw.hmm.ViterbiAlgorithm;
import com.carrotsearch.hppc.IntHashSet;
import com.graphhopper.GraphHopper;
import com.graphhopper.config.LMProfile;
import com.graphhopper.config.Profile;
import com.graphhopper.matching.EdgeMatch;
import com.graphhopper.matching.HmmProbabilities;
import com.graphhopper.matching.MatchResult;
import com.graphhopper.matching.Observation;
import com.graphhopper.matching.ObservationWithCandidateStates;
import com.graphhopper.matching.State;
import com.graphhopper.routing.AStarBidirection;
import com.graphhopper.routing.AbstractNonCHBidirAlgo;
import com.graphhopper.routing.BidirRoutingAlgorithm;
import com.graphhopper.routing.DijkstraBidirectionRef;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.Subnetwork;
import com.graphhopper.routing.lm.LMApproximator;
import com.graphhopper.routing.lm.LandmarkStorage;
import com.graphhopper.routing.lm.PrepareLandmarks;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.querygraph.VirtualEdgeIteratorState;
import com.graphhopper.routing.util.DefaultSnapFilter;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.DistancePlaneProjection;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.PMap;
import com.graphhopper.util.shapes.BBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapMatching {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Graph graph;
    private final PrepareLandmarks landmarks;
    private final LocationIndexTree locationIndex;
    private double measurementErrorSigma = 50.0;
    private double transitionProbabilityBeta = 2.0;
    private final int maxVisitedNodes;
    private final DistanceCalc distanceCalc = new DistancePlaneProjection();
    private final Weighting unwrappedWeighting;
    private Weighting weighting;
    private final BooleanEncodedValue inSubnetworkEnc;
    private QueryGraph queryGraph;

    public MapMatching(GraphHopper graphHopper, PMap hints) {
        boolean useDijkstra;
        this.locationIndex = (LocationIndexTree)graphHopper.getLocationIndex();
        if (hints.has("vehicle")) {
            throw new IllegalArgumentException("MapMatching hints may no longer contain a vehicle, use the profile parameter instead, see core/#1958");
        }
        if (hints.has("weighting")) {
            throw new IllegalArgumentException("MapMatching hints may no longer contain a weighting, use the profile parameter instead, see core/#1958");
        }
        if (graphHopper.getProfiles().isEmpty()) {
            throw new IllegalArgumentException("No profiles found, you need to configure at least one profile to use map matching");
        }
        if (!hints.has("profile")) {
            throw new IllegalArgumentException("You need to specify a profile to perform map matching");
        }
        String profileStr = hints.getString("profile", "");
        Profile profile = graphHopper.getProfile(profileStr);
        if (profile == null) {
            List<Profile> profiles = graphHopper.getProfiles();
            ArrayList<String> profileNames = new ArrayList<String>(profiles.size());
            for (Profile p : profiles) {
                profileNames.add(p.getName());
            }
            throw new IllegalArgumentException("Could not find profile '" + profileStr + "', choose one of: " + profileNames);
        }
        boolean disableLM = hints.getBool("lm.disable", false);
        boolean disableCH = hints.getBool("ch.disable", false);
        boolean bl = useDijkstra = disableLM || disableCH;
        if (graphHopper.getLMPreparationHandler().isEnabled() && !useDijkstra) {
            ArrayList<String> lmProfileNames = new ArrayList<String>();
            PrepareLandmarks lmPreparation = null;
            for (LMProfile lmProfile : graphHopper.getLMPreparationHandler().getLMProfiles()) {
                lmProfileNames.add(lmProfile.getProfile());
                if (!lmProfile.getProfile().equals(profile.getName())) continue;
                lmPreparation = graphHopper.getLMPreparationHandler().getPreparation(lmProfile.usesOtherPreparation() ? lmProfile.getPreparationProfile() : lmProfile.getProfile());
            }
            if (lmPreparation == null) {
                throw new IllegalArgumentException("Cannot find LM preparation for the requested profile: '" + profile.getName() + "'\nYou can try disabling LM using " + "lm.disable" + "=true\navailable LM profiles: " + lmProfileNames);
            }
            this.landmarks = lmPreparation;
        } else {
            this.landmarks = null;
        }
        this.graph = graphHopper.getGraphHopperStorage();
        this.unwrappedWeighting = graphHopper.createWeighting(profile, hints);
        this.inSubnetworkEnc = graphHopper.getEncodingManager().getBooleanEncodedValue(Subnetwork.key(profileStr));
        this.maxVisitedNodes = hints.getInt("max_visited_nodes", Integer.MAX_VALUE);
    }

    public void setTransitionProbabilityBeta(double transitionProbabilityBeta) {
        this.transitionProbabilityBeta = transitionProbabilityBeta;
    }

    public void setMeasurementErrorSigma(double measurementErrorSigma) {
        this.measurementErrorSigma = measurementErrorSigma;
    }

    public MatchResult match(List<Observation> observations) {
        List<Observation> filteredObservations = this.filterObservations(observations);
        List<Collection<Snap>> snapsPerObservation = filteredObservations.stream().map(o -> this.findCandidateSnaps(o.getPoint().lat, o.getPoint().lon)).collect(Collectors.toList());
        this.queryGraph = QueryGraph.create(this.graph, snapsPerObservation.stream().flatMap(Collection::stream).collect(Collectors.toList()));
        this.weighting = this.queryGraph.wrapWeighting(this.unwrappedWeighting);
        List<ObservationWithCandidateStates> timeSteps = this.createTimeSteps(filteredObservations, snapsPerObservation);
        List<SequenceState<State, Observation, Path>> seq = this.computeViterbiSequence(timeSteps);
        List<EdgeIteratorState> path = seq.stream().filter(s1 -> s1.transitionDescriptor != null).flatMap(s1 -> ((Path)s1.transitionDescriptor).calcEdges().stream()).collect(Collectors.toList());
        MatchResult result = new MatchResult(this.prepareEdgeMatches(seq));
        result.setMergedPath(new MapMatchedPath(this.queryGraph, this.weighting, path));
        result.setMatchMillis(seq.stream().filter(s2 -> s2.transitionDescriptor != null).mapToLong(s2 -> ((Path)s2.transitionDescriptor).getTime()).sum());
        result.setMatchLength(seq.stream().filter(s2 -> s2.transitionDescriptor != null).mapToDouble(s2 -> ((Path)s2.transitionDescriptor).getDistance()).sum());
        result.setGPXEntriesLength(this.gpxLength(observations));
        result.setGraph(this.queryGraph);
        result.setWeighting(this.weighting);
        return result;
    }

    private List<Observation> filterObservations(List<Observation> observations) {
        ArrayList<Observation> filtered = new ArrayList<Observation>();
        Observation prevEntry = null;
        int last = observations.size() - 1;
        for (int i = 0; i <= last; ++i) {
            Observation observation = observations.get(i);
            if (i == 0 || i == last || this.distanceCalc.calcDist(prevEntry.getPoint().getLat(), prevEntry.getPoint().getLon(), observation.getPoint().getLat(), observation.getPoint().getLon()) > 2.0 * this.measurementErrorSigma) {
                filtered.add(observation);
                prevEntry = observation;
                continue;
            }
            this.logger.debug("Filter out observation: {}", (Object)(i + 1));
        }
        return filtered;
    }

    public List<Snap> findCandidateSnaps(double queryLat, double queryLon) {
        double rLon = this.measurementErrorSigma * 360.0 / DistanceCalcEarth.DIST_EARTH.calcCircumference(queryLat);
        double rLat = this.measurementErrorSigma / 111194.92664455873;
        Envelope envelope = new Envelope(queryLon, queryLon, queryLat, queryLat);
        for (int i = 0; i < 50; ++i) {
            envelope.expandBy(rLon, rLat);
            List<Snap> snaps = this.findCandidateSnapsInBBox(queryLat, queryLon, BBox.fromEnvelope(envelope));
            if (snaps.isEmpty()) continue;
            return snaps;
        }
        return Collections.emptyList();
    }

    private List<Snap> findCandidateSnapsInBBox(double queryLat, double queryLon, BBox queryShape) {
        DefaultSnapFilter edgeFilter = new DefaultSnapFilter(this.unwrappedWeighting, this.inSubnetworkEnc);
        ArrayList<Snap> snaps = new ArrayList<Snap>();
        IntHashSet seenEdges = new IntHashSet();
        IntHashSet seenNodes = new IntHashSet();
        this.locationIndex.query(queryShape, edgeId -> {
            EdgeIteratorState edge = this.graph.getEdgeIteratorStateForKey(edgeId * 2);
            if (seenEdges.add(edgeId) && edgeFilter.accept(edge)) {
                Snap snap = new Snap(queryLat, queryLon);
                this.locationIndex.traverseEdge(queryLat, queryLon, edge, (node, normedDist, wayIndex, pos) -> {
                    if (normedDist < snap.getQueryDistance()) {
                        snap.setQueryDistance(normedDist);
                        snap.setClosestNode(node);
                        snap.setWayIndex(wayIndex);
                        snap.setSnappedPosition(pos);
                    }
                });
                double dist = DistancePlaneProjection.DIST_PLANE.calcDenormalizedDist(snap.getQueryDistance());
                snap.setClosestEdge(edge);
                snap.setQueryDistance(dist);
                if (snap.isValid() && (snap.getSnappedPosition() != Snap.Position.TOWER || seenNodes.add(snap.getClosestNode()))) {
                    snap.calcSnappedPoint(DistanceCalcEarth.DIST_EARTH);
                    if (queryShape.contains(snap.getSnappedPoint().lat, snap.getSnappedPoint().lon)) {
                        snaps.add(snap);
                    }
                }
            }
        });
        return snaps;
    }

    private List<ObservationWithCandidateStates> createTimeSteps(List<Observation> filteredObservations, List<Collection<Snap>> splitsPerObservation) {
        if (splitsPerObservation.size() != filteredObservations.size()) {
            throw new IllegalArgumentException("filteredGPXEntries and queriesPerEntry must have same size.");
        }
        ArrayList<ObservationWithCandidateStates> timeSteps = new ArrayList<ObservationWithCandidateStates>();
        for (int i = 0; i < filteredObservations.size(); ++i) {
            Observation observation = filteredObservations.get(i);
            Collection<Snap> splits = splitsPerObservation.get(i);
            ArrayList<State> candidates = new ArrayList<State>();
            for (Snap split : splits) {
                if (this.queryGraph.isVirtualNode(split.getClosestNode())) {
                    ArrayList<VirtualEdgeIteratorState> virtualEdges = new ArrayList<VirtualEdgeIteratorState>();
                    EdgeIterator iter = this.queryGraph.createEdgeExplorer().setBaseNode(split.getClosestNode());
                    while (iter.next()) {
                        if (!this.queryGraph.isVirtualEdge(iter.getEdge())) {
                            throw new RuntimeException("Virtual nodes must only have virtual edges to adjacent nodes.");
                        }
                        virtualEdges.add((VirtualEdgeIteratorState)this.queryGraph.getEdgeIteratorState(iter.getEdge(), iter.getAdjNode()));
                    }
                    if (virtualEdges.size() != 2) {
                        throw new RuntimeException("Each virtual node must have exactly 2 virtual edges (reverse virtual edges are not returned by the EdgeIterator");
                    }
                    candidates.add(new State(observation, split, (VirtualEdgeIteratorState)virtualEdges.get(0), (VirtualEdgeIteratorState)virtualEdges.get(1)));
                    candidates.add(new State(observation, split, (VirtualEdgeIteratorState)virtualEdges.get(1), (VirtualEdgeIteratorState)virtualEdges.get(0)));
                    continue;
                }
                candidates.add(new State(observation, split));
            }
            timeSteps.add(new ObservationWithCandidateStates(observation, candidates));
        }
        return timeSteps;
    }

    private List<SequenceState<State, Observation, Path>> computeViterbiSequence(List<ObservationWithCandidateStates> timeSteps) {
        HmmProbabilities probabilities = new HmmProbabilities(this.measurementErrorSigma, this.transitionProbabilityBeta);
        ViterbiAlgorithm viterbi = new ViterbiAlgorithm();
        int timeStepCounter = 0;
        ObservationWithCandidateStates prevTimeStep = null;
        for (ObservationWithCandidateStates timeStep : timeSteps) {
            HashMap<State, Double> emissionLogProbabilities = new HashMap<State, Double>();
            HashMap transitionLogProbabilities = new HashMap();
            HashMap<Transition<State>, Path> roadPaths = new HashMap<Transition<State>, Path>();
            for (State candidate : timeStep.candidates) {
                double distance = candidate.getSnap().getQueryDistance();
                emissionLogProbabilities.put(candidate, probabilities.emissionLogProbability(distance));
            }
            if (prevTimeStep == null) {
                viterbi.startWithInitialObservation(timeStep.observation, timeStep.candidates, emissionLogProbabilities);
            } else {
                double linearDistance = this.distanceCalc.calcDist(prevTimeStep.observation.getPoint().lat, prevTimeStep.observation.getPoint().lon, timeStep.observation.getPoint().lat, timeStep.observation.getPoint().lon);
                for (State from : prevTimeStep.candidates) {
                    for (State to : timeStep.candidates) {
                        Path path = this.createRouter().calcPath(from.getSnap().getClosestNode(), to.getSnap().getClosestNode(), from.isOnDirectedEdge() ? from.getOutgoingVirtualEdge().getEdge() : -2, to.isOnDirectedEdge() ? to.getIncomingVirtualEdge().getEdge() : -2);
                        if (!path.isFound()) continue;
                        double transitionLogProbability = probabilities.transitionLogProbability(path.getDistance(), linearDistance);
                        Transition<State> transition = new Transition<State>(from, to);
                        roadPaths.put(transition, path);
                        transitionLogProbabilities.put(transition, transitionLogProbability);
                    }
                }
                viterbi.nextStep(timeStep.observation, timeStep.candidates, emissionLogProbabilities, transitionLogProbabilities, roadPaths);
            }
            if (viterbi.isBroken()) {
                this.fail(timeStepCounter, prevTimeStep, timeStep);
            }
            ++timeStepCounter;
            prevTimeStep = timeStep;
        }
        return viterbi.computeMostLikelySequence();
    }

    private void fail(int timeStepCounter, ObservationWithCandidateStates prevTimeStep, ObservationWithCandidateStates timeStep) {
        double dist;
        String likelyReasonStr = "";
        if (prevTimeStep != null && (dist = this.distanceCalc.calcDist(prevTimeStep.observation.getPoint().lat, prevTimeStep.observation.getPoint().lon, timeStep.observation.getPoint().lat, timeStep.observation.getPoint().lon)) > 2000.0) {
            likelyReasonStr = "Too long distance to previous measurement? " + Math.round(dist) + "m, ";
        }
        throw new IllegalArgumentException("Sequence is broken for submitted track at time step " + timeStepCounter + ". " + likelyReasonStr + "observation:" + timeStep.observation + ", " + timeStep.candidates.size() + " candidates: " + this.getSnappedCandidates(timeStep.candidates) + ". If a match is expected consider increasing max_visited_nodes.");
    }

    private BidirRoutingAlgorithm createRouter() {
        AbstractNonCHBidirAlgo router;
        if (this.landmarks != null) {
            AStarBidirection algo = new AStarBidirection(this.queryGraph, this.weighting, TraversalMode.EDGE_BASED){

                @Override
                protected void initCollections(int size) {
                    super.initCollections(50);
                }
            };
            LandmarkStorage lms = this.landmarks.getLandmarkStorage();
            int activeLM = Math.min(8, lms.getLandmarkCount());
            algo.setApproximation(LMApproximator.forLandmarks(this.queryGraph, lms, activeLM));
            algo.setMaxVisitedNodes(this.maxVisitedNodes);
            router = algo;
        } else {
            router = new DijkstraBidirectionRef(this.queryGraph, this.weighting, TraversalMode.EDGE_BASED){

                @Override
                protected void initCollections(int size) {
                    super.initCollections(50);
                }
            };
            router.setMaxVisitedNodes(this.maxVisitedNodes);
        }
        return router;
    }

    private List<EdgeMatch> prepareEdgeMatches(List<SequenceState<State, Observation, Path>> seq) {
        ArrayList<EdgeMatch> edgeMatches = new ArrayList<EdgeMatch>();
        ArrayList<State> states = new ArrayList<State>();
        EdgeIteratorState currentDirectedRealEdge = null;
        for (SequenceState<State, Observation, Path> transitionAndState : seq) {
            if (transitionAndState.transitionDescriptor != null) {
                for (EdgeIteratorState edge : ((Path)transitionAndState.transitionDescriptor).calcEdges()) {
                    EdgeIteratorState newDirectedRealEdge = this.resolveToRealEdge(edge);
                    if (currentDirectedRealEdge != null && !this.equalEdges(currentDirectedRealEdge, newDirectedRealEdge)) {
                        EdgeMatch edgeMatch = new EdgeMatch(currentDirectedRealEdge, states);
                        edgeMatches.add(edgeMatch);
                        states = new ArrayList();
                    }
                    currentDirectedRealEdge = newDirectedRealEdge;
                }
            }
            if (((State)transitionAndState.state).isOnDirectedEdge()) {
                EdgeIteratorState newDirectedRealEdge = this.resolveToRealEdge(((State)transitionAndState.state).getOutgoingVirtualEdge());
                if (currentDirectedRealEdge != null && !this.equalEdges(currentDirectedRealEdge, newDirectedRealEdge)) {
                    EdgeMatch edgeMatch = new EdgeMatch(currentDirectedRealEdge, states);
                    edgeMatches.add(edgeMatch);
                    states = new ArrayList();
                }
                currentDirectedRealEdge = newDirectedRealEdge;
            }
            states.add((State)transitionAndState.state);
        }
        if (currentDirectedRealEdge != null) {
            EdgeMatch edgeMatch = new EdgeMatch(currentDirectedRealEdge, states);
            edgeMatches.add(edgeMatch);
        }
        return edgeMatches;
    }

    private double gpxLength(List<Observation> gpxList) {
        if (gpxList.isEmpty()) {
            return 0.0;
        }
        double gpxLength = 0.0;
        Observation prevEntry = gpxList.get(0);
        for (int i = 1; i < gpxList.size(); ++i) {
            Observation entry = gpxList.get(i);
            gpxLength += this.distanceCalc.calcDist(prevEntry.getPoint().lat, prevEntry.getPoint().lon, entry.getPoint().lat, entry.getPoint().lon);
            prevEntry = entry;
        }
        return gpxLength;
    }

    private boolean equalEdges(EdgeIteratorState edge1, EdgeIteratorState edge2) {
        return edge1.getEdge() == edge2.getEdge() && edge1.getBaseNode() == edge2.getBaseNode() && edge1.getAdjNode() == edge2.getAdjNode();
    }

    private EdgeIteratorState resolveToRealEdge(EdgeIteratorState edgeIteratorState) {
        if (this.queryGraph.isVirtualNode(edgeIteratorState.getBaseNode()) || this.queryGraph.isVirtualNode(edgeIteratorState.getAdjNode())) {
            return this.graph.getEdgeIteratorStateForKey(((VirtualEdgeIteratorState)edgeIteratorState).getOriginalEdgeKey());
        }
        return edgeIteratorState;
    }

    private String getSnappedCandidates(Collection<State> candidates) {
        String str = "";
        for (State gpxe : candidates) {
            if (!str.isEmpty()) {
                str = str + ", ";
            }
            str = str + "distance: " + gpxe.getSnap().getQueryDistance() + " to " + gpxe.getSnap().getSnappedPoint();
        }
        return "[" + str + "]";
    }

    private static class MapMatchedPath
    extends Path {
        MapMatchedPath(Graph graph, Weighting weighting, List<EdgeIteratorState> edges) {
            super(graph);
            int prevEdge = -1;
            for (EdgeIteratorState edge : edges) {
                this.addDistance(edge.getDistance());
                this.addTime(GHUtility.calcMillisWithTurnMillis(weighting, edge, false, prevEdge));
                this.addEdge(edge.getEdge());
                prevEdge = edge.getEdge();
            }
            if (edges.isEmpty()) {
                this.setFound(false);
            } else {
                this.setFromNode(edges.get(0).getBaseNode());
                this.setFound(true);
            }
        }
    }
}

