/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.http;

import com.graphhopper.http.JsonErrorEntity;
import com.graphhopper.util.Helper;
import io.dropwizard.jersey.validation.ConstraintMessage;
import io.dropwizard.jersey.validation.JerseyViolationException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.server.model.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class GHJerseyViolationExceptionMapper
implements ExceptionMapper<JerseyViolationException> {
    private static final Logger logger = LoggerFactory.getLogger(GHJerseyViolationExceptionMapper.class);

    @Override
    public Response toResponse(JerseyViolationException exception) {
        logger.debug("jersey violation exception: " + (Helper.isEmpty(exception.getMessage()) ? "unknown reason" : exception.getMessage()));
        Set<ConstraintViolation<?>> violations = exception.getConstraintViolations();
        Invocable invocable = exception.getInvocable();
        List<String> errors = exception.getConstraintViolations().stream().map(violation -> ConstraintMessage.getMessage(violation, invocable)).collect(Collectors.toList());
        int status = ConstraintMessage.determineStatus(violations, invocable);
        return Response.status(status).type("application/json").entity(new JsonErrorEntity(errors)).build();
    }
}

