/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.error;

import java.io.Serializable;

public abstract class GTFSError
implements Comparable<GTFSError>,
Serializable {
    public final String file;
    public final long line;
    public final String field;
    public final String affectedEntityId;
    public final String errorType;

    public GTFSError(String file, long line, String field) {
        this(file, line, field, null);
    }

    public GTFSError(String file, long line, String field, String affectedEntityId) {
        this.file = file;
        this.line = line;
        this.field = field;
        this.affectedEntityId = affectedEntityId;
        this.errorType = this.getClass().getSimpleName();
    }

    public String getMessage() {
        return "no message";
    }

    public String getMessageWithContext() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.file);
        sb.append(' ');
        if (this.line >= 0L) {
            sb.append("line ");
            sb.append(this.line);
        } else {
            sb.append("(no line)");
        }
        if (this.field != null) {
            sb.append(", field '");
            sb.append(this.field);
            sb.append('\'');
        }
        sb.append(": ");
        sb.append(this.getMessage());
        return sb.toString();
    }

    @Override
    public int compareTo(GTFSError o) {
        int affectedEntityId;
        int file;
        if (this.file == null && o.file != null) {
            return -1;
        }
        if (this.file != null && o.file == null) {
            return 1;
        }
        int n = file = this.file == null && o.file == null ? 0 : String.CASE_INSENSITIVE_ORDER.compare(this.file, o.file);
        if (file != 0) {
            return file;
        }
        int errorType = String.CASE_INSENSITIVE_ORDER.compare(this.errorType, o.errorType);
        if (errorType != 0) {
            return errorType;
        }
        int n2 = affectedEntityId = this.affectedEntityId == null && o.affectedEntityId == null ? 0 : String.CASE_INSENSITIVE_ORDER.compare(this.affectedEntityId, o.affectedEntityId);
        if (affectedEntityId != 0) {
            return affectedEntityId;
        }
        return Long.compare(this.line, o.line);
    }

    public String toString() {
        return "GTFSError: " + this.getMessageWithContext();
    }
}

