/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.optional;

import io.dropwizard.jersey.DefaultValueUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.OptionalDouble;
import javax.annotation.Nullable;
import javax.inject.Singleton;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;

@Singleton
public class OptionalDoubleParamConverterProvider
implements ParamConverterProvider {
    private final OptionalDoubleParamConverter paramConverter = new OptionalDoubleParamConverter();

    @Override
    @Nullable
    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (!OptionalDouble.class.equals(rawType)) {
            return null;
        }
        String defaultValue = DefaultValueUtils.getDefaultValue(annotations);
        return defaultValue == null ? this.paramConverter : new OptionalDoubleParamConverter(defaultValue);
    }

    public static class OptionalDoubleParamConverter
    implements ParamConverter<OptionalDouble> {
        @Nullable
        private final String defaultValue;

        public OptionalDoubleParamConverter() {
            this(null);
        }

        public OptionalDoubleParamConverter(@Nullable String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        @Nullable
        public OptionalDouble fromString(String value) {
            try {
                double d = Double.parseDouble(value);
                return OptionalDouble.of(d);
            }
            catch (NumberFormatException e) {
                if (this.defaultValue != null) {
                    if (this.defaultValue.equals(value)) {
                        throw e;
                    }
                    if (value.isEmpty()) {
                        return null;
                    }
                }
                return OptionalDouble.empty();
            }
        }

        @Override
        public String toString(OptionalDouble value) {
            if (value == null) {
                throw new IllegalArgumentException("value must not be null");
            }
            return value.isPresent() ? Double.toString(value.getAsDouble()) : "";
        }
    }
}

