/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.carrotsearch.hppc.cursors.IntCursor;
import com.graphhopper.coll.GHIntHashSet;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.util.DistancePlaneProjection;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.PMap;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.Circle;
import com.graphhopper.util.shapes.GHPoint;
import com.graphhopper.util.shapes.Polygon;
import com.graphhopper.util.shapes.Shape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.locationtech.jts.algorithm.RectangleLineIntersector;

public class GraphEdgeIdFinder {
    private static final int P_RADIUS = 5;
    private final Graph graph;
    private final LocationIndex locationIndex;

    public GraphEdgeIdFinder(Graph graph, LocationIndex locationIndex) {
        this.graph = graph;
        this.locationIndex = locationIndex;
    }

    static double calculateArea(BBox bBox) {
        double meanLat = (bBox.maxLat + bBox.minLat) / 2.0;
        return DistancePlaneProjection.DIST_PLANE.calcDist(meanLat, bBox.minLon, meanLat, bBox.maxLon) * DistancePlaneProjection.DIST_PLANE.calcDist(bBox.minLat, bBox.minLon, bBox.maxLat, bBox.minLon);
    }

    static double calculateArea(Polygon polygon) {
        return GraphEdgeIdFinder.calculateArea(polygon.getBounds()) * polygon.envelope.getArea() / polygon.prepPolygon.getGeometry().getArea();
    }

    static double calculateArea(Circle circle) {
        return Math.PI * circle.radiusInMeter * circle.radiusInMeter;
    }

    public void findEdgesInShape(final GHIntHashSet edgeIds, final Shape shape, EdgeFilter filter) {
        this.locationIndex.query(shape.getBounds(), new LocationIndex.EdgeVisitor(this.graph.createEdgeExplorer(filter)){

            @Override
            public void onEdge(EdgeIteratorState edge, int nodeA, int nodeB) {
                if (shape.intersects(edge.fetchWayGeometry(FetchMode.ALL).makeImmutable())) {
                    edgeIds.add(edge.getEdge());
                }
            }
        });
    }

    public static BlockArea createBlockArea(Graph graph, LocationIndex locationIndex, List<GHPoint> points, PMap hints, EdgeFilter edgeFilter) {
        String blockAreaStr = hints.getString("block_area", "");
        BlockArea blockArea = new GraphEdgeIdFinder(graph, locationIndex).parseBlockArea(blockAreaStr, edgeFilter, hints.getDouble("block_area.edge_id_max_area", 1000000.0));
        for (GHPoint p : points) {
            if (!blockArea.contains(p)) continue;
            throw new IllegalArgumentException("Request with block_area contained query point " + p + ". This is not allowed.");
        }
        return blockArea;
    }

    public BlockArea parseBlockArea(String blockAreaString, EdgeFilter filter, double useEdgeIdsUntilAreaSize) {
        String objectSeparator = ";";
        String innerObjSep = ",";
        BlockArea blockArea = new BlockArea(this.graph);
        if (!blockAreaString.isEmpty()) {
            String[] blockedCircularAreasArr = blockAreaString.split(";");
            for (int i = 0; i < blockedCircularAreasArr.length; ++i) {
                String objectAsString = blockedCircularAreasArr[i];
                String[] splittedObject = objectAsString.split(",");
                if (splittedObject.length > 4) {
                    Polygon polygon = Polygon.parsePoints(objectAsString);
                    GHIntHashSet blockedEdges = blockArea.add(polygon);
                    if (!(GraphEdgeIdFinder.calculateArea(polygon) <= useEdgeIdsUntilAreaSize)) continue;
                    this.findEdgesInShape(blockedEdges, polygon, filter);
                    continue;
                }
                if (splittedObject.length == 4) {
                    BBox bbox = BBox.parseTwoPoints(objectAsString);
                    final RectangleLineIntersector cachedIntersector = new RectangleLineIntersector(BBox.toEnvelope(bbox));
                    BBox preparedBBox = new BBox(bbox.minLon, bbox.maxLon, bbox.minLat, bbox.maxLat){

                        @Override
                        public boolean intersects(PointList pointList) {
                            return BBox.intersects(cachedIntersector, pointList);
                        }
                    };
                    GHIntHashSet blockedEdges = blockArea.add(preparedBBox);
                    if (!(GraphEdgeIdFinder.calculateArea(bbox) <= useEdgeIdsUntilAreaSize)) continue;
                    this.findEdgesInShape(blockedEdges, preparedBBox, filter);
                    continue;
                }
                if (splittedObject.length == 3) {
                    double lat = Double.parseDouble(splittedObject[0]);
                    double lon = Double.parseDouble(splittedObject[1]);
                    int radius = Integer.parseInt(splittedObject[2]);
                    Circle circle = new Circle(lat, lon, radius);
                    GHIntHashSet blockedEdges = blockArea.add(circle);
                    if (!(GraphEdgeIdFinder.calculateArea(circle) <= useEdgeIdsUntilAreaSize)) continue;
                    this.findEdgesInShape(blockedEdges, circle, filter);
                    continue;
                }
                if (splittedObject.length == 2) {
                    double lat = Double.parseDouble(splittedObject[0]);
                    double lon = Double.parseDouble(splittedObject[1]);
                    Circle circle = new Circle(lat, lon, 5.0);
                    GHIntHashSet blockedEdges = blockArea.add(circle);
                    this.findEdgesInShape(blockedEdges, circle, filter);
                    continue;
                }
                throw new IllegalArgumentException(objectAsString + " at index " + i + " need to be defined as lat,lon or as a circle lat,lon,radius or rectangular lat1,lon1,lat2,lon2");
            }
        }
        return blockArea;
    }

    public static class BlockArea {
        private final List<GHIntHashSet> edgesList = new ArrayList<GHIntHashSet>();
        private final List<Shape> blockedShapes = new ArrayList<Shape>();
        private final int baseEdgeCount;

        public BlockArea(Graph g2) {
            this.baseEdgeCount = g2.getAllEdges().length();
        }

        public boolean hasCachedEdgeIds(int shapeIndex) {
            return !this.edgesList.get(shapeIndex).isEmpty();
        }

        public String toString(int shapeIndex) {
            ArrayList<Integer> returnList = new ArrayList<Integer>();
            for (IntCursor intCursor : this.edgesList.get(shapeIndex)) {
                returnList.add(intCursor.value);
            }
            Collections.sort(returnList);
            return ((Object)returnList).toString();
        }

        public GHIntHashSet add(Shape shape) {
            this.blockedShapes.add(shape);
            GHIntHashSet set = new GHIntHashSet();
            this.edgesList.add(set);
            return set;
        }

        public final boolean contains(GHPoint point) {
            for (Shape shape : this.blockedShapes) {
                if (!shape.contains(point.lat, point.lon)) continue;
                return true;
            }
            return false;
        }

        public final boolean intersects(EdgeIteratorState edgeState) {
            PointList pointList = null;
            BBox bbox = null;
            for (int shapeIdx = 0; shapeIdx < this.blockedShapes.size(); ++shapeIdx) {
                Shape shape;
                GHIntHashSet blockedEdges = this.edgesList.get(shapeIdx);
                if (!blockedEdges.isEmpty() && edgeState.getEdge() < this.baseEdgeCount) {
                    if (!blockedEdges.contains(edgeState.getEdge())) continue;
                    return true;
                }
                if (bbox == null) {
                    bbox = GHUtility.createBBox(edgeState);
                }
                if (!(shape = this.blockedShapes.get(shapeIdx)).getBounds().intersects(bbox)) continue;
                if (pointList == null) {
                    pointList = edgeState.fetchWayGeometry(FetchMode.ALL).makeImmutable();
                }
                if (!shape.intersects(pointList)) continue;
                return true;
            }
            return false;
        }
    }
}

