/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting.custom;

import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.weighting.custom.EdgeToValueEntry;
import com.graphhopper.routing.weighting.custom.EnumToValueEntry;
import com.graphhopper.util.EdgeIteratorState;
import java.util.Map;

final class BooleanToValueEntry
implements EdgeToValueEntry {
    private final BooleanEncodedValue bev;
    private final double value;
    private final double elseValue;

    private BooleanToValueEntry(BooleanEncodedValue bev, double value, double elseValue) {
        this.bev = bev;
        this.value = value;
        this.elseValue = elseValue;
    }

    static EdgeToValueEntry create(String name, BooleanEncodedValue encodedValue, Map<String, Object> map, double defaultValue, double minValue, double maxValue) {
        if (map.isEmpty()) {
            throw new IllegalArgumentException("Empty map for " + name);
        }
        if (map.containsKey("*") && map.containsKey("false")) {
            throw new IllegalArgumentException(name + ": cannot contain false and catch-all key at the same time");
        }
        double trueValue = Double.NaN;
        double falseValue = defaultValue;
        for (Map.Entry<String, Object> encValEntry : map.entrySet()) {
            if (encValEntry.getKey() == null) {
                throw new IllegalArgumentException("key for " + name + " cannot be null, value: " + encValEntry.getValue());
            }
            String key = encValEntry.getKey();
            double returnValue = EnumToValueEntry.getReturnValue(name, key, encValEntry.getValue(), minValue, maxValue);
            if ("true".equals(key)) {
                trueValue = returnValue;
                continue;
            }
            if ("false".equals(key) || "*".equals(key)) {
                falseValue = returnValue;
                continue;
            }
            throw new IllegalArgumentException("key for " + name + " cannot be " + key + ", value: " + encValEntry.getValue());
        }
        return new BooleanToValueEntry(encodedValue, trueValue, falseValue);
    }

    @Override
    public double getValue(EdgeIteratorState iter, boolean reverse) {
        if (Double.isNaN(this.value)) {
            return this.elseValue;
        }
        return iter.get(this.bev) ? this.value : this.elseValue;
    }

    public String toString() {
        return this.bev.getName() + ": " + this.value + ", else:" + this.elseValue;
    }
}

