/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.spatialrules;

import com.graphhopper.json.geo.JsonFeature;
import com.graphhopper.json.geo.JsonFeatureCollection;
import com.graphhopper.routing.util.spatialrules.SpatialRule;
import com.graphhopper.routing.util.spatialrules.SpatialRuleLookup;
import com.graphhopper.routing.util.spatialrules.SpatialRuleLookupJTS;
import com.graphhopper.util.Helper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialRuleLookupBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SpatialRuleLookupBuilder.class);

    public static SpatialRuleLookup buildIndex(List<JsonFeatureCollection> jsonFeatureCollections, String jsonIdField, SpatialRuleFactory spatialRuleFactory, Envelope maxBBox) {
        Envelope envelope = new Envelope();
        ArrayList<SpatialRule> spatialRules = new ArrayList<SpatialRule>();
        HashMap<String, JsonFeature> featureMap = new HashMap<String, JsonFeature>();
        for (JsonFeatureCollection featureCollection : jsonFeatureCollections) {
            for (JsonFeature jsonFeature : featureCollection.getFeatures()) {
                String id;
                String string = id = jsonIdField.isEmpty() || Helper.toLowerCase(jsonIdField).equals("id") ? jsonFeature.getId() : (String)jsonFeature.getProperty(jsonIdField);
                if (id == null || id.isEmpty()) {
                    throw new IllegalArgumentException("ID cannot be empty but was for JsonFeature " + featureCollection.getFeatures().indexOf(jsonFeature));
                }
                JsonFeature old = featureMap.put(id, jsonFeature);
                if (old != null) {
                    throw new IllegalStateException("SpatialRule with ID " + id + " already exists: " + old.getProperties());
                }
                ArrayList<Polygon> borders = new ArrayList<Polygon>();
                for (int i = 0; i < jsonFeature.getGeometry().getNumGeometries(); ++i) {
                    Geometry poly = jsonFeature.getGeometry().getGeometryN(i);
                    if (!(poly instanceof Polygon)) {
                        throw new IllegalArgumentException("Geometry for " + id + " (" + i + ") not supported " + poly.getClass().getSimpleName());
                    }
                    borders.add((Polygon)poly);
                }
                SpatialRule spatialRule = spatialRuleFactory.createSpatialRule(Helper.toLowerCase(id), borders);
                if (spatialRule == null) continue;
                spatialRules.add(spatialRule);
                for (Polygon polygon : spatialRule.getBorders()) {
                    envelope.expandToInclude(polygon.getEnvelopeInternal());
                }
            }
        }
        Envelope calculatedBounds = envelope.intersection(maxBBox);
        if (calculatedBounds.isNull()) {
            return SpatialRuleLookup.EMPTY;
        }
        SpatialRuleLookupJTS spatialRuleLookup = new SpatialRuleLookupJTS(spatialRules, calculatedBounds);
        logger.info("Created the SpatialRuleLookup with the following rules: {}", (Object)Arrays.toString(spatialRules.toArray()));
        return spatialRuleLookup;
    }

    public static SpatialRuleLookup buildIndex(List<JsonFeatureCollection> jsonFeatureCollections, String jsonIdField, SpatialRuleFactory spatialRuleFactory) {
        return SpatialRuleLookupBuilder.buildIndex(jsonFeatureCollections, jsonIdField, spatialRuleFactory, new Envelope(-180.0, 180.0, -90.0, 90.0));
    }

    public static interface SpatialRuleFactory {
        public SpatialRule createSpatialRule(String var1, List<Polygon> var2);
    }
}

