/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.spatialrules;

import com.graphhopper.routing.util.spatialrules.SpatialRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;

class SpatialRuleContainer {
    private static final PreparedGeometryFactory PREP_GEOM_FACTORY = new PreparedGeometryFactory();
    private static final GeometryFactory FAC = new GeometryFactory();
    private static final int GRID_SIZE = 10;
    private static final double COORD_EPSILON = 1.0E-5;
    private final PreparedGeometry preparedPolygon;
    private final Set<SpatialRule> rules = new LinkedHashSet<SpatialRule>();
    private final List<Envelope> filledLines;

    public SpatialRuleContainer(Polygon polygon) {
        this(PREP_GEOM_FACTORY.create(polygon));
    }

    private SpatialRuleContainer(PreparedGeometry preparedPolygon) {
        this.preparedPolygon = preparedPolygon;
        this.filledLines = SpatialRuleContainer.findFilledLines(preparedPolygon);
    }

    public void addRule(SpatialRule spatialRule) {
        this.rules.add(spatialRule);
    }

    public Collection<SpatialRule> getRules() {
        return this.rules;
    }

    public int size() {
        return this.rules.size();
    }

    public boolean containsProperly(Point point) {
        Coordinate coord = point.getCoordinate();
        for (Envelope line : this.filledLines) {
            if (!line.covers(coord)) continue;
            return true;
        }
        return this.preparedPolygon.containsProperly(point);
    }

    public SpatialRuleContainer copy() {
        SpatialRuleContainer container = new SpatialRuleContainer(this.preparedPolygon);
        container.rules.addAll(this.rules);
        return container;
    }

    private static List<Envelope> findFilledLines(PreparedGeometry prepGeom) {
        ArrayList<Envelope> lines = new ArrayList<Envelope>();
        Envelope bbox = prepGeom.getGeometry().getEnvelopeInternal();
        double tileWidth = bbox.getWidth() / 10.0;
        double tileHeight = bbox.getHeight() / 10.0;
        Envelope tile = new Envelope();
        for (int row = 0; row < 10; ++row) {
            Envelope line = null;
            for (int column = 0; column < 10; ++column) {
                double minX = bbox.getMinX() + (double)column * tileWidth;
                double minY = bbox.getMinY() + (double)row * tileHeight;
                tile.init(minX, minX + tileWidth, minY, minY + tileHeight);
                if (!prepGeom.covers(FAC.toGeometry(tile))) continue;
                if (line != null && Math.abs(line.getMaxX() - tile.getMinX()) < 1.0E-5) {
                    line.expandToInclude(tile);
                    continue;
                }
                line = new Envelope(tile);
                lines.add(line);
            }
        }
        return lines;
    }
}

