/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.subnetwork;

import com.carrotsearch.hppc.BitSet;
import com.carrotsearch.hppc.BitSetIterator;
import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntIndexedContainer;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.subnetwork.EdgeBasedTarjanSCC;
import com.graphhopper.routing.subnetwork.TarjanSCC;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.weighting.TurnCostProvider;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;
import com.graphhopper.util.StopWatch;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareRoutingSubnetworks {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final GraphHopperStorage ghStorage;
    private final List<PrepareJob> prepareJobs;
    private int minNetworkSize = 200;

    public PrepareRoutingSubnetworks(GraphHopperStorage ghStorage, List<PrepareJob> prepareJobs) {
        this.ghStorage = ghStorage;
        this.prepareJobs = prepareJobs;
    }

    public PrepareRoutingSubnetworks setMinNetworkSize(int minNetworkSize) {
        this.minNetworkSize = minNetworkSize;
        return this;
    }

    public void doWork() {
        if (this.minNetworkSize <= 0) {
            this.logger.info("Skipping subnetwork removal: prepare.min_network_size: " + this.minNetworkSize);
            return;
        }
        StopWatch sw = new StopWatch().start();
        this.logger.info("Start removing subnetworks, prepare.min_network_size: " + this.minNetworkSize + ", nodes: " + Helper.nf(this.ghStorage.getNodes()) + ", edges: " + Helper.nf(this.ghStorage.getEdges()) + ", jobs: " + this.prepareJobs + ", " + Helper.getMemInfo());
        for (PrepareJob job : this.prepareJobs) {
            this.removeSmallSubNetworks(job);
        }
        this.logger.info("Finished finding and removing subnetworks for " + this.prepareJobs.size() + " vehicles, took: " + sw.stop().getSeconds() + "s, " + Helper.getMemInfo());
    }

    int removeSmallSubNetworks(PrepareJob job) {
        if (job.turnCostProvider == null) {
            return this.removeSmallSubNetworksNodeBased(job.name, job.accessEnc);
        }
        return this.removeSmallSubNetworksEdgeBased(job.name, job.accessEnc, job.turnCostProvider);
    }

    private int removeSmallSubNetworksNodeBased(String jobName, BooleanEncodedValue accessEnc) {
        int allowedRemoved;
        StopWatch sw = new StopWatch().start();
        TarjanSCC tarjan = new TarjanSCC(this.ghStorage, accessEnc, false);
        TarjanSCC.ConnectedComponents ccs = tarjan.findComponents();
        List<IntArrayList> components = ccs.getComponents();
        BitSet singleNodeComponents = ccs.getSingleNodeComponents();
        long numSingleNodeComponents = singleNodeComponents.cardinality();
        this.logger.info(jobName + " - Found " + ccs.getTotalComponents() + " subnetworks (" + numSingleNodeComponents + " single nodes and " + components.size() + " components with more than one node, total nodes: " + ccs.getNodes() + "), took: " + sw.stop().getSeconds() + "s");
        sw = new StopWatch().start();
        int removedComponents = 0;
        int removedEdges = 0;
        int smallestRemaining = ccs.getBiggestComponent().size();
        int biggestRemoved = 0;
        EdgeExplorer explorer = this.ghStorage.createEdgeExplorer(DefaultEdgeFilter.allEdges(accessEnc));
        for (IntArrayList component : components) {
            if (component == ccs.getBiggestComponent()) continue;
            if (component.size() < this.minNetworkSize) {
                removedEdges += this.blockEdgesForComponent(explorer, accessEnc, component);
                ++removedComponents;
                biggestRemoved = Math.max(biggestRemoved, component.size());
                continue;
            }
            smallestRemaining = Math.min(smallestRemaining, component.size());
        }
        if (this.minNetworkSize > 0) {
            BitSetIterator iter = singleNodeComponents.iterator();
            int node = iter.nextSetBit();
            while (node >= 0) {
                removedEdges += this.blockEdgesForNode(explorer, accessEnc, node);
                ++removedComponents;
                biggestRemoved = Math.max(biggestRemoved, 1);
                node = iter.nextSetBit();
            }
        } else if (numSingleNodeComponents > 0L) {
            smallestRemaining = Math.min(smallestRemaining, 1);
        }
        if (removedEdges > (allowedRemoved = this.ghStorage.getEdges() / 2)) {
            throw new IllegalStateException("Too many total edges were removed: " + removedEdges + " out of " + this.ghStorage.getEdges() + "\nThe maximum number of removed edges is: " + allowedRemoved);
        }
        this.logger.info(jobName + " - Removed " + removedComponents + " subnetworks (biggest removed: " + biggestRemoved + " nodes) -> " + (ccs.getTotalComponents() - removedComponents) + " subnetwork(s) left (smallest: " + smallestRemaining + ", biggest: " + ccs.getBiggestComponent().size() + " nodes), total removed edges: " + removedEdges + ", took: " + sw.stop().getSeconds() + "s");
        return removedEdges;
    }

    int blockEdgesForComponent(EdgeExplorer explorer, BooleanEncodedValue accessEnc, IntIndexedContainer component) {
        int removedEdges = 0;
        for (int i = 0; i < component.size(); ++i) {
            removedEdges += this.blockEdgesForNode(explorer, accessEnc, component.get(i));
        }
        return removedEdges;
    }

    private int blockEdgesForNode(EdgeExplorer explorer, BooleanEncodedValue accessEnc, int node) {
        int removedEdges = 0;
        EdgeIterator edge = explorer.setBaseNode(node);
        while (edge.next()) {
            if (!edge.get(accessEnc) && !edge.getReverse(accessEnc)) continue;
            edge.set(accessEnc, false).setReverse(accessEnc, false);
            ++removedEdges;
        }
        return removedEdges;
    }

    private int removeSmallSubNetworksEdgeBased(String jobName, BooleanEncodedValue accessEnc, TurnCostProvider turnCostProvider) {
        int allowedRemoved;
        StopWatch sw = new StopWatch().start();
        EdgeBasedTarjanSCC tarjan = new EdgeBasedTarjanSCC(this.ghStorage, accessEnc, turnCostProvider, false);
        EdgeBasedTarjanSCC.ConnectedComponents ccs = tarjan.findComponents();
        List<IntArrayList> components = ccs.getComponents();
        BitSet singleEdgeComponents = ccs.getSingleEdgeComponents();
        long numSingleEdgeComponents = singleEdgeComponents.cardinality();
        this.logger.info(jobName + " - Found " + ccs.getTotalComponents() + " subnetworks (" + numSingleEdgeComponents + " single edges and " + components.size() + " components with more than one edge, total nodes: " + ccs.getEdgeKeys() + "), took: " + sw.stop().getSeconds() + "s");
        int minNetworkSizeEdges = 2 * this.minNetworkSize;
        sw = new StopWatch().start();
        int removedComponents = 0;
        int removedEdgeKeys = 0;
        int smallestRemaining = ccs.getBiggestComponent().size();
        int biggestRemoved = 0;
        for (IntArrayList component : components) {
            if (component == ccs.getBiggestComponent()) continue;
            if (component.size() < minNetworkSizeEdges) {
                for (IntCursor cursor : component) {
                    removedEdgeKeys += this.removeEdgeWithKey(cursor.value, accessEnc);
                }
                ++removedComponents;
                biggestRemoved = Math.max(biggestRemoved, component.size());
                continue;
            }
            smallestRemaining = Math.min(smallestRemaining, component.size());
        }
        if (minNetworkSizeEdges > 0) {
            BitSetIterator iter = singleEdgeComponents.iterator();
            int edgeKey = iter.nextSetBit();
            while (edgeKey >= 0) {
                removedEdgeKeys += this.removeEdgeWithKey(edgeKey, accessEnc);
                ++removedComponents;
                biggestRemoved = Math.max(biggestRemoved, 1);
                edgeKey = iter.nextSetBit();
            }
        } else if (numSingleEdgeComponents > 0L) {
            smallestRemaining = Math.min(smallestRemaining, 1);
        }
        if (removedEdgeKeys / 2 > (allowedRemoved = this.ghStorage.getEdges() / 2)) {
            throw new IllegalStateException("Too many total (directed) edges were removed: " + removedEdgeKeys + " out of " + 2 * this.ghStorage.getEdges() + "\nThe maximum number of removed edges is: " + 2 * allowedRemoved);
        }
        this.logger.info(jobName + " - Removed " + removedComponents + " subnetworks (biggest removed: " + biggestRemoved + " edges) -> " + (ccs.getTotalComponents() - removedComponents) + " subnetwork(s) left (smallest: " + smallestRemaining + ", biggest: " + ccs.getBiggestComponent().size() + " edges), total removed edges: " + removedEdgeKeys + ", took: " + sw.stop().getSeconds() + "s");
        return removedEdgeKeys;
    }

    private int removeEdgeWithKey(int edgeKey, BooleanEncodedValue accessEnc) {
        int edgeId = EdgeBasedTarjanSCC.getEdgeFromKey(edgeKey);
        EdgeIteratorState edge = this.ghStorage.getEdgeIteratorState(edgeId, Integer.MIN_VALUE);
        if (edgeKey % 2 == 0 && edge.get(accessEnc)) {
            edge.set(accessEnc, false);
            return 1;
        }
        if (edgeKey % 2 != 0 && edge.getReverse(accessEnc)) {
            edge.setReverse(accessEnc, false);
            return 1;
        }
        return 0;
    }

    boolean detectNodeRemovedForAllEncoders(EdgeExplorer edgeExplorerAllEdges, int nodeIndex) {
        ArrayList<BooleanEncodedValue> accessEncList = new ArrayList<BooleanEncodedValue>();
        for (PrepareJob job : this.prepareJobs) {
            accessEncList.add(job.accessEnc);
        }
        EdgeIterator iter = edgeExplorerAllEdges.setBaseNode(nodeIndex);
        while (iter.next()) {
            for (BooleanEncodedValue accessEnc : accessEncList) {
                if (!iter.get(accessEnc) && !iter.getReverse(accessEnc)) continue;
                return false;
            }
        }
        return true;
    }

    public static class PrepareJob {
        private final String name;
        private final BooleanEncodedValue accessEnc;
        private final TurnCostProvider turnCostProvider;

        public PrepareJob(String name, BooleanEncodedValue accessEnc, TurnCostProvider turnCostProvider) {
            this.name = name;
            this.accessEnc = accessEnc;
            this.turnCostProvider = turnCostProvider;
        }

        public String toString() {
            return this.name + "|" + (this.turnCostProvider == null ? "node-based" : "edge-based");
        }
    }
}

