/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.subnetwork;

import com.carrotsearch.hppc.BitSet;
import com.carrotsearch.hppc.IntArrayDeque;
import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.LongArrayDeque;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.weighting.TurnCostProvider;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.BitUtil;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class EdgeBasedTarjanSCC {
    private final Graph graph;
    private final BooleanEncodedValue accessEnc;
    private final EdgeExplorer explorer;
    private final BitUtil bitUtil = BitUtil.LITTLE;
    private final TurnCostProvider turnCostProvider;
    private final int[] edgeKeyIndex;
    private final int[] edgeKeyLowLink;
    private final BitSet edgeKeyOnStack;
    private final IntArrayDeque tarjanStack;
    private final LongArrayDeque dfsStackPQ;
    private final IntArrayDeque dfsStackAdj;
    private final ConnectedComponents components;
    private final boolean excludeSingleEdgeComponents;
    private int currIndex = 0;
    private int p;
    private int q;
    private int adj;
    private State dfsState;

    public EdgeBasedTarjanSCC(Graph graph, BooleanEncodedValue accessEnc, TurnCostProvider turnCostProvider, boolean excludeSingleEdgeComponents) {
        this.graph = graph;
        this.accessEnc = accessEnc;
        this.explorer = graph.createEdgeExplorer(DefaultEdgeFilter.outEdges(accessEnc));
        this.turnCostProvider = turnCostProvider;
        this.edgeKeyIndex = new int[2 * graph.getEdges()];
        this.edgeKeyLowLink = new int[2 * graph.getEdges()];
        Arrays.fill(this.edgeKeyIndex, -1);
        Arrays.fill(this.edgeKeyLowLink, -1);
        this.edgeKeyOnStack = new BitSet(2 * graph.getEdges());
        if (!this.edgeKeyOnStack.getClass().getName().contains("hppc")) {
            throw new IllegalStateException("Was meant to be hppc BitSet");
        }
        this.tarjanStack = new IntArrayDeque();
        this.dfsStackPQ = new LongArrayDeque();
        this.dfsStackAdj = new IntArrayDeque();
        this.components = new ConnectedComponents(excludeSingleEdgeComponents ? -1 : 2 * graph.getEdges());
        this.excludeSingleEdgeComponents = excludeSingleEdgeComponents;
    }

    public ConnectedComponents findComponentsRecursive() {
        AllEdgesIterator iter = this.graph.getAllEdges();
        while (iter.next()) {
            int edgeKeyBwd;
            int edgeKeyFwd = EdgeBasedTarjanSCC.createEdgeKey(iter, false);
            if (this.edgeKeyIndex[edgeKeyFwd] == -1) {
                this.findComponentForEdgeKey(edgeKeyFwd, iter.getAdjNode());
            }
            if (this.edgeKeyIndex[edgeKeyBwd = EdgeBasedTarjanSCC.createEdgeKey(iter, true)] != -1) continue;
            this.findComponentForEdgeKey(edgeKeyBwd, iter.getAdjNode());
        }
        return this.components;
    }

    private void findComponentForEdgeKey(int p, int adjNode) {
        this.setupNextEdgeKey(p);
        int edge = EdgeBasedTarjanSCC.getEdgeFromKey(p);
        EdgeExplorer explorer = this.graph.createEdgeExplorer(DefaultEdgeFilter.outEdges(this.accessEnc));
        EdgeIterator iter = explorer.setBaseNode(adjNode);
        while (iter.next()) {
            if (this.isTurnRestricted(edge, adjNode, iter.getEdge())) continue;
            int q = EdgeBasedTarjanSCC.createEdgeKey(iter, false);
            this.handleNeighbor(p, q, iter.getAdjNode());
            if (iter.getBaseNode() != iter.getAdjNode()) continue;
            this.handleNeighbor(p, q + 1, iter.getAdjNode());
        }
        this.buildComponent(p);
    }

    private void setupNextEdgeKey(int p) {
        this.edgeKeyIndex[p] = this.currIndex;
        this.edgeKeyLowLink[p] = this.currIndex++;
        this.tarjanStack.addLast(p);
        this.edgeKeyOnStack.set(p);
    }

    private void handleNeighbor(int p, int q, int adj) {
        if (this.edgeKeyIndex[q] == -1) {
            this.findComponentForEdgeKey(q, adj);
            this.edgeKeyLowLink[p] = Math.min(this.edgeKeyLowLink[p], this.edgeKeyLowLink[q]);
        } else if (this.edgeKeyOnStack.get(q)) {
            this.edgeKeyLowLink[p] = Math.min(this.edgeKeyLowLink[p], this.edgeKeyIndex[q]);
        }
    }

    private void buildComponent(int p) {
        if (this.edgeKeyLowLink[p] == this.edgeKeyIndex[p]) {
            if (this.tarjanStack.getLast() == p) {
                this.tarjanStack.removeLast();
                this.edgeKeyOnStack.clear(p);
                this.components.numComponents++;
                this.components.numEdgeKeys++;
                if (!this.excludeSingleEdgeComponents) {
                    this.components.singleEdgeComponents.set(p);
                }
            } else {
                int q;
                IntArrayList component = new IntArrayList();
                do {
                    q = this.tarjanStack.removeLast();
                    component.add(q);
                    this.edgeKeyOnStack.clear(q);
                } while (q != p);
                component.trimToSize();
                assert (component.size() > 1);
                this.components.numComponents++;
                ConnectedComponents connectedComponents = this.components;
                connectedComponents.numEdgeKeys = connectedComponents.numEdgeKeys + component.size();
                this.components.components.add(component);
                if (component.size() > this.components.biggestComponent.size()) {
                    this.components.biggestComponent = component;
                }
            }
        }
    }

    public ConnectedComponents findComponents() {
        AllEdgesIterator iter = this.graph.getAllEdges();
        while (iter.next()) {
            int edgeKeyFwd = EdgeBasedTarjanSCC.createEdgeKey(iter, false);
            if (this.edgeKeyIndex[edgeKeyFwd] == -1) {
                this.pushFindComponentForEdgeKey(edgeKeyFwd, iter.getAdjNode());
            }
            this.startSearch();
            int edgeKeyBwd = EdgeBasedTarjanSCC.createEdgeKey(iter, true);
            if (this.edgeKeyIndex[edgeKeyBwd] == -1) {
                this.pushFindComponentForEdgeKey(edgeKeyBwd, iter.getAdjNode());
            }
            this.startSearch();
        }
        return this.components;
    }

    private void startSearch() {
        block6: while (this.hasNext()) {
            this.pop();
            switch (this.dfsState) {
                case BUILD_COMPONENT: {
                    this.buildComponent(this.p);
                    continue block6;
                }
                case UPDATE: {
                    this.edgeKeyLowLink[this.p] = Math.min(this.edgeKeyLowLink[this.p], this.edgeKeyLowLink[this.q]);
                    continue block6;
                }
                case HANDLE_NEIGHBOR: {
                    if (this.edgeKeyIndex[this.q] != -1 && this.edgeKeyOnStack.get(this.q)) {
                        this.edgeKeyLowLink[this.p] = Math.min(this.edgeKeyLowLink[this.p], this.edgeKeyIndex[this.q]);
                    }
                    if (this.edgeKeyIndex[this.q] != -1) continue block6;
                    this.pushUpdateLowLinks(this.p, this.q);
                    this.pushFindComponentForEdgeKey(this.q, this.adj);
                    continue block6;
                }
                case FIND_COMPONENT: {
                    this.setupNextEdgeKey(this.p);
                    this.pushBuildComponent(this.p);
                    int edge = EdgeBasedTarjanSCC.getEdgeFromKey(this.p);
                    EdgeIterator it = this.explorer.setBaseNode(this.adj);
                    while (it.next()) {
                        if (this.isTurnRestricted(edge, this.adj, it.getEdge())) continue;
                        int q = EdgeBasedTarjanSCC.createEdgeKey(it, false);
                        this.pushHandleNeighbor(this.p, q, it.getAdjNode());
                        if (it.getBaseNode() != it.getAdjNode()) continue;
                        this.pushHandleNeighbor(this.p, q + 1, it.getAdjNode());
                    }
                    continue block6;
                }
            }
            throw new IllegalStateException("Unknown state: " + (Object)((Object)this.dfsState));
        }
    }

    private boolean hasNext() {
        return !this.dfsStackPQ.isEmpty();
    }

    private void pop() {
        long l = this.dfsStackPQ.removeLast();
        int a = this.dfsStackAdj.removeLast();
        int low = this.bitUtil.getIntLow(l);
        int high = this.bitUtil.getIntHigh(l);
        if (a == -1) {
            this.dfsState = State.UPDATE;
            this.p = low;
            this.q = high;
            this.adj = -1;
        } else if (a == -2 && high == -2) {
            this.dfsState = State.BUILD_COMPONENT;
            this.p = low;
            this.q = -1;
            this.adj = -1;
        } else if (high == -1) {
            this.dfsState = State.FIND_COMPONENT;
            this.p = low;
            this.q = -1;
            this.adj = a;
        } else {
            assert (low >= 0 && high >= 0 && a >= 0);
            this.dfsState = State.HANDLE_NEIGHBOR;
            this.p = low;
            this.q = high;
            this.adj = a;
        }
    }

    private void pushUpdateLowLinks(int p, int q) {
        assert (p >= 0 && q >= 0);
        this.dfsStackPQ.addLast(this.bitUtil.combineIntsToLong(p, q));
        this.dfsStackAdj.addLast(-1);
    }

    private void pushBuildComponent(int p) {
        assert (p >= 0);
        this.dfsStackPQ.addLast(this.bitUtil.combineIntsToLong(p, -2));
        this.dfsStackAdj.addLast(-2);
    }

    private void pushFindComponentForEdgeKey(int p, int adj) {
        assert (p >= 0 && adj >= 0);
        this.dfsStackPQ.addLast(this.bitUtil.combineIntsToLong(p, -1));
        this.dfsStackAdj.addLast(adj);
    }

    private void pushHandleNeighbor(int p, int q, int adj) {
        assert (p >= 0 && q >= 0 && adj >= 0);
        this.dfsStackPQ.addLast(this.bitUtil.combineIntsToLong(p, q));
        this.dfsStackAdj.addLast(adj);
    }

    private boolean isTurnRestricted(int inEdge, int node, int outEdge) {
        return this.turnCostProvider.calcTurnWeight(inEdge, node, outEdge) == Double.POSITIVE_INFINITY;
    }

    public static int createEdgeKey(EdgeIteratorState edgeState, boolean reverse) {
        int edgeKey = edgeState.getEdge() << 1;
        if (edgeState.get(EdgeIteratorState.REVERSE_STATE) == !reverse) {
            ++edgeKey;
        }
        return edgeKey;
    }

    public static int getEdgeFromKey(int edgeKey) {
        return edgeKey / 2;
    }

    public static class ConnectedComponents {
        private final List<IntArrayList> components = new ArrayList<IntArrayList>();
        private final BitSet singleEdgeComponents;
        private IntArrayList biggestComponent;
        private int numComponents;
        private int numEdgeKeys;

        ConnectedComponents(int edgeKeys) {
            this.singleEdgeComponents = new BitSet(Math.max(edgeKeys, 0));
            if (!this.singleEdgeComponents.getClass().getName().contains("hppc")) {
                throw new IllegalStateException("Was meant to be hppc BitSet");
            }
            this.biggestComponent = new IntArrayList();
        }

        public List<IntArrayList> getComponents() {
            return this.components;
        }

        public BitSet getSingleEdgeComponents() {
            return this.singleEdgeComponents;
        }

        public int getTotalComponents() {
            return this.numComponents;
        }

        public IntArrayList getBiggestComponent() {
            return this.biggestComponent;
        }

        public int getEdgeKeys() {
            return this.numEdgeKeys;
        }
    }

    private static enum State {
        UPDATE,
        HANDLE_NEIGHBOR,
        FIND_COMPONENT,
        BUILD_COMPONENT;

    }
}

