/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ev;

import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.UnsignedIntEncodedValue;
import com.graphhopper.storage.IntsRef;

public final class UnsignedDecimalEncodedValue
extends UnsignedIntEncodedValue
implements DecimalEncodedValue {
    protected final double factor;
    private final double defaultValue;
    private final boolean useMaximumAsInfinity;

    public UnsignedDecimalEncodedValue(String name, int bits, double factor, boolean storeTwoDirections) {
        this(name, bits, factor, 0.0, storeTwoDirections);
    }

    public UnsignedDecimalEncodedValue(String name, int bits, double factor, double defaultValue, boolean storeTwoDirections) {
        this(name, bits, factor, defaultValue, storeTwoDirections, false);
    }

    public UnsignedDecimalEncodedValue(String name, int bits, double factor, double defaultValue, boolean storeTwoDirections, boolean useMaximumAsInfinity) {
        super(name, bits, storeTwoDirections);
        this.factor = factor;
        this.defaultValue = defaultValue;
        this.useMaximumAsInfinity = useMaximumAsInfinity;
        if (useMaximumAsInfinity && Double.isInfinite(defaultValue)) {
            throw new IllegalArgumentException("Default value and maximum value cannot be both infinity");
        }
    }

    private int toInt(double val) {
        return (int)Math.round(val / this.factor);
    }

    @Override
    public final void setDecimal(boolean reverse, IntsRef ints, double value) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Call init before usage for EncodedValue " + this.toString());
        }
        if (this.useMaximumAsInfinity && Double.isInfinite(value)) {
            super.setInt(reverse, ints, this.maxValue);
            return;
        }
        if (value == this.defaultValue) {
            value = 0.0;
        }
        if (value > (double)this.maxValue * this.factor) {
            throw new IllegalArgumentException(this.getName() + " value " + value + " too large for encoding. maxValue:" + (double)this.maxValue * this.factor);
        }
        if (value < 0.0) {
            throw new IllegalArgumentException("Negative value for " + this.getName() + " not allowed! " + value);
        }
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException("NaN value for " + this.getName() + " not allowed!");
        }
        super.setInt(reverse, ints, this.toInt(value));
    }

    @Override
    public final double getDecimal(boolean reverse, IntsRef ref) {
        int value = this.getInt(reverse, ref);
        if (this.useMaximumAsInfinity && value == this.maxValue) {
            return Double.POSITIVE_INFINITY;
        }
        if (value == 0) {
            return this.defaultValue;
        }
        return (double)value * this.factor;
    }

    @Override
    public double getMaxDecimal() {
        return (double)this.maxValue * this.factor;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        UnsignedDecimalEncodedValue that = (UnsignedDecimalEncodedValue)o;
        return Double.compare(that.factor, this.factor) == 0;
    }

    @Override
    public int getVersion() {
        return 31 * (31 * super.getVersion() + UnsignedDecimalEncodedValue.staticHashCode(this.factor)) + UnsignedDecimalEncodedValue.staticHashCode(this.defaultValue);
    }
}

