/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.InstructionsHelper;
import com.graphhopper.routing.InstructionsOutgoingEdges;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RoadAccess;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.ev.RoadEnvironment;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.ev.Toll;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.spatialrules.TransportationMode;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.AngleCalc;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.FinishInstruction;
import com.graphhopper.util.Helper;
import com.graphhopper.util.Instruction;
import com.graphhopper.util.InstructionAnnotation;
import com.graphhopper.util.InstructionList;
import com.graphhopper.util.PointList;
import com.graphhopper.util.RoundaboutInstruction;
import com.graphhopper.util.Translation;
import com.graphhopper.util.shapes.GHPoint;

public class InstructionsFromEdges
implements Path.EdgeVisitor {
    private final Weighting weighting;
    private final FlagEncoder encoder;
    private final NodeAccess nodeAccess;
    private final Translation tr;
    private final InstructionList ways;
    private final EdgeExplorer outEdgeExplorer;
    private final EdgeExplorer crossingExplorer;
    private final BooleanEncodedValue roundaboutEnc;
    private final BooleanEncodedValue accessEnc;
    private final BooleanEncodedValue getOffBikeEnc;
    private final BooleanEncodedValue roadClassLinkEnc;
    private final EnumEncodedValue<RouteNetwork> bikeRouteEnc;
    private final EnumEncodedValue<RoadClass> roadClassEnc;
    private final EnumEncodedValue<RoadEnvironment> roadEnvEnc;
    private final EnumEncodedValue<RoadAccess> roadAccessEnc;
    private final EnumEncodedValue<Toll> tollEnc;
    private final DecimalEncodedValue maxSpeedEnc;
    private EdgeIteratorState prevEdge;
    private double prevLat;
    private double prevLon;
    private double doublePrevLat;
    private double doublePrevLon;
    private int prevNode;
    private double prevOrientation;
    private double prevInstructionPrevOrientation = Double.NaN;
    private Instruction prevInstruction;
    private boolean prevInRoundabout;
    private String prevName;
    private String prevInstructionName;
    private InstructionAnnotation prevAnnotation;
    private final int MAX_U_TURN_DISTANCE = 35;

    public InstructionsFromEdges(Graph graph, Weighting weighting, EncodedValueLookup evLookup, Translation tr, InstructionList ways) {
        this.encoder = weighting.getFlagEncoder();
        this.weighting = weighting;
        this.accessEnc = evLookup.getBooleanEncodedValue(EncodingManager.getKey(this.encoder.toString(), "access"));
        this.roundaboutEnc = evLookup.getBooleanEncodedValue("roundabout");
        String key = RouteNetwork.key("bike");
        this.bikeRouteEnc = evLookup.hasEncodedValue(key) ? evLookup.getEnumEncodedValue(key, RouteNetwork.class) : null;
        this.getOffBikeEnc = this.encoder.getTransportationMode() == TransportationMode.BICYCLE && evLookup.hasEncodedValue("get_off_bike") ? evLookup.getBooleanEncodedValue("get_off_bike") : null;
        this.tollEnc = evLookup.hasEncodedValue("toll") ? evLookup.getEnumEncodedValue("toll", Toll.class) : null;
        this.roadClassEnc = evLookup.getEnumEncodedValue("road_class", RoadClass.class);
        this.roadClassLinkEnc = evLookup.getBooleanEncodedValue("road_class_link");
        this.maxSpeedEnc = evLookup.getDecimalEncodedValue("max_speed");
        this.roadEnvEnc = evLookup.getEnumEncodedValue("road_environment", RoadEnvironment.class);
        this.roadAccessEnc = evLookup.getEnumEncodedValue("road_access", RoadAccess.class);
        this.nodeAccess = graph.getNodeAccess();
        this.tr = tr;
        this.ways = ways;
        this.prevNode = -1;
        this.prevInRoundabout = false;
        this.prevName = null;
        this.outEdgeExplorer = graph.createEdgeExplorer(DefaultEdgeFilter.outEdges(this.encoder));
        this.crossingExplorer = graph.createEdgeExplorer(DefaultEdgeFilter.allEdges(this.encoder));
    }

    public static InstructionList calcInstructions(Path path, Graph graph, Weighting weighting, EncodedValueLookup evLookup, Translation tr) {
        InstructionList ways = new InstructionList(tr);
        if (path.isFound()) {
            if (path.getEdgeCount() == 0) {
                ways.add(new FinishInstruction(graph.getNodeAccess(), path.getEndNode()));
            } else {
                path.forEveryEdge(new InstructionsFromEdges(graph, weighting, evLookup, tr, ways));
            }
        }
        return ways;
    }

    @Override
    public void next(EdgeIteratorState edge, int index, int prevEdgeId) {
        int sign;
        InstructionAnnotation annotation;
        RoadEnvironment re;
        double longitude;
        double latitude;
        int adjNode = edge.getAdjNode();
        int baseNode = edge.getBaseNode();
        if (this.prevNode == -1) {
            this.prevLat = this.nodeAccess.getLatitude(baseNode);
            this.prevLon = this.nodeAccess.getLongitude(baseNode);
        }
        double adjLat = this.nodeAccess.getLatitude(adjNode);
        double adjLon = this.nodeAccess.getLongitude(adjNode);
        PointList wayGeo = edge.fetchWayGeometry(FetchMode.ALL);
        boolean isRoundabout = edge.get(this.roundaboutEnc);
        if (wayGeo.getSize() <= 2) {
            latitude = adjLat;
            longitude = adjLon;
        } else {
            latitude = wayGeo.getLatitude(1);
            longitude = wayGeo.getLongitude(1);
            assert (Double.compare(this.prevLat, this.nodeAccess.getLatitude(baseNode)) == 0);
            assert (Double.compare(this.prevLon, this.nodeAccess.getLongitude(baseNode)) == 0);
        }
        String name = edge.getName();
        String info = "";
        int importance = 1;
        if (this.getOffBikeEnc != null) {
            if (edge.get(this.roadClassEnc) == RoadClass.CYCLEWAY || this.bikeRouteEnc != null && edge.get(this.bikeRouteEnc) != RouteNetwork.OTHER) {
                importance = 0;
                info = this.tr.tr("cycleway", new Object[0]);
            } else if (edge.get(this.getOffBikeEnc)) {
                info = this.tr.tr("off_bike", new Object[0]);
            }
        }
        if ((re = edge.get(this.roadEnvEnc)) == RoadEnvironment.FORD) {
            importance = 2;
            info = this.tr.tr("way_contains_ford", new Object[0]);
        } else if (re == RoadEnvironment.FERRY) {
            info = this.tr.tr("way_contains_ferry", new Object[0]);
        }
        RoadAccess ra = edge.get(this.roadAccessEnc);
        if (ra == RoadAccess.PRIVATE) {
            String string = info = info.isEmpty() ? this.tr.tr("way_contains_private", new Object[0]) : info + ", " + this.tr.tr("way_contains_private", new Object[0]);
        }
        if (this.tollEnc != null && edge.get(this.tollEnc) != Toll.NO) {
            info = info.isEmpty() ? this.tr.tr("way_contains_toll", new Object[0]) : info + ", " + this.tr.tr("way_contains_toll", new Object[0]);
        }
        InstructionAnnotation instructionAnnotation = annotation = info.isEmpty() ? InstructionAnnotation.EMPTY : new InstructionAnnotation(importance, info);
        if (this.prevName == null && !isRoundabout) {
            sign = 0;
            this.prevInstruction = new Instruction(sign, name, annotation, new PointList(10, this.nodeAccess.is3D()));
            double startLat = this.nodeAccess.getLat(baseNode);
            double startLon = this.nodeAccess.getLon(baseNode);
            double heading = AngleCalc.ANGLE_CALC.calcAzimuth(startLat, startLon, latitude, longitude);
            this.prevInstruction.setExtraInfo("heading", Helper.round(heading, 2));
            this.ways.add(this.prevInstruction);
            this.prevName = name;
            this.prevAnnotation = annotation;
        } else if (isRoundabout) {
            if (!this.prevInRoundabout) {
                int sign2 = 6;
                RoundaboutInstruction roundaboutInstruction = new RoundaboutInstruction(sign2, name, annotation, new PointList(10, this.nodeAccess.is3D()));
                this.prevInstructionPrevOrientation = this.prevOrientation;
                if (this.prevName != null) {
                    EdgeIterator edgeIter = this.outEdgeExplorer.setBaseNode(baseNode);
                    while (edgeIter.next()) {
                        if (edgeIter.getAdjNode() == this.prevNode || edgeIter.get(this.roundaboutEnc)) continue;
                        roundaboutInstruction.increaseExitNumber();
                        break;
                    }
                    this.prevOrientation = AngleCalc.ANGLE_CALC.calcOrientation(this.doublePrevLat, this.doublePrevLon, this.prevLat, this.prevLon);
                    double orientation = AngleCalc.ANGLE_CALC.calcOrientation(this.prevLat, this.prevLon, latitude, longitude);
                    orientation = AngleCalc.ANGLE_CALC.alignOrientation(this.prevOrientation, orientation);
                    double delta = orientation - this.prevOrientation;
                    roundaboutInstruction.setDirOfRotation(delta);
                } else {
                    this.prevOrientation = AngleCalc.ANGLE_CALC.calcOrientation(this.prevLat, this.prevLon, latitude, longitude);
                    this.prevName = name;
                    this.prevAnnotation = annotation;
                }
                this.prevInstruction = roundaboutInstruction;
                this.ways.add(this.prevInstruction);
            }
            EdgeIterator edgeIter = this.outEdgeExplorer.setBaseNode(edge.getAdjNode());
            while (edgeIter.next()) {
                if (this.roundaboutEnc.getBool(false, edgeIter.getFlags())) continue;
                ((RoundaboutInstruction)this.prevInstruction).increaseExitNumber();
                break;
            }
        } else if (this.prevInRoundabout) {
            this.prevInstruction.setName(name);
            double orientation = AngleCalc.ANGLE_CALC.calcOrientation(this.prevLat, this.prevLon, latitude, longitude);
            orientation = AngleCalc.ANGLE_CALC.alignOrientation(this.prevOrientation, orientation);
            double deltaInOut = orientation - this.prevOrientation;
            double recentOrientation = AngleCalc.ANGLE_CALC.calcOrientation(this.doublePrevLat, this.doublePrevLon, this.prevLat, this.prevLon);
            orientation = AngleCalc.ANGLE_CALC.alignOrientation(recentOrientation, orientation);
            double deltaOut = orientation - recentOrientation;
            this.prevInstruction = ((RoundaboutInstruction)this.prevInstruction).setRadian(deltaInOut).setDirOfRotation(deltaOut).setExited();
            this.prevInstructionName = this.prevName;
            this.prevName = name;
            this.prevAnnotation = annotation;
        } else {
            sign = this.getTurn(edge, baseNode, this.prevNode, adjNode, annotation, name);
            if (sign != Integer.MIN_VALUE) {
                double lon;
                GHPoint point;
                double lat;
                double currentOrientation;
                double diff;
                boolean isUTurn = false;
                int uTurnType = -98;
                if (!Double.isNaN(this.prevInstructionPrevOrientation) && this.prevInstruction.getDistance() < 35.0 && sign < 0 == this.prevInstruction.getSign() < 0 && (Math.abs(sign) == 1 || Math.abs(sign) == 2 || Math.abs(sign) == 3) && (Math.abs(this.prevInstruction.getSign()) == 1 || Math.abs(this.prevInstruction.getSign()) == 2 || Math.abs(this.prevInstruction.getSign()) == 3) && edge.get(this.accessEnc) != edge.getReverse(this.accessEnc) && InstructionsHelper.isNameSimilar(this.prevInstructionName, name) && (diff = Math.abs(this.prevInstructionPrevOrientation - (currentOrientation = AngleCalc.ANGLE_CALC.calcOrientation(this.prevLat, this.prevLon, lat = (point = InstructionsHelper.getPointForOrientationCalculation(edge, this.nodeAccess)).getLat(), lon = point.getLon(), false)))) > 2.827433388230814 && diff < 3.455751918948773) {
                    isUTurn = true;
                    uTurnType = sign < 0 ? -8 : 8;
                }
                if (isUTurn) {
                    this.prevInstruction.setSign(uTurnType);
                    this.prevInstruction.setName(name);
                } else {
                    this.prevInstruction = new Instruction(sign, name, annotation, new PointList(10, this.nodeAccess.is3D()));
                    this.prevInstructionPrevOrientation = this.prevOrientation;
                    this.prevInstructionName = this.prevName;
                    this.ways.add(this.prevInstruction);
                    this.prevAnnotation = annotation;
                }
            }
            this.prevName = name;
        }
        this.updatePointsAndInstruction(edge, wayGeo);
        if (wayGeo.getSize() <= 2) {
            this.doublePrevLat = this.prevLat;
            this.doublePrevLon = this.prevLon;
        } else {
            int beforeLast = wayGeo.getSize() - 2;
            this.doublePrevLat = wayGeo.getLatitude(beforeLast);
            this.doublePrevLon = wayGeo.getLongitude(beforeLast);
        }
        this.prevInRoundabout = isRoundabout;
        this.prevNode = baseNode;
        this.prevLat = adjLat;
        this.prevLon = adjLon;
        this.prevEdge = edge;
    }

    @Override
    public void finish() {
        if (this.prevInRoundabout) {
            double orientation = AngleCalc.ANGLE_CALC.calcOrientation(this.doublePrevLat, this.doublePrevLon, this.prevLat, this.prevLon);
            orientation = AngleCalc.ANGLE_CALC.alignOrientation(this.prevOrientation, orientation);
            double delta = orientation - this.prevOrientation;
            ((RoundaboutInstruction)this.prevInstruction).setRadian(delta);
        }
        FinishInstruction finishInstruction = new FinishInstruction(this.nodeAccess, this.prevEdge.getAdjNode());
        finishInstruction.setExtraInfo("last_heading", AngleCalc.ANGLE_CALC.calcAzimuth(this.doublePrevLat, this.doublePrevLon, this.prevLat, this.prevLon));
        this.ways.add(finishInstruction);
    }

    private int getTurn(EdgeIteratorState edge, int baseNode, int prevNode, int adjNode, InstructionAnnotation annotation, String name) {
        InstructionsOutgoingEdges outgoingEdges;
        int nrOfPossibleTurns;
        GHPoint point = InstructionsHelper.getPointForOrientationCalculation(edge, this.nodeAccess);
        double lat = point.getLat();
        double lon = point.getLon();
        this.prevOrientation = AngleCalc.ANGLE_CALC.calcOrientation(this.doublePrevLat, this.doublePrevLon, this.prevLat, this.prevLon);
        int sign = InstructionsHelper.calculateSign(this.prevLat, this.prevLon, lat, lon, this.prevOrientation);
        boolean forceInstruction = false;
        if (!annotation.equals(this.prevAnnotation) && !annotation.isEmpty()) {
            forceInstruction = true;
        }
        if ((nrOfPossibleTurns = (outgoingEdges = new InstructionsOutgoingEdges(this.prevEdge, edge, this.encoder, this.maxSpeedEnc, this.roadClassEnc, this.roadClassLinkEnc, this.crossingExplorer, this.nodeAccess, prevNode, baseNode, adjNode)).getAllowedTurns()) <= 1) {
            if (Math.abs(sign) > 1 && outgoingEdges.getVisibleTurns() > 1) {
                return sign;
            }
            return this.returnForcedInstructionOrIgnore(forceInstruction, sign);
        }
        if (Math.abs(sign) > 1) {
            if (InstructionsHelper.isNameSimilar(name, this.prevName) && outgoingEdges.outgoingEdgesAreSlowerByFactor(2.0)) {
                return this.returnForcedInstructionOrIgnore(forceInstruction, sign);
            }
            return sign;
        }
        if (this.prevEdge == null) {
            return sign;
        }
        boolean outgoingEdgesAreSlower = outgoingEdges.outgoingEdgesAreSlowerByFactor(1.0);
        EdgeIteratorState otherContinue = outgoingEdges.getOtherContinue(this.prevLat, this.prevLon, this.prevOrientation);
        double delta = InstructionsHelper.calculateOrientationDelta(this.prevLat, this.prevLon, lat, lon, this.prevOrientation);
        if (!(otherContinue == null || InstructionsHelper.isNameSimilar(name, this.prevName) && !InstructionsHelper.isNameSimilar(otherContinue.getName(), this.prevName) && outgoingEdgesAreSlower)) {
            RoadClass roadClass = edge.get(this.roadClassEnc);
            RoadClass prevRoadClass = this.prevEdge.get(this.roadClassEnc);
            RoadClass otherRoadClass = otherContinue.get(this.roadClassEnc);
            boolean link = edge.get(this.roadClassLinkEnc);
            boolean prevLink = this.prevEdge.get(this.roadClassLinkEnc);
            boolean otherLink = otherContinue.get(this.roadClassLinkEnc);
            if (!(roadClass != RoadClass.MOTORWAY && roadClass != RoadClass.TRUNK && roadClass != RoadClass.PRIMARY && roadClass != RoadClass.SECONDARY && roadClass != RoadClass.TERTIARY || roadClass != prevRoadClass || link != prevLink || otherRoadClass == prevRoadClass && otherLink == prevLink)) {
                return this.returnForcedInstructionOrIgnore(forceInstruction, sign);
            }
            GHPoint tmpPoint = InstructionsHelper.getPointForOrientationCalculation(otherContinue, this.nodeAccess);
            double otherDelta = InstructionsHelper.calculateOrientationDelta(this.prevLat, this.prevLon, tmpPoint.getLat(), tmpPoint.getLon(), this.prevOrientation);
            if (Math.abs(delta) < 0.1 && Math.abs(otherDelta) > 0.15 && InstructionsHelper.isNameSimilar(name, this.prevName)) {
                return 0;
            }
            if (otherDelta < delta) {
                return -7;
            }
            return 7;
        }
        if (!outgoingEdgesAreSlower && (Math.abs(delta) > 0.6 || outgoingEdges.isLeavingCurrentStreet(this.prevName, name))) {
            return sign;
        }
        return this.returnForcedInstructionOrIgnore(forceInstruction, sign);
    }

    private int returnForcedInstructionOrIgnore(boolean forceInstruction, int sign) {
        if (forceInstruction) {
            return sign;
        }
        return Integer.MIN_VALUE;
    }

    private void updatePointsAndInstruction(EdgeIteratorState edge, PointList pl) {
        int len = pl.size() - 1;
        for (int i = 0; i < len; ++i) {
            this.prevInstruction.getPoints().add(pl, i);
        }
        double newDist = edge.getDistance();
        this.prevInstruction.setDistance(newDist + this.prevInstruction.getDistance());
        this.prevInstruction.setTime(this.weighting.calcEdgeMillis(edge, false) + this.prevInstruction.getTime());
    }
}

