/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.AngleCalc;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.PointList;

public class HeadingResolver {
    private final EdgeExplorer edgeExplorer;
    private double toleranceRad = HeadingResolver.deg2Rad(100.0);

    public HeadingResolver(Graph graph) {
        this.edgeExplorer = graph.createEdgeExplorer();
    }

    public IntArrayList getEdgesWithDifferentHeading(int baseNode, double heading) {
        double xAxisAngle = AngleCalc.ANGLE_CALC.convertAzimuth2xaxisAngle(heading);
        IntArrayList edges = new IntArrayList(1);
        EdgeIterator iter = this.edgeExplorer.setBaseNode(baseNode);
        while (iter.next()) {
            PointList points = iter.fetchWayGeometry(FetchMode.ALL);
            double orientation = AngleCalc.ANGLE_CALC.calcOrientation(points.getLat(0), points.getLon(0), points.getLat(1), points.getLon(1));
            double diff = Math.abs((orientation = AngleCalc.ANGLE_CALC.alignOrientation(xAxisAngle, orientation)) - xAxisAngle);
            if (!(diff > this.toleranceRad)) continue;
            edges.add(iter.getEdge());
        }
        return edges;
    }

    public HeadingResolver setTolerance(double tolerance) {
        this.toleranceRad = HeadingResolver.deg2Rad(tolerance);
        return this;
    }

    private static double deg2Rad(double deg) {
        return Math.toRadians(deg);
    }
}

