/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Fare;
import com.google.transit.realtime.GtfsRealtime;
import com.graphhopper.gtfs.GtfsStorageI;
import com.graphhopper.storage.Directory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.zip.ZipFile;
import org.mapdb.Bind;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GtfsStorage
implements GtfsStorageI {
    private static final Logger LOGGER = LoggerFactory.getLogger(GtfsStorage.class);
    private boolean isClosed = false;
    private Directory dir;
    private Set<String> gtfsFeedIds;
    private Map<String, GTFSFeed> gtfsFeeds = new HashMap<String, GTFSFeed>();
    private HTreeMap<Validity, Integer> operatingDayPatterns;
    private Bind.MapWithModificationListener<FeedIdWithTimezone, Integer> timeZones;
    private Map<Integer, FeedIdWithTimezone> readableTimeZones;
    private Map<Integer, byte[]> tripDescriptors;
    private Map<Integer, Integer> stopSequences;
    private Map<Integer, GtfsStorageI.PlatformDescriptor> platformDescriptorsByEdge;
    private Map<String, Fare> fares;
    private Map<String, int[]> boardEdgesForTrip;
    private Map<String, int[]> leaveEdgesForTrip;
    private Map<FeedIdWithStopId, Integer> stationNodes;
    private DB data;

    GtfsStorage(Directory dir) {
        this.dir = dir;
    }

    boolean loadExisting() {
        File file = new File(this.dir.getLocation() + "/transit_schedule");
        if (!file.exists()) {
            return false;
        }
        this.data = ((DBMaker)((DBMaker)((DBMaker)DBMaker.newFileDB(file).transactionDisable()).mmapFileEnable()).readOnly()).make();
        this.init();
        for (String gtfsFeedId : this.gtfsFeedIds) {
            File dbFile = new File(this.dir.getLocation() + "/" + gtfsFeedId);
            if (!dbFile.exists()) {
                throw new RuntimeException(String.format("The mapping of the gtfsFeeds in the transit_schedule DB does not reflect the files in %s. dbFile %s is missing.", this.dir.getLocation(), dbFile.getName()));
            }
            GTFSFeed feed = new GTFSFeed(dbFile);
            this.gtfsFeeds.put(gtfsFeedId, feed);
        }
        LocalDate latestStartDate = LocalDate.ofEpochDay(this.gtfsFeeds.values().stream().mapToLong(f -> f.getStartDate().toEpochDay()).max().getAsLong());
        LocalDate earliestEndDate = LocalDate.ofEpochDay(this.gtfsFeeds.values().stream().mapToLong(f -> f.getEndDate().toEpochDay()).min().getAsLong());
        LOGGER.info("Calendar range covered by all feeds: {} till {}", (Object)latestStartDate, (Object)earliestEndDate);
        return true;
    }

    void create() {
        this.dir.create();
        File file = new File(this.dir.getLocation() + "/transit_schedule");
        try {
            Files.deleteIfExists(file.toPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.data = ((DBMaker)((DBMaker)((DBMaker)DBMaker.newFileDB(file).transactionDisable()).mmapFileEnable()).asyncWriteEnable()).make();
        this.init();
    }

    private void init() {
        this.gtfsFeedIds = this.data.getHashSet("gtfsFeeds");
        this.operatingDayPatterns = this.data.getHashMap("validities");
        this.timeZones = this.data.getHashMap("timeZones");
        HashMap readableTimeZones = new HashMap();
        for (Map.Entry entry : this.timeZones.entrySet()) {
            readableTimeZones.put(entry.getValue(), entry.getKey());
        }
        Bind.mapInverse(this.timeZones, readableTimeZones);
        this.readableTimeZones = Collections.unmodifiableMap(readableTimeZones);
        this.tripDescriptors = this.data.getTreeMap("tripDescriptors");
        this.stopSequences = this.data.getTreeMap("stopSequences");
        this.fares = this.data.getTreeMap("fares");
        this.boardEdgesForTrip = this.data.getHashMap("boardEdgesForTrip");
        this.leaveEdgesForTrip = this.data.getHashMap("leaveEdgesForTrip");
        this.stationNodes = this.data.getHashMap("stationNodes");
        this.platformDescriptorsByEdge = this.data.getHashMap("routes");
    }

    void loadGtfsFromZipFile(String id, ZipFile zipFile) {
        File dbFile = new File(this.dir.getLocation() + "/" + id);
        try {
            Files.deleteIfExists(dbFile.toPath());
            GTFSFeed feed = new GTFSFeed(dbFile);
            feed.loadFromFileAndLogErrors(zipFile);
            this.gtfsFeeds.put(id, feed);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.gtfsFeedIds.add(id);
    }

    public void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            this.data.close();
            for (GTFSFeed feed : this.gtfsFeeds.values()) {
                feed.close();
            }
        }
    }

    @Override
    public Map<Validity, Integer> getOperatingDayPatterns() {
        return this.operatingDayPatterns;
    }

    @Override
    public Map<Integer, FeedIdWithTimezone> getTimeZones() {
        return this.readableTimeZones;
    }

    @Override
    public Map<FeedIdWithTimezone, Integer> getWritableTimeZones() {
        return this.timeZones;
    }

    @Override
    public Map<Integer, byte[]> getTripDescriptors() {
        return this.tripDescriptors;
    }

    @Override
    public Map<Integer, Integer> getStopSequences() {
        return this.stopSequences;
    }

    @Override
    public Map<String, int[]> getBoardEdgesForTrip() {
        return this.boardEdgesForTrip;
    }

    @Override
    public Map<String, int[]> getAlightEdgesForTrip() {
        return this.leaveEdgesForTrip;
    }

    @Override
    public Map<Integer, GtfsStorageI.PlatformDescriptor> getPlatformDescriptorByEdge() {
        return this.platformDescriptorsByEdge;
    }

    @Override
    public Map<String, Fare> getFares() {
        return this.fares;
    }

    @Override
    public Map<String, GTFSFeed> getGtfsFeeds() {
        return Collections.unmodifiableMap(this.gtfsFeeds);
    }

    @Override
    public Map<FeedIdWithStopId, Integer> getStationNodes() {
        return this.stationNodes;
    }

    static String tripKey(GtfsRealtime.TripDescriptor tripDescriptor, boolean isFrequencyBased) {
        if (isFrequencyBased) {
            return tripDescriptor.getTripId() + tripDescriptor.getStartTime();
        }
        return tripDescriptor.getTripId();
    }

    public static enum EdgeType {
        HIGHWAY,
        ENTER_TIME_EXPANDED_NETWORK,
        LEAVE_TIME_EXPANDED_NETWORK,
        ENTER_PT,
        EXIT_PT,
        HOP,
        DWELL,
        BOARD,
        ALIGHT,
        OVERNIGHT,
        TRANSFER,
        WAIT,
        WAIT_ARRIVAL;

    }

    static class FeedIdWithStopId
    implements Serializable {
        final String feedId;
        final String stopId;

        FeedIdWithStopId(String feedId, String stopId) {
            this.feedId = feedId;
            this.stopId = stopId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FeedIdWithStopId that = (FeedIdWithStopId)o;
            return this.feedId.equals(that.feedId) && this.stopId.equals(that.stopId);
        }

        public int hashCode() {
            return Objects.hash(this.feedId, this.stopId);
        }
    }

    static class FeedIdWithTimezone
    implements Serializable {
        final String feedId;
        final ZoneId zoneId;

        FeedIdWithTimezone(String feedId, ZoneId zoneId) {
            this.feedId = feedId;
            this.zoneId = zoneId;
        }

        public boolean equals(Object other) {
            if (!(other instanceof FeedIdWithTimezone)) {
                return false;
            }
            FeedIdWithTimezone v = (FeedIdWithTimezone)other;
            return this.feedId.equals(v.feedId) && this.zoneId.equals(v.zoneId);
        }

        public int hashCode() {
            return Objects.hash(this.feedId, this.zoneId);
        }
    }

    public static class Validity
    implements Serializable {
        final BitSet validity;
        final ZoneId zoneId;
        final LocalDate start;

        Validity(BitSet validity, ZoneId zoneId, LocalDate start) {
            this.validity = validity;
            this.zoneId = zoneId;
            this.start = start;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Validity)) {
                return false;
            }
            Validity v = (Validity)other;
            return this.validity.equals(v.validity) && this.zoneId.equals(v.zoneId) && this.start.equals(v.start);
        }

        public int hashCode() {
            return Objects.hash(this.validity, this.zoneId, this.start);
        }
    }
}

