/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.model;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.error.GeneralError;
import com.conveyal.gtfs.model.Entity;
import java.io.IOException;
import java.net.URL;
import java.time.LocalDate;

public class FeedInfo
extends Entity
implements Cloneable {
    private static final long serialVersionUID = 8718856987299076452L;
    public String feed_id = "NONE";
    public String feed_publisher_name;
    public URL feed_publisher_url;
    public String feed_lang;
    public LocalDate feed_start_date;
    public LocalDate feed_end_date;
    public String feed_version;

    public FeedInfo clone() {
        try {
            return (FeedInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Loader
    extends Entity.Loader<FeedInfo> {
        public Loader(GTFSFeed feed) {
            super(feed, "feed_info");
        }

        @Override
        protected boolean isRequired() {
            return false;
        }

        @Override
        public void loadOneRow() throws IOException {
            FeedInfo fi = new FeedInfo();
            fi.sourceFileLine = this.row + 1L;
            fi.feed_id = this.getStringField("feed_id", false);
            fi.feed_publisher_name = this.getStringField("feed_publisher_name", true);
            fi.feed_publisher_url = this.getUrlField("feed_publisher_url", true);
            fi.feed_lang = this.getStringField("feed_lang", true);
            fi.feed_start_date = this.getDateField("feed_start_date", false);
            fi.feed_end_date = this.getDateField("feed_end_date", false);
            fi.feed_version = this.getStringField("feed_version", false);
            fi.feed = this.feed;
            if (this.feed.feedInfo.isEmpty()) {
                this.feed.feedInfo.put("NONE", fi);
                this.feed.feedId = fi.feed_id;
            } else {
                this.feed.errors.add(new GeneralError(this.tableName, this.row, null, "FeedInfo contains more than one record."));
            }
        }
    }
}

