/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util.details;

import com.graphhopper.routing.querygraph.VirtualEdgeIteratorState;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.details.AbstractPathDetailsBuilder;

public class EdgeKeyDetails
extends AbstractPathDetailsBuilder {
    private int edgeKey = -1;

    public EdgeKeyDetails() {
        super("edge_key");
    }

    @Override
    public boolean isEdgeDifferentToLastEdge(EdgeIteratorState edge) {
        int newEdgeKey = EdgeKeyDetails.getEdgeKey(edge);
        if (newEdgeKey != this.edgeKey) {
            this.edgeKey = newEdgeKey;
            return true;
        }
        return false;
    }

    @Override
    public Object getCurrentValue() {
        return this.edgeKey;
    }

    static int getEdgeKey(EdgeIteratorState edge) {
        if (edge instanceof VirtualEdgeIteratorState) {
            return ((VirtualEdgeIteratorState)edge).getOriginalEdgeKey();
        }
        return edge.getEdge() * 2 + (edge.get(EdgeIteratorState.REVERSE_STATE) ? 1 : 0);
    }
}

