/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting.custom;

import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.util.CustomModel;
import com.graphhopper.routing.weighting.custom.BooleanToValueEntry;
import com.graphhopper.routing.weighting.custom.DecimalToValueEntry;
import com.graphhopper.routing.weighting.custom.EdgeToValueEntry;
import com.graphhopper.routing.weighting.custom.EnumToValueEntry;
import com.graphhopper.routing.weighting.custom.GeoToValueEntry;
import com.graphhopper.routing.weighting.custom.IntToValueEntry;
import com.graphhopper.routing.weighting.custom.PriorityCalculator;
import com.graphhopper.util.EdgeIteratorState;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;

final class SpeedCalculator {
    private final List<EdgeToValueEntry> speedFactorList = new ArrayList<EdgeToValueEntry>();
    private final List<EdgeToValueEntry> maxSpeedList = new ArrayList<EdgeToValueEntry>();
    private final DecimalEncodedValue avgSpeedEnc;
    private final double maxSpeed;
    private final double maxSpeedFallback;

    public SpeedCalculator(double maxSpeed, CustomModel customModel, DecimalEncodedValue avgSpeedEnc, EncodedValueLookup lookup) {
        EncodedValue encodedValue;
        Object value;
        String key;
        this.maxSpeed = maxSpeed;
        this.maxSpeedFallback = customModel.getMaxSpeedFallback() == null ? maxSpeed : customModel.getMaxSpeedFallback();
        this.avgSpeedEnc = avgSpeedEnc;
        if (this.maxSpeedFallback > maxSpeed) {
            throw new IllegalArgumentException("max_speed_fallback cannot be bigger than max_speed " + maxSpeed);
        }
        for (Map.Entry<String, Object> entry : customModel.getMaxSpeed().entrySet()) {
            key = entry.getKey();
            String maxSpeedKey = "max_speed." + key;
            value = entry.getValue();
            if (value == null) {
                throw new IllegalArgumentException("Missing value for " + key + " in 'priority'");
            }
            if (key.startsWith("area_")) {
                if (!(value instanceof Number)) {
                    throw new IllegalArgumentException(maxSpeedKey + ": area entry requires number value but was: " + value.getClass().getSimpleName());
                }
                Geometry geometry = GeoToValueEntry.pickGeometry(customModel, key);
                this.maxSpeedList.add(GeoToValueEntry.create(maxSpeedKey, new PreparedGeometryFactory().create(geometry), (Number)value, maxSpeed, 0.0, maxSpeed));
                continue;
            }
            if (!(value instanceof Map)) {
                throw new IllegalArgumentException(maxSpeedKey + ": non-root entries require a map but was: " + value.getClass().getSimpleName());
            }
            double defaultMaxSpeed = maxSpeed;
            double minMaxSpeed = 0.0;
            double maxMaxSpeed = maxSpeed;
            encodedValue = PriorityCalculator.getEV(lookup, "max_speed", key);
            if (encodedValue instanceof EnumEncodedValue) {
                this.maxSpeedList.add(EnumToValueEntry.create(maxSpeedKey, (EnumEncodedValue)encodedValue, (Map)value, defaultMaxSpeed, 0.0, maxMaxSpeed));
                continue;
            }
            if (encodedValue instanceof DecimalEncodedValue) {
                this.maxSpeedList.add(DecimalToValueEntry.create(maxSpeedKey, (DecimalEncodedValue)encodedValue, (Map)value, defaultMaxSpeed, 0.0, maxMaxSpeed));
                continue;
            }
            if (encodedValue instanceof BooleanEncodedValue) {
                this.maxSpeedList.add(BooleanToValueEntry.create(maxSpeedKey, (BooleanEncodedValue)encodedValue, (Map)value, defaultMaxSpeed, 0.0, maxMaxSpeed));
                continue;
            }
            if (encodedValue instanceof IntEncodedValue) {
                this.maxSpeedList.add(IntToValueEntry.create(maxSpeedKey, (IntEncodedValue)encodedValue, (Map)value, defaultMaxSpeed, 0.0, maxMaxSpeed));
                continue;
            }
            throw new IllegalArgumentException("The encoded value '" + key + "' used in 'max_speed' is of type " + encodedValue.getClass().getSimpleName() + ", but only types enum, decimal and boolean are supported.");
        }
        for (Map.Entry<String, Object> entry : customModel.getSpeedFactor().entrySet()) {
            key = entry.getKey();
            String speedFactorKey = "speed_factor." + key;
            value = entry.getValue();
            if (value == null) {
                throw new IllegalArgumentException("Missing value for " + key + " in 'priority'");
            }
            if (key.startsWith("area_")) {
                if (!(value instanceof Number)) {
                    throw new IllegalArgumentException(speedFactorKey + ": area entry requires number value but was: " + value.getClass().getSimpleName());
                }
                Geometry geometry = GeoToValueEntry.pickGeometry(customModel, key);
                this.speedFactorList.add(GeoToValueEntry.create(speedFactorKey, new PreparedGeometryFactory().create(geometry), (Number)value, 1.0, 0.0, 1.0));
                continue;
            }
            if (!(value instanceof Map)) {
                throw new IllegalArgumentException(speedFactorKey + ": non-root entries require a map but was: " + value.getClass().getSimpleName());
            }
            double defaultSpeedFactor = 1.0;
            double minSpeedFactor = 0.0;
            double maxSpeedFactor = 1.0;
            encodedValue = PriorityCalculator.getEV(lookup, "speed_factor", key);
            if (encodedValue instanceof EnumEncodedValue) {
                this.speedFactorList.add(EnumToValueEntry.create(speedFactorKey, (EnumEncodedValue)encodedValue, (Map)value, 1.0, 0.0, 1.0));
                continue;
            }
            if (encodedValue instanceof DecimalEncodedValue) {
                this.speedFactorList.add(DecimalToValueEntry.create(speedFactorKey, (DecimalEncodedValue)encodedValue, (Map)value, 1.0, 0.0, 1.0));
                continue;
            }
            if (encodedValue instanceof BooleanEncodedValue) {
                this.speedFactorList.add(BooleanToValueEntry.create(speedFactorKey, (BooleanEncodedValue)encodedValue, (Map)value, 1.0, 0.0, 1.0));
                continue;
            }
            if (encodedValue instanceof IntEncodedValue) {
                this.speedFactorList.add(IntToValueEntry.create(speedFactorKey, (IntEncodedValue)encodedValue, (Map)value, 1.0, 0.0, 1.0));
                continue;
            }
            throw new IllegalArgumentException("The encoded value '" + key + "' used in 'speed_factor' is of type " + encodedValue.getClass().getSimpleName() + ", but only types enum, decimal and boolean are supported.");
        }
    }

    public double getMaxSpeed() {
        return this.maxSpeed;
    }

    public double calcSpeed(EdgeIteratorState edge, boolean reverse) {
        EdgeToValueEntry entry;
        double factorValue;
        double speed;
        double d = speed = reverse ? edge.getReverse(this.avgSpeedEnc) : edge.get(this.avgSpeedEnc);
        if (Double.isInfinite(speed) || Double.isNaN(speed) || speed < 0.0) {
            throw new IllegalStateException("Invalid estimated speed " + speed);
        }
        for (int i = 0; i < this.speedFactorList.size() && (speed *= (factorValue = (entry = this.speedFactorList.get(i)).getValue(edge, reverse))) != 0.0; ++i) {
        }
        boolean applied = false;
        for (int i = 0; i < this.maxSpeedList.size(); ++i) {
            EdgeToValueEntry entry2 = this.maxSpeedList.get(i);
            double maxValue = entry2.getValue(edge, reverse);
            if (!(speed > maxValue)) continue;
            applied = true;
            speed = maxValue;
        }
        if (!applied && speed > this.maxSpeedFallback) {
            return this.maxSpeedFallback;
        }
        return Math.min(speed, this.maxSpeed);
    }
}

