/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.spatialrules;

import com.graphhopper.routing.ev.Country;
import com.graphhopper.routing.util.spatialrules.SpatialRule;
import com.graphhopper.routing.util.spatialrules.SpatialRuleLookupBuilder;
import com.graphhopper.routing.util.spatialrules.countries.AustriaSpatialRule;
import com.graphhopper.routing.util.spatialrules.countries.GermanySpatialRule;
import com.graphhopper.util.Helper;
import java.util.List;
import org.locationtech.jts.geom.Polygon;

public class CountriesSpatialRuleFactory
implements SpatialRuleLookupBuilder.SpatialRuleFactory {
    @Override
    public SpatialRule createSpatialRule(String id, List<Polygon> polygons) {
        try {
            Country country = Country.valueOf(Helper.toUpperCase((String)id));
            switch (country) {
                case AUT: {
                    return new AustriaSpatialRule(polygons);
                }
                case DEU: {
                    return new GermanySpatialRule(polygons);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

