/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting.custom;

import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.util.CustomModel;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.weighting.AbstractWeighting;
import com.graphhopper.routing.weighting.TurnCostProvider;
import com.graphhopper.routing.weighting.custom.PriorityCalculator;
import com.graphhopper.routing.weighting.custom.SpeedCalculator;
import com.graphhopper.util.EdgeIteratorState;

public final class CustomWeighting
extends AbstractWeighting {
    public static final String NAME = "custom";
    public static final String CATCH_ALL = "*";
    private static final double SPEED_CONV = 3.6;
    private final BooleanEncodedValue baseVehicleAccessEnc;
    private final double maxSpeed;
    private final double distanceInfluence;
    private final double headingPenaltySeconds;
    private final SpeedCalculator speedCalculator;
    private final PriorityCalculator priorityCalculator;

    public CustomWeighting(FlagEncoder baseFlagEncoder, EncodedValueLookup lookup, TurnCostProvider turnCostProvider, CustomModel customModel) {
        super(baseFlagEncoder, turnCostProvider);
        if (customModel == null) {
            throw new IllegalStateException("CustomModel cannot be null");
        }
        this.headingPenaltySeconds = customModel.getHeadingPenalty();
        this.baseVehicleAccessEnc = baseFlagEncoder.getAccessEnc();
        this.speedCalculator = new SpeedCalculator(baseFlagEncoder.getMaxSpeed(), customModel, baseFlagEncoder.getAverageSpeedEnc(), lookup);
        this.maxSpeed = this.speedCalculator.getMaxSpeed() / 3.6;
        this.priorityCalculator = new PriorityCalculator(customModel, lookup);
        this.distanceInfluence = customModel.getDistanceInfluence() / 1000.0;
        if (this.distanceInfluence < 0.0) {
            throw new IllegalArgumentException("maximum distance_influence cannot be negative " + this.distanceInfluence);
        }
    }

    @Override
    public double getMinWeight(double distance) {
        return distance / this.maxSpeed + distance * this.distanceInfluence;
    }

    @Override
    public double calcEdgeWeight(EdgeIteratorState edgeState, boolean reverse) {
        double distance = edgeState.getDistance();
        double seconds = this.calcSeconds(distance, edgeState, reverse);
        if (Double.isInfinite(seconds)) {
            return Double.POSITIVE_INFINITY;
        }
        double distanceCosts = distance * this.distanceInfluence;
        if (Double.isInfinite(distanceCosts)) {
            return Double.POSITIVE_INFINITY;
        }
        return seconds / this.priorityCalculator.calcPriority(edgeState, reverse) + distanceCosts;
    }

    double calcSeconds(double distance, EdgeIteratorState edgeState, boolean reverse) {
        if (edgeState.getBaseNode() == edgeState.getAdjNode()) {
            reverse = false;
        }
        if (reverse ? !edgeState.getReverse(this.baseVehicleAccessEnc) : !edgeState.get(this.baseVehicleAccessEnc)) {
            return Double.POSITIVE_INFINITY;
        }
        double speed = this.speedCalculator.calcSpeed(edgeState, reverse);
        if (speed == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (speed < 0.0) {
            throw new IllegalArgumentException("Speed cannot be negative");
        }
        double seconds = distance / speed * 3.6;
        return edgeState.get(EdgeIteratorState.UNFAVORED_EDGE) ? seconds + this.headingPenaltySeconds : seconds;
    }

    @Override
    public long calcEdgeMillis(EdgeIteratorState edgeState, boolean reverse) {
        return Math.round(this.calcSeconds(edgeState.getDistance(), edgeState, reverse) * 1000.0);
    }

    @Override
    public String getName() {
        return NAME;
    }
}

