/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.spatialrules;

import com.graphhopper.routing.ev.RoadAccess;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.util.spatialrules.SpatialRule;
import com.graphhopper.routing.util.spatialrules.TransportationMode;
import java.util.Collections;
import java.util.List;

public class SpatialRuleSet {
    public static final SpatialRuleSet EMPTY = new SpatialRuleSet(Collections.emptyList(), 0);
    private final List<SpatialRule> rules;
    private final int spatialId;

    public SpatialRuleSet(List<SpatialRule> rules, int spatialId) {
        this.rules = Collections.unmodifiableList(rules);
        this.spatialId = spatialId;
    }

    public double getMaxSpeed(RoadClass roadClass, TransportationMode transport, double currentMaxSpeed) {
        double value = currentMaxSpeed;
        for (SpatialRule rule : this.rules) {
            value = rule.getMaxSpeed(roadClass, transport, value);
        }
        return value;
    }

    public RoadAccess getAccess(RoadClass roadClass, TransportationMode transport, RoadAccess currentRoadAccess) {
        RoadAccess value = currentRoadAccess;
        for (SpatialRule rule : this.rules) {
            value = rule.getAccess(roadClass, transport, value);
        }
        return value;
    }

    public List<SpatialRule> getRules() {
        return this.rules;
    }

    public int getSpatialId() {
        return this.spatialId;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SpatialRuleSet [rules=");
        builder.append(this.rules);
        builder.append("]");
        return builder.toString();
    }
}

