/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.spatialrules;

import com.graphhopper.GraphHopper;
import com.graphhopper.json.geo.JsonFeature;
import com.graphhopper.json.geo.JsonFeatureCollection;
import com.graphhopper.routing.ev.Country;
import com.graphhopper.routing.util.parsers.SpatialRuleParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.routing.util.parsers.TagParserFactory;
import com.graphhopper.routing.util.spatialrules.CountriesSpatialRuleFactory;
import com.graphhopper.routing.util.spatialrules.SpatialRuleLookup;
import com.graphhopper.routing.util.spatialrules.SpatialRuleLookupBuilder;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialRuleLookupHelper {
    private static final Logger logger = LoggerFactory.getLogger(SpatialRuleLookupHelper.class);
    static String JSON_ID_FIELD = "ISO_A3";

    static List<JsonFeatureCollection> reorder(List<JsonFeatureCollection> jsonFeatureCollections, List<String> subset) {
        LinkedHashMap<String, JsonFeature> map = new LinkedHashMap<String, JsonFeature>();
        for (JsonFeatureCollection jsonFeatureCollection : jsonFeatureCollections) {
            for (JsonFeature jsonFeature : jsonFeatureCollection.getFeatures()) {
                String id = (String)jsonFeature.getProperty(JSON_ID_FIELD);
                if (Helper.isEmpty((String)id)) continue;
                map.put(Helper.toLowerCase((String)id), jsonFeature);
            }
        }
        if (map.isEmpty()) {
            throw new IllegalArgumentException("Input JsonFeatureCollection cannot be empty. Subset: " + subset + ", original.size:" + jsonFeatureCollections.size());
        }
        ArrayList<JsonFeature> newCollection = new ArrayList<JsonFeature>();
        for (String val : subset) {
            JsonFeature jsonFeature;
            jsonFeature = (JsonFeature)map.get(val);
            if (jsonFeature == null) {
                throw new IllegalArgumentException("SpatialRule does not exist. ID: " + val);
            }
            newCollection.add(jsonFeature);
        }
        JsonFeatureCollection jsonFeatureCollection = new JsonFeatureCollection();
        jsonFeatureCollection.getFeatures().addAll(newCollection);
        return Arrays.asList(jsonFeatureCollection);
    }

    public static void buildAndInjectCountrySpatialRules(GraphHopper graphHopper, Envelope maxBounds, List<JsonFeatureCollection> jsonFeatureCollections) {
        ArrayList<String> subset = new ArrayList<String>();
        for (Country c : Country.values()) {
            if (c == Country.DEFAULT) continue;
            subset.add(c.toString());
        }
        final SpatialRuleLookup index = SpatialRuleLookupBuilder.buildIndex(SpatialRuleLookupHelper.reorder(jsonFeatureCollections, subset), JSON_ID_FIELD, new CountriesSpatialRuleFactory(), maxBounds);
        logger.info("Set spatial rule lookup with {} rules", (Object)index.getRules().size());
        final TagParserFactory oldTPF = graphHopper.getTagParserFactory();
        graphHopper.setTagParserFactory(new TagParserFactory(){

            @Override
            public TagParser create(String name, PMap configuration) {
                if (name.equals("country")) {
                    return new SpatialRuleParser(index, Country.create());
                }
                return oldTPF.create(name, configuration);
            }
        });
    }
}

