/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.carrotsearch.hppc.IntContainer;
import com.graphhopper.routing.ch.CHPreparationGraph;
import com.graphhopper.routing.ch.NodeBasedWitnessPathSearcher;
import com.graphhopper.routing.ch.NodeContractor;
import com.graphhopper.routing.ch.PrepareGraphEdgeExplorer;
import com.graphhopper.routing.ch.PrepareGraphEdgeIterator;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import com.graphhopper.util.StopWatch;
import java.util.Locale;

class NodeBasedNodeContractor
implements NodeContractor {
    private final CHPreparationGraph prepareGraph;
    private final Params params = new Params();
    private ShortcutHandler shortcutHandler;
    private PrepareGraphEdgeExplorer inEdgeExplorer;
    private PrepareGraphEdgeExplorer outEdgeExplorer;
    private PrepareGraphEdgeExplorer existingShortcutExplorer;
    private NodeBasedWitnessPathSearcher witnessPathSearcher;
    private int addedShortcutsCount;
    private long dijkstraCount;
    private final StopWatch dijkstraSW = new StopWatch();
    private double meanDegree;
    private int originalEdgesCount;
    private int shortcutsCount;

    NodeBasedNodeContractor(CHPreparationGraph prepareGraph, ShortcutHandler shortcutHandler, PMap pMap) {
        this.prepareGraph = prepareGraph;
        this.extractParams(pMap);
        this.shortcutHandler = shortcutHandler;
    }

    private void extractParams(PMap pMap) {
        this.params.edgeDifferenceWeight = pMap.getFloat("prepare.ch.node.edge_difference_weight", this.params.edgeDifferenceWeight);
        this.params.originalEdgesCountWeight = pMap.getFloat("prepare.ch.node.original_edge_count_weight", this.params.originalEdgesCountWeight);
    }

    @Override
    public void initFromGraph() {
        this.inEdgeExplorer = this.prepareGraph.createInEdgeExplorer();
        this.outEdgeExplorer = this.prepareGraph.createOutEdgeExplorer();
        this.existingShortcutExplorer = this.prepareGraph.createOutEdgeExplorer();
        this.witnessPathSearcher = new NodeBasedWitnessPathSearcher(this.prepareGraph);
    }

    @Override
    public void prepareContraction() {
        this.meanDegree = this.prepareGraph.getOriginalEdges() / this.prepareGraph.getNodes();
    }

    @Override
    public void close() {
        this.prepareGraph.close();
        this.shortcutHandler = null;
        this.inEdgeExplorer = null;
        this.outEdgeExplorer = null;
        this.existingShortcutExplorer = null;
        this.witnessPathSearcher.close();
    }

    @Override
    public float calculatePriority(int node) {
        this.shortcutsCount = 0;
        this.originalEdgesCount = 0;
        this.findAndHandleShortcuts(node, this::countShortcuts);
        int edgeDifference = this.shortcutsCount - this.prepareGraph.getDegree(node);
        return this.params.edgeDifferenceWeight * (float)edgeDifference + this.params.originalEdgesCountWeight * (float)this.originalEdgesCount;
    }

    @Override
    public IntContainer contractNode(int node) {
        long degree = this.findAndHandleShortcuts(node, this::addOrUpdateShortcut);
        this.insertShortcuts(node);
        this.meanDegree = (this.meanDegree * 2.0 + (double)degree) / 3.0;
        return this.prepareGraph.disconnect(node);
    }

    private void insertShortcuts(int node) {
        this.shortcutHandler.startContractingNode();
        PrepareGraphEdgeIterator iter = this.outEdgeExplorer.setBaseNode(node);
        while (iter.next()) {
            if (!iter.isShortcut()) continue;
            this.shortcutHandler.addOutShortcut(iter.getPrepareEdge(), node, iter.getAdjNode(), iter.getSkipped1(), iter.getSkipped2(), iter.getWeight());
        }
        iter = this.inEdgeExplorer.setBaseNode(node);
        while (iter.next()) {
            if (!iter.isShortcut()) continue;
            this.shortcutHandler.addInShortcut(iter.getPrepareEdge(), node, iter.getAdjNode(), iter.getSkipped2(), iter.getSkipped1(), iter.getWeight());
        }
        this.addedShortcutsCount += this.shortcutHandler.finishContractingNode();
    }

    @Override
    public void finishContraction() {
        this.shortcutHandler.finishContraction();
    }

    @Override
    public String getStatisticsString() {
        return String.format(Locale.ROOT, "meanDegree: %.2f, dijkstras: %10s, mem: %10s", this.meanDegree, Helper.nf((long)this.dijkstraCount), this.witnessPathSearcher.getMemoryUsageAsString());
    }

    private long findAndHandleShortcuts(int node, PrepareShortcutHandler handler) {
        int maxVisitedNodes = this.getMaxVisitedNodesEstimate();
        long degree = 0L;
        PrepareGraphEdgeIterator incomingEdges = this.inEdgeExplorer.setBaseNode(node);
        while (incomingEdges.next()) {
            double incomingEdgeWeight;
            int fromNode = incomingEdges.getAdjNode();
            if (fromNode == node || Double.isInfinite(incomingEdgeWeight = incomingEdges.getWeight())) continue;
            PrepareGraphEdgeIterator outgoingEdges = this.outEdgeExplorer.setBaseNode(node);
            this.witnessPathSearcher.clear();
            ++degree;
            while (outgoingEdges.next()) {
                double existingDirectWeight;
                int toNode = outgoingEdges.getAdjNode();
                if (toNode == node || fromNode == toNode || Double.isInfinite(existingDirectWeight = incomingEdgeWeight + outgoingEdges.getWeight())) continue;
                this.witnessPathSearcher.setWeightLimit(existingDirectWeight);
                this.witnessPathSearcher.setMaxVisitedNodes(maxVisitedNodes);
                this.witnessPathSearcher.ignoreNode(node);
                this.dijkstraSW.start();
                ++this.dijkstraCount;
                int endNode = this.witnessPathSearcher.findEndNode(fromNode, toNode);
                this.dijkstraSW.stop();
                if (endNode == toNode && this.witnessPathSearcher.getWeight(endNode) <= existingDirectWeight) continue;
                handler.handleShortcut(fromNode, toNode, existingDirectWeight, outgoingEdges.getPrepareEdge(), outgoingEdges.getOrigEdgeCount(), incomingEdges.getPrepareEdge(), incomingEdges.getOrigEdgeCount());
            }
        }
        return degree;
    }

    private void countShortcuts(int fromNode, int toNode, double existingDirectWeight, int outgoingEdge, int outOrigEdgeCount, int incomingEdge, int inOrigEdgeCount) {
        ++this.shortcutsCount;
        this.originalEdgesCount += inOrigEdgeCount + outOrigEdgeCount;
    }

    private void addOrUpdateShortcut(int fromNode, int toNode, double weight, int outgoingEdge, int outOrigEdgeCount, int incomingEdge, int inOrigEdgeCount) {
        boolean exists = false;
        PrepareGraphEdgeIterator iter = this.existingShortcutExplorer.setBaseNode(fromNode);
        while (iter.next()) {
            if (iter.getAdjNode() != toNode || !iter.isShortcut()) continue;
            exists = true;
            if (!(weight < iter.getWeight())) continue;
            iter.setWeight(weight);
            iter.setSkippedEdges(incomingEdge, outgoingEdge);
            iter.setOrigEdgeCount(inOrigEdgeCount + outOrigEdgeCount);
        }
        if (!exists) {
            this.prepareGraph.addShortcut(fromNode, toNode, -1, -1, incomingEdge, outgoingEdge, weight, inOrigEdgeCount + outOrigEdgeCount);
        }
    }

    @Override
    public long getAddedShortcutsCount() {
        return this.addedShortcutsCount;
    }

    @Override
    public long getDijkstraCount() {
        return this.dijkstraCount;
    }

    @Override
    public float getDijkstraSeconds() {
        return this.dijkstraSW.getCurrentSeconds();
    }

    private int getMaxVisitedNodesEstimate() {
        return (int)this.meanDegree * 100;
    }

    public static interface ShortcutHandler {
        public void startContractingNode();

        public void addOutShortcut(int var1, int var2, int var3, int var4, int var5, double var6);

        public void addInShortcut(int var1, int var2, int var3, int var4, int var5, double var6);

        public int finishContractingNode();

        public void finishContraction();
    }

    public static class Params {
        private float edgeDifferenceWeight = 10.0f;
        private float originalEdgesCountWeight = 1.0f;
    }

    @FunctionalInterface
    private static interface PrepareShortcutHandler {
        public void handleShortcut(int var1, int var2, double var3, int var5, int var6, int var7, int var8);
    }
}

