/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PointList;

public class DouglasPeucker {
    private double normedMaxDist;
    private DistanceCalc calc;
    private boolean approx;

    public DouglasPeucker() {
        this.setApproximation(true);
        this.setMaxDistance(1.0);
    }

    public void setApproximation(boolean a) {
        this.approx = a;
        this.calc = this.approx ? Helper.DIST_PLANE : Helper.DIST_EARTH;
    }

    public DouglasPeucker setMaxDistance(double dist) {
        this.normedMaxDist = this.calc.calcNormalizedDist(dist);
        return this;
    }

    public int simplify(PointList points) {
        return this.simplify(points, 0, points.size() - 1);
    }

    public int simplify(PointList points, int fromIndex, int lastIndex) {
        return this.simplify(points, fromIndex, lastIndex, true);
    }

    public int simplify(PointList points, int fromIndex, int lastIndex, boolean compress) {
        int removed = 0;
        int size = lastIndex - fromIndex;
        if (this.approx) {
            int delta = 500;
            int segments = size / delta + 1;
            int start = fromIndex;
            for (int i = 0; i < segments; ++i) {
                removed += this.subSimplify(points, start, Math.min(lastIndex, start + delta));
                start += delta;
            }
        } else {
            removed = this.subSimplify(points, fromIndex, lastIndex);
        }
        if (removed > 0 && compress) {
            DouglasPeucker.removeNaN(points);
        }
        return removed;
    }

    int subSimplify(PointList points, int fromIndex, int lastIndex) {
        if (lastIndex - fromIndex < 2) {
            return 0;
        }
        int indexWithMaxDist = -1;
        double maxDist = -1.0;
        double firstLat = points.getLatitude(fromIndex);
        double firstLon = points.getLongitude(fromIndex);
        double lastLat = points.getLatitude(lastIndex);
        double lastLon = points.getLongitude(lastIndex);
        for (int i = fromIndex + 1; i < lastIndex; ++i) {
            double lon;
            double dist;
            double lat = points.getLatitude(i);
            if (Double.isNaN(lat) || !(maxDist < (dist = this.calc.calcNormalizedEdgeDistance(lat, lon = points.getLongitude(i), firstLat, firstLon, lastLat, lastLon)))) continue;
            indexWithMaxDist = i;
            maxDist = dist;
        }
        if (indexWithMaxDist < 0) {
            throw new IllegalStateException("maximum not found in [" + fromIndex + "," + lastIndex + "]");
        }
        int counter = 0;
        if (maxDist < this.normedMaxDist) {
            for (int i = fromIndex + 1; i < lastIndex; ++i) {
                points.set(i, Double.NaN, Double.NaN, Double.NaN);
                ++counter;
            }
        } else {
            counter = this.subSimplify(points, fromIndex, indexWithMaxDist);
            counter += this.subSimplify(points, indexWithMaxDist, lastIndex);
        }
        return counter;
    }

    static void removeNaN(PointList pointList) {
        int curr = 0;
        for (int i = 0; i < pointList.size(); ++i) {
            if (Double.isNaN(pointList.getLatitude(i))) continue;
            pointList.set(curr, pointList.getLatitude(i), pointList.getLongitude(i), pointList.getElevation(i));
            ++curr;
        }
        pointList.trimToSize(curr);
    }
}

