/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage.index;

import com.carrotsearch.hppc.IntHashSet;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.storage.Storable;
import com.graphhopper.storage.index.QueryResult;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.shapes.BBox;

public interface LocationIndex
extends Storable<LocationIndex> {
    public LocationIndex setResolution(int var1);

    public LocationIndex prepareIndex();

    public QueryResult findClosest(double var1, double var3, EdgeFilter var5);

    public LocationIndex setApproximation(boolean var1);

    public void setSegmentSize(int var1);

    public void query(BBox var1, Visitor var2);

    public static abstract class EdgeVisitor
    extends Visitor {
        private final IntHashSet edgeIds = new IntHashSet();
        private final IntHashSet nodeIds = new IntHashSet();
        private final EdgeExplorer edgeExplorer;

        public EdgeVisitor(EdgeExplorer edgeExplorer) {
            this.edgeExplorer = edgeExplorer;
        }

        @Override
        public final void onNode(int nodeId) {
            if (!this.nodeIds.add(nodeId)) {
                return;
            }
            EdgeIterator iter = this.edgeExplorer.setBaseNode(nodeId);
            while (iter.next()) {
                if (!this.edgeIds.add(iter.getEdge())) continue;
                this.onEdge(iter, nodeId, iter.getAdjNode());
            }
        }

        public abstract void onEdge(EdgeIteratorState var1, int var2, int var3);
    }

    public static abstract class Visitor {
        public boolean isTileInfo() {
            return false;
        }

        public void onTile(BBox bbox, int depth) {
        }

        public abstract void onNode(int var1);
    }
}

