/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.CHGraph;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.RoutingCHEdgeExplorer;
import com.graphhopper.storage.RoutingCHEdgeIteratorImpl;
import com.graphhopper.storage.RoutingCHEdgeIteratorState;
import com.graphhopper.storage.RoutingCHEdgeIteratorStateImpl;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.util.EdgeIteratorState;

public class RoutingCHGraphImpl
implements RoutingCHGraph {
    private final Graph graph;
    private final CHGraph chGraph;
    private final Graph baseGraph;
    private final Weighting weighting;

    public RoutingCHGraphImpl(Graph graph, Weighting weighting) {
        this.graph = graph;
        this.chGraph = graph instanceof QueryGraph ? (CHGraph)((QueryGraph)graph).getMainGraph() : (CHGraph)graph;
        this.baseGraph = this.chGraph.getBaseGraph();
        this.weighting = weighting;
    }

    @Override
    public int getNodes() {
        return this.graph.getNodes();
    }

    @Override
    public int getEdges() {
        return this.graph.getEdges();
    }

    @Override
    public int getOriginalEdges() {
        return this.baseGraph.getEdges();
    }

    @Override
    public int getOtherNode(int edge, int node) {
        return this.graph.getOtherNode(edge, node);
    }

    @Override
    public boolean isAdjacentToNode(int edge, int node) {
        return this.graph.isAdjacentToNode(edge, node);
    }

    @Override
    public RoutingCHEdgeExplorer createInEdgeExplorer() {
        return RoutingCHEdgeIteratorImpl.inEdges(this.graph.createEdgeExplorer(), this.weighting);
    }

    @Override
    public RoutingCHEdgeExplorer createOutEdgeExplorer() {
        return RoutingCHEdgeIteratorImpl.outEdges(this.graph.createEdgeExplorer(), this.weighting);
    }

    @Override
    public RoutingCHEdgeExplorer createAllEdgeExplorer() {
        return RoutingCHEdgeIteratorImpl.allEdges(this.graph.createEdgeExplorer(), this.weighting);
    }

    @Override
    public RoutingCHEdgeExplorer createOriginalInEdgeExplorer() {
        return RoutingCHEdgeIteratorImpl.inEdges(this.graph.getBaseGraph().createEdgeExplorer(), this.weighting);
    }

    @Override
    public RoutingCHEdgeExplorer createOriginalOutEdgeExplorer() {
        return RoutingCHEdgeIteratorImpl.outEdges(this.graph.getBaseGraph().createEdgeExplorer(), this.weighting);
    }

    @Override
    public RoutingCHEdgeIteratorState getEdgeIteratorState(int edgeId, int adjNode) {
        EdgeIteratorState edgeState = this.graph.getEdgeIteratorState(edgeId, adjNode);
        return edgeState == null ? null : new RoutingCHEdgeIteratorStateImpl(edgeState, this.weighting);
    }

    @Override
    public int getLevel(int node) {
        return this.chGraph.getLevel(node);
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public Graph getBaseGraph() {
        return this.chGraph.getBaseGraph();
    }

    @Override
    public Weighting getWeighting() {
        return this.weighting;
    }

    @Override
    public boolean hasTurnCosts() {
        return this.weighting.hasTurnCosts();
    }

    @Override
    public double getTurnWeight(int edgeFrom, int nodeVia, int edgeTo) {
        return this.weighting.calcTurnWeight(edgeFrom, nodeVia, edgeTo);
    }
}

