/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.config.Profile;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.Weighting;

public class CHConfig {
    private final String chGraphName;
    private final Weighting weighting;
    private final boolean edgeBased;

    public static CHConfig nodeBased(String chGraphName, Weighting weighting) {
        return new CHConfig(chGraphName, weighting, false);
    }

    public static CHConfig edgeBased(String chGraphName, Weighting weighting) {
        return new CHConfig(chGraphName, weighting, true);
    }

    public CHConfig(String chGraphName, Weighting weighting, boolean edgeBased) {
        Profile.validateProfileName((String)chGraphName);
        this.chGraphName = chGraphName;
        this.weighting = weighting;
        this.edgeBased = edgeBased;
    }

    public Weighting getWeighting() {
        return this.weighting;
    }

    public boolean isEdgeBased() {
        return this.edgeBased;
    }

    public TraversalMode getTraversalMode() {
        return this.edgeBased ? TraversalMode.EDGE_BASED : TraversalMode.NODE_BASED;
    }

    public String toFileName() {
        return this.chGraphName;
    }

    public String toString() {
        return this.chGraphName;
    }

    public String getName() {
        return this.chGraphName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CHConfig chConfig = (CHConfig)o;
        return this.getName().equals(chConfig.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

