/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting.custom;

import com.graphhopper.json.geo.JsonFeature;
import com.graphhopper.routing.util.CustomModel;
import com.graphhopper.routing.weighting.custom.EdgeToValueEntry;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.Polygon;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.prep.PreparedGeometry;

final class GeoToValueEntry
implements EdgeToValueEntry {
    static final String AREA_PREFIX = "area_";
    private final Polygon ghPolygon;
    private final double value;
    private final double elseValue;

    private GeoToValueEntry(PreparedGeometry geometry, double value, double elseValue) {
        this.ghPolygon = new Polygon(geometry);
        this.value = value;
        this.elseValue = elseValue;
    }

    static Geometry pickGeometry(CustomModel customModel, String key) {
        String id = key.substring(AREA_PREFIX.length());
        JsonFeature feature = (JsonFeature)customModel.getAreas().get(id);
        if (feature == null) {
            throw new IllegalArgumentException("Cannot find area " + id);
        }
        return feature.getGeometry();
    }

    public static EdgeToValueEntry create(String name, PreparedGeometry preparedGeometry, Number value, double defaultValue, double minValue, double maxValue) {
        double number = value.doubleValue();
        if (number < minValue) {
            throw new IllegalArgumentException(name + " cannot be smaller than " + minValue + ", was " + number);
        }
        if (number > maxValue) {
            throw new IllegalArgumentException(name + " cannot be bigger than " + maxValue + ", was " + number);
        }
        return new GeoToValueEntry(preparedGeometry, number, defaultValue);
    }

    @Override
    public double getValue(EdgeIteratorState edgeState, boolean reverse) {
        BBox bbox = GHUtility.createBBox(edgeState);
        if (this.ghPolygon.getBounds().intersects(bbox) && this.ghPolygon.intersects(edgeState.fetchWayGeometry(FetchMode.ALL).makeImmutable())) {
            return this.value;
        }
        return this.elseValue;
    }

    public String toString() {
        return this.ghPolygon.toString() + ": " + this.value + ", " + this.elseValue;
    }
}

