/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.template;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.ResponsePath;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.BidirRoutingAlgorithm;
import com.graphhopper.routing.DirectionResolver;
import com.graphhopper.routing.DirectionResolverResult;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.RoutingAlgorithm;
import com.graphhopper.routing.RoutingAlgorithmFactory;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.ev.RoadEnvironment;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.template.AbstractRoutingTemplate;
import com.graphhopper.routing.template.RoutingTemplate;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.NameSimilarityEdgeFilter;
import com.graphhopper.routing.util.SnapPreventionEdgeFilter;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.QueryResult;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PathMerger;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.Translation;
import com.graphhopper.util.exceptions.PointNotFoundException;
import com.graphhopper.util.shapes.GHPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ViaRoutingTemplate
extends AbstractRoutingTemplate
implements RoutingTemplate {
    protected final GHRequest ghRequest;
    protected final GHResponse ghResponse;
    protected List<Path> pathList;
    protected final ResponsePath responsePath = new ResponsePath();
    private final EnumEncodedValue<RoadClass> roadClassEnc;
    private final EnumEncodedValue<RoadEnvironment> roadEnvEnc;

    public ViaRoutingTemplate(GHRequest ghRequest, GHResponse ghRsp, LocationIndex locationIndex, EncodedValueLookup lookup, Weighting weighting) {
        super(locationIndex, lookup, weighting);
        this.ghRequest = ghRequest;
        this.ghResponse = ghRsp;
        this.roadClassEnc = lookup.getEnumEncodedValue("road_class", RoadClass.class);
        this.roadEnvEnc = lookup.getEnumEncodedValue("road_environment", RoadEnvironment.class);
    }

    @Override
    public List<QueryResult> lookup(List<GHPoint> points) {
        if (points.size() < 2) {
            throw new IllegalArgumentException("At least 2 points have to be specified, but was:" + points.size());
        }
        EdgeFilter strictEdgeFilter = !this.ghRequest.hasSnapPreventions() ? this.edgeFilter : new SnapPreventionEdgeFilter(this.edgeFilter, this.roadClassEnc, this.roadEnvEnc, this.ghRequest.getSnapPreventions());
        this.queryResults = new ArrayList(points.size());
        for (int placeIndex = 0; placeIndex < points.size(); ++placeIndex) {
            GHPoint point = points.get(placeIndex);
            QueryResult qr = null;
            if (this.ghRequest.hasPointHints()) {
                qr = this.locationIndex.findClosest(point.lat, point.lon, new NameSimilarityEdgeFilter(strictEdgeFilter, (String)this.ghRequest.getPointHints().get(placeIndex), point, 100.0));
            } else if (this.ghRequest.hasSnapPreventions()) {
                qr = this.locationIndex.findClosest(point.lat, point.lon, strictEdgeFilter);
            }
            if (qr == null || !qr.isValid()) {
                qr = this.locationIndex.findClosest(point.lat, point.lon, this.edgeFilter);
            }
            if (!qr.isValid()) {
                this.ghResponse.addError((Throwable)new PointNotFoundException("Cannot find point " + placeIndex + ": " + point, placeIndex));
            }
            this.queryResults.add(qr);
        }
        return this.queryResults;
    }

    @Override
    public List<Path> calcPaths(QueryGraph queryGraph, RoutingAlgorithmFactory algoFactory, AlgorithmOptions algoOpts) {
        long visitedNodesSum = 0L;
        boolean viaTurnPenalty = this.ghRequest.getHints().getBool("pass_through", false);
        int pointsCount = this.ghRequest.getPoints().size();
        this.pathList = new ArrayList<Path>(pointsCount - 1);
        List directions = Collections.emptyList();
        if (!this.ghRequest.getCurbsides().isEmpty()) {
            DirectionResolver directionResolver = new DirectionResolver(queryGraph, this.accessEnc);
            directions = new ArrayList(this.queryResults.size());
            for (QueryResult qr : this.queryResults) {
                directions.add(directionResolver.resolveDirections(qr.getClosestNode(), qr.getQueryPoint()));
            }
        }
        QueryResult fromQResult = (QueryResult)this.queryResults.get(0);
        for (int placeIndex = 1; placeIndex < pointsCount; ++placeIndex) {
            List<Path> tmpPathList;
            Path prevRoute;
            if (placeIndex == 1) {
                double initialHeading = this.ghRequest.getHeadings().isEmpty() ? Double.NaN : (Double)this.ghRequest.getHeadings().get(0);
                queryGraph.enforceHeading(fromQResult.getClosestNode(), initialHeading, false);
            } else if (viaTurnPenalty && (prevRoute = this.pathList.get(placeIndex - 2)).getEdgeCount() > 0) {
                EdgeIteratorState incomingVirtualEdge = prevRoute.getFinalEdge();
                queryGraph.unfavorVirtualEdgePair(fromQResult.getClosestNode(), incomingVirtualEdge.getEdge());
            }
            QueryResult toQResult = (QueryResult)this.queryResults.get(placeIndex);
            double heading = this.ghRequest.getPoints().size() == this.ghRequest.getHeadings().size() ? (Double)this.ghRequest.getHeadings().get(placeIndex) : Double.NaN;
            queryGraph.enforceHeading(toQResult.getClosestNode(), heading, true);
            StopWatch sw = new StopWatch().start();
            RoutingAlgorithm algo = algoFactory.createAlgo(queryGraph, algoOpts);
            String debug = ", algoInit:" + sw.stop().getSeconds() + "s";
            sw = new StopWatch().start();
            if (!directions.isEmpty()) {
                if (this.ghRequest.getCurbsides().size() != this.ghRequest.getPoints().size()) {
                    throw new IllegalArgumentException("If you pass curbside, you need to pass exactly one curbside for every point, empty curbsides will be ignored");
                }
                if (!(algo instanceof BidirRoutingAlgorithm)) {
                    throw new IllegalArgumentException("To make use of the curbside parameter you need a bidirectional algorithm, got: " + algo.getName());
                }
                String fromCurbside = (String)this.ghRequest.getCurbsides().get(placeIndex - 1);
                String toCurbside = (String)this.ghRequest.getCurbsides().get(placeIndex);
                int sourceOutEdge = DirectionResolverResult.getOutEdge((DirectionResolverResult)directions.get(placeIndex - 1), fromCurbside);
                int targetInEdge = DirectionResolverResult.getInEdge((DirectionResolverResult)directions.get(placeIndex), toCurbside);
                boolean forceCurbsides = this.ghRequest.getHints().getBool("force_curbside", true);
                sourceOutEdge = this.ignoreThrowOrAcceptImpossibleCurbsides(sourceOutEdge, placeIndex - 1, forceCurbsides);
                targetInEdge = this.ignoreThrowOrAcceptImpossibleCurbsides(targetInEdge, placeIndex, forceCurbsides);
                if (fromQResult.getClosestNode() == toQResult.getClosestNode() && (Helper.isEmpty((String)fromCurbside) || Helper.isEmpty((String)toCurbside) || fromCurbside.equals("any") || toCurbside.equals("any") || fromCurbside.equals(toCurbside))) {
                    sourceOutEdge = -2;
                    targetInEdge = -2;
                }
                tmpPathList = Collections.singletonList(((BidirRoutingAlgorithm)algo).calcPath(fromQResult.getClosestNode(), toQResult.getClosestNode(), sourceOutEdge, targetInEdge));
            } else {
                tmpPathList = algo.calcPaths(fromQResult.getClosestNode(), toQResult.getClosestNode());
            }
            debug = debug + ", " + algo.getName() + "-routing:" + sw.stop().getSeconds() + "s";
            if (tmpPathList.isEmpty()) {
                throw new IllegalStateException("At least one path has to be returned for " + fromQResult + " -> " + toQResult);
            }
            for (int i = 0; i < tmpPathList.size(); ++i) {
                Path path = tmpPathList.get(i);
                if (path.getTime() < 0L) {
                    throw new RuntimeException("Time was negative " + path.getTime() + " for index " + i + ". Please report as bug and include:" + this.ghRequest);
                }
                this.pathList.add(path);
                debug = debug + ", " + path.getDebugInfo();
            }
            this.responsePath.addDebugInfo(debug);
            queryGraph.clearUnfavoredStatus();
            if (algo.getVisitedNodes() >= algoOpts.getMaxVisitedNodes()) {
                throw new IllegalArgumentException("No path found due to maximum nodes exceeded " + algoOpts.getMaxVisitedNodes());
            }
            this.responsePath.addDebugInfo("visited nodes sum: " + (visitedNodesSum += (long)algo.getVisitedNodes()));
            fromQResult = toQResult;
        }
        this.ghResponse.getHints().putObject("visited_nodes.sum", (Object)visitedNodesSum);
        this.ghResponse.getHints().putObject("visited_nodes.average", (Object)Float.valueOf((float)visitedNodesSum / (float)(pointsCount - 1)));
        return this.pathList;
    }

    private int ignoreThrowOrAcceptImpossibleCurbsides(int edge, int placeIndex, boolean forceCurbsides) {
        if (edge != -1) {
            return edge;
        }
        if (forceCurbsides) {
            return this.throwImpossibleCurbsideConstraint(placeIndex);
        }
        return -2;
    }

    private int throwImpossibleCurbsideConstraint(int placeIndex) {
        throw new IllegalArgumentException("Impossible curbside constraint: 'curbside=" + (String)this.ghRequest.getCurbsides().get(placeIndex) + "' at point " + placeIndex);
    }

    @Override
    public void finish(PathMerger pathMerger, Translation tr) {
        if (this.ghRequest.getPoints().size() - 1 != this.pathList.size()) {
            throw new RuntimeException("There should be exactly one more points than paths. points:" + this.ghRequest.getPoints().size() + ", paths:" + this.pathList.size());
        }
        this.responsePath.setWaypoints(this.getWaypoints());
        this.ghResponse.add(this.responsePath);
        pathMerger.doWork(this.responsePath, this.pathList, this.lookup, tr);
    }
}

