/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.template;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.ResponsePath;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.RoutingAlgorithmFactory;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.template.ViaRoutingTemplate;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.QueryResult;
import com.graphhopper.util.PathMerger;
import com.graphhopper.util.PointList;
import com.graphhopper.util.Translation;
import com.graphhopper.util.shapes.GHPoint;
import java.util.Collections;
import java.util.List;

public final class AlternativeRoutingTemplate
extends ViaRoutingTemplate {
    public AlternativeRoutingTemplate(GHRequest ghRequest, GHResponse ghRsp, LocationIndex locationIndex, EncodedValueLookup lookup, Weighting weighting) {
        super(ghRequest, ghRsp, locationIndex, lookup, weighting);
    }

    @Override
    public List<QueryResult> lookup(List<GHPoint> points) {
        if (points.size() > 2) {
            throw new IllegalArgumentException("Currently alternative routes work only with start and end point. You tried to use: " + points.size() + " points");
        }
        return super.lookup(points);
    }

    @Override
    public List<Path> calcPaths(QueryGraph queryGraph, RoutingAlgorithmFactory algoFactory, AlgorithmOptions algoOpts) {
        boolean withViaTurnPenalty = this.ghRequest.getHints().getBool("pass_through", false);
        if (withViaTurnPenalty) {
            throw new IllegalArgumentException("Alternative paths and pass_through at the same time is currently not supported");
        }
        return super.calcPaths(queryGraph, algoFactory, algoOpts);
    }

    @Override
    public void finish(PathMerger pathMerger, Translation tr) {
        if (this.pathList.isEmpty()) {
            throw new RuntimeException("Empty paths for alternative route calculation not expected");
        }
        PointList wpList = this.getWaypoints();
        this.responsePath.setWaypoints(wpList);
        this.ghResponse.add(this.responsePath);
        pathMerger.doWork(this.responsePath, Collections.singletonList(this.pathList.get(0)), this.lookup, tr);
        for (int index = 1; index < this.pathList.size(); ++index) {
            ResponsePath p = new ResponsePath();
            p.setWaypoints(wpList);
            this.ghResponse.add(p);
            pathMerger.doWork(p, Collections.singletonList(this.pathList.get(index)), this.lookup, tr);
        }
    }
}

