/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.querygraph;

import com.carrotsearch.hppc.IntObjectMap;
import com.carrotsearch.hppc.procedures.IntObjectProcedure;
import com.graphhopper.coll.GHIntObjectHashMap;
import com.graphhopper.routing.querygraph.QueryOverlay;
import com.graphhopper.routing.querygraph.QueryOverlayBuilder;
import com.graphhopper.routing.querygraph.VirtualEdgeIterator;
import com.graphhopper.routing.querygraph.VirtualEdgeIteratorState;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.weighting.QueryGraphWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.ExtendedNodeAccess;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.storage.index.QueryResult;
import com.graphhopper.util.AngleCalc;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.BBox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class QueryGraph
implements Graph {
    static final int VE_BASE = 0;
    static final int VE_BASE_REV = 1;
    static final int VE_ADJ = 2;
    static final int VE_ADJ_REV = 3;
    private static final AngleCalc AC = Helper.ANGLE_CALC;
    private final Graph mainGraph;
    private final int mainNodes;
    private final int mainEdges;
    private final QueryGraph baseGraph;
    private final TurnCostStorage turnCostStorage;
    private final NodeAccess nodeAccess;
    private final QueryOverlay queryOverlay;
    private final Set<VirtualEdgeIteratorState> unfavoredEdges = new LinkedHashSet<VirtualEdgeIteratorState>(5);
    private final IntObjectMap<List<EdgeIteratorState>> virtualEdgesAtRealNodes;
    private final List<List<EdgeIteratorState>> virtualEdgesAtVirtualNodes;

    public static QueryGraph create(Graph graph, QueryResult qr) {
        return QueryGraph.create(graph, Collections.singletonList(qr));
    }

    public static QueryGraph create(Graph graph, QueryResult fromQR, QueryResult toQR) {
        return QueryGraph.create(graph, Arrays.asList(fromQR, toQR));
    }

    public static QueryGraph create(Graph graph, List<QueryResult> queryResults) {
        return new QueryGraph(graph, queryResults);
    }

    private QueryGraph(Graph graph, List<QueryResult> queryResults) {
        this.mainGraph = graph;
        this.mainNodes = graph.getNodes();
        this.mainEdges = graph.getEdges();
        this.queryOverlay = QueryOverlayBuilder.build(graph, queryResults);
        this.nodeAccess = new ExtendedNodeAccess(graph.getNodeAccess(), this.queryOverlay.getVirtualNodes(), this.mainNodes);
        this.turnCostStorage = this.mainGraph.getTurnCostStorage();
        EdgeExplorer mainExplorer = this.mainGraph.createEdgeExplorer();
        this.virtualEdgesAtRealNodes = this.buildVirtualEdgesAtRealNodes(mainExplorer);
        this.virtualEdgesAtVirtualNodes = this.buildVirtualEdgesAtVirtualNodes();
        this.baseGraph = new QueryGraph(graph.getBaseGraph(), this);
    }

    private QueryGraph(Graph graph, QueryGraph superQueryGraph) {
        this.mainGraph = graph;
        this.baseGraph = this;
        this.turnCostStorage = superQueryGraph.turnCostStorage;
        this.mainNodes = superQueryGraph.mainNodes;
        this.mainEdges = superQueryGraph.mainEdges;
        this.queryOverlay = superQueryGraph.queryOverlay;
        this.nodeAccess = superQueryGraph.nodeAccess;
        this.virtualEdgesAtRealNodes = this.buildVirtualEdgesAtRealNodes(graph.createEdgeExplorer());
        this.virtualEdgesAtVirtualNodes = this.buildVirtualEdgesAtVirtualNodes();
    }

    @Override
    public Graph getBaseGraph() {
        return this.baseGraph;
    }

    public boolean isVirtualEdge(int edgeId) {
        return edgeId >= this.mainEdges;
    }

    public boolean isVirtualNode(int nodeId) {
        return nodeId >= this.mainNodes;
    }

    public boolean enforceHeading(int nodeId, double favoredHeading, boolean incoming) {
        int[] nArray;
        if (Double.isNaN(favoredHeading)) {
            return false;
        }
        if (!this.isVirtualNode(nodeId)) {
            return false;
        }
        int virtNodeIDintern = nodeId - this.mainNodes;
        favoredHeading = AC.convertAzimuth2xaxisAngle(favoredHeading);
        if (incoming) {
            int[] nArray2 = new int[2];
            nArray2[0] = 0;
            nArray = nArray2;
            nArray2[1] = 3;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 1;
            nArray = nArray3;
            nArray3[1] = 2;
        }
        int[] edgePositions = nArray;
        boolean enforcementOccurred = false;
        for (int edgePos : edgePositions) {
            double edgeOrientation;
            VirtualEdgeIteratorState edge = this.getVirtualEdge(virtNodeIDintern * 4 + edgePos);
            PointList wayGeo = edge.fetchWayGeometry(FetchMode.ALL);
            if (incoming) {
                int numWayPoints = wayGeo.getSize();
                edgeOrientation = AC.calcOrientation(wayGeo.getLat(numWayPoints - 2), wayGeo.getLon(numWayPoints - 2), wayGeo.getLat(numWayPoints - 1), wayGeo.getLon(numWayPoints - 1));
            } else {
                edgeOrientation = AC.calcOrientation(wayGeo.getLat(0), wayGeo.getLon(0), wayGeo.getLat(1), wayGeo.getLon(1));
            }
            edgeOrientation = AC.alignOrientation(favoredHeading, edgeOrientation);
            double delta = edgeOrientation - favoredHeading;
            if (!(Math.abs(delta) > 1.74)) continue;
            edge.setUnfavored(true);
            this.unfavoredEdges.add(edge);
            VirtualEdgeIteratorState reverseEdge = this.getVirtualEdge(virtNodeIDintern * 4 + this.getPosOfReverseEdge(edgePos));
            reverseEdge.setUnfavored(true);
            this.unfavoredEdges.add(reverseEdge);
            enforcementOccurred = true;
        }
        return enforcementOccurred;
    }

    public void unfavorVirtualEdgePair(int virtualNodeId, int virtualEdgeId) {
        if (!this.isVirtualNode(virtualNodeId)) {
            throw new IllegalArgumentException("Node id " + virtualNodeId + " must be a virtual node.");
        }
        VirtualEdgeIteratorState incomingEdge = (VirtualEdgeIteratorState)this.getEdgeIteratorState(virtualEdgeId, virtualNodeId);
        VirtualEdgeIteratorState reverseEdge = (VirtualEdgeIteratorState)this.getEdgeIteratorState(virtualEdgeId, incomingEdge.getBaseNode());
        incomingEdge.setUnfavored(true);
        this.unfavoredEdges.add(incomingEdge);
        reverseEdge.setUnfavored(true);
        this.unfavoredEdges.add(reverseEdge);
    }

    public Set<EdgeIteratorState> getUnfavoredVirtualEdges() {
        return new LinkedHashSet<EdgeIteratorState>(this.unfavoredEdges);
    }

    public void clearUnfavoredStatus() {
        for (VirtualEdgeIteratorState edge : this.unfavoredEdges) {
            edge.setUnfavored(false);
        }
        this.unfavoredEdges.clear();
    }

    @Override
    public int getNodes() {
        return this.queryOverlay.getVirtualNodes().getSize() + this.mainNodes;
    }

    @Override
    public int getEdges() {
        return this.queryOverlay.getNumVirtualEdges() + this.mainEdges;
    }

    @Override
    public NodeAccess getNodeAccess() {
        return this.nodeAccess;
    }

    @Override
    public BBox getBounds() {
        return this.mainGraph.getBounds();
    }

    @Override
    public EdgeIteratorState getEdgeIteratorState(int origEdgeId, int adjNode) {
        if (!this.isVirtualEdge(origEdgeId)) {
            return this.mainGraph.getEdgeIteratorState(origEdgeId, adjNode);
        }
        int edgeId = origEdgeId - this.mainEdges;
        VirtualEdgeIteratorState eis = this.getVirtualEdge(edgeId);
        if (eis.getAdjNode() == adjNode || adjNode == Integer.MIN_VALUE) {
            return eis;
        }
        VirtualEdgeIteratorState eis2 = this.getVirtualEdge(edgeId = this.getPosOfReverseEdge(edgeId));
        if (eis2.getAdjNode() == adjNode) {
            return eis2;
        }
        throw new IllegalStateException("Edge " + origEdgeId + " not found with adjNode:" + adjNode + ". found edges were:" + eis + ", " + eis2);
    }

    private VirtualEdgeIteratorState getVirtualEdge(int edgeId) {
        return this.queryOverlay.getVirtualEdge(edgeId);
    }

    private int getPosOfReverseEdge(int edgeId) {
        return edgeId % 2 == 0 ? edgeId + 1 : edgeId - 1;
    }

    @Override
    public EdgeExplorer createEdgeExplorer(EdgeFilter edgeFilter) {
        final EdgeExplorer mainExplorer = this.mainGraph.createEdgeExplorer(edgeFilter);
        final VirtualEdgeIterator virtualEdgeIterator = new VirtualEdgeIterator(edgeFilter, null);
        return new EdgeExplorer(){

            @Override
            public EdgeIterator setBaseNode(int baseNode) {
                if (QueryGraph.this.isVirtualNode(baseNode)) {
                    List virtualEdges = (List)QueryGraph.this.virtualEdgesAtVirtualNodes.get(baseNode - QueryGraph.this.mainNodes);
                    return virtualEdgeIterator.reset(virtualEdges);
                }
                List virtualEdges = (List)QueryGraph.this.virtualEdgesAtRealNodes.get(baseNode);
                if (virtualEdges == null) {
                    return mainExplorer.setBaseNode(baseNode);
                }
                return virtualEdgeIterator.reset(virtualEdges);
            }
        };
    }

    private IntObjectMap<List<EdgeIteratorState>> buildVirtualEdgesAtRealNodes(final EdgeExplorer mainExplorer) {
        final GHIntObjectHashMap virtualEdgesAtRealNodes = new GHIntObjectHashMap(this.queryOverlay.getEdgeChangesAtRealNodes().size());
        this.queryOverlay.getEdgeChangesAtRealNodes().forEach((IntObjectProcedure)new IntObjectProcedure<QueryOverlay.EdgeChanges>(){

            public void apply(int node, QueryOverlay.EdgeChanges edgeChanges) {
                ArrayList<EdgeIteratorState> virtualEdges = new ArrayList<EdgeIteratorState>(edgeChanges.getAdditionalEdges());
                EdgeIterator mainIter = mainExplorer.setBaseNode(node);
                while (mainIter.next()) {
                    if (edgeChanges.getRemovedEdges().contains(mainIter.getEdge())) continue;
                    virtualEdges.add(mainIter.detach(false));
                }
                virtualEdgesAtRealNodes.put(node, virtualEdges);
            }
        });
        return virtualEdgesAtRealNodes;
    }

    private List<List<EdgeIteratorState>> buildVirtualEdgesAtVirtualNodes() {
        ArrayList<List<EdgeIteratorState>> virtualEdgesAtVirtualNodes = new ArrayList<List<EdgeIteratorState>>();
        int[] vEdges = new int[]{1, 2};
        for (int i = 0; i < this.queryOverlay.getVirtualNodes().size(); ++i) {
            ArrayList<VirtualEdgeIteratorState> filteredEdges = new ArrayList<VirtualEdgeIteratorState>(2);
            for (int vEdge : vEdges) {
                filteredEdges.add(this.queryOverlay.getVirtualEdge(i * 4 + vEdge));
            }
            virtualEdgesAtVirtualNodes.add(filteredEdges);
        }
        return virtualEdgesAtVirtualNodes;
    }

    @Override
    public EdgeExplorer createEdgeExplorer() {
        return this.createEdgeExplorer(EdgeFilter.ALL_EDGES);
    }

    @Override
    public AllEdgesIterator getAllEdges() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public EdgeIteratorState edge(int a, int b) {
        throw this.exc();
    }

    @Override
    public EdgeIteratorState edge(int a, int b, double distance, boolean bothDirections) {
        throw this.exc();
    }

    @Override
    public Graph copyTo(Graph g) {
        throw this.exc();
    }

    @Override
    public TurnCostStorage getTurnCostStorage() {
        return this.turnCostStorage;
    }

    @Override
    public Weighting wrapWeighting(Weighting weighting) {
        return new QueryGraphWeighting(weighting, this.mainGraph.getNodes(), this.mainGraph.getEdges(), this.queryOverlay.getClosestEdges());
    }

    @Override
    public int getOtherNode(int edge, int node) {
        if (this.isVirtualEdge(edge)) {
            return this.getEdgeIteratorState(edge, node).getBaseNode();
        }
        return this.mainGraph.getOtherNode(edge, node);
    }

    @Override
    public boolean isAdjacentToNode(int edge, int node) {
        if (this.isVirtualEdge(edge)) {
            EdgeIteratorState virtualEdge = this.getEdgeIteratorState(edge, node);
            return virtualEdge.getBaseNode() == node || virtualEdge.getAdjNode() == node;
        }
        return this.mainGraph.isAdjacentToNode(edge, node);
    }

    List<VirtualEdgeIteratorState> getVirtualEdges() {
        return this.queryOverlay.getVirtualEdges();
    }

    private UnsupportedOperationException exc() {
        return new UnsupportedOperationException("QueryGraph cannot be modified.");
    }

    public Graph getMainGraph() {
        return this.mainGraph;
    }
}

