/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.IntSet;
import com.graphhopper.coll.GHTreeMapComposed;
import com.graphhopper.routing.RoutingAlgorithmFactory;
import com.graphhopper.routing.ch.CHRoutingAlgorithmFactory;
import com.graphhopper.routing.ch.EdgeBasedNodeContractor;
import com.graphhopper.routing.ch.NodeBasedNodeContractor;
import com.graphhopper.routing.ch.NodeContractor;
import com.graphhopper.routing.ch.NodeOrderingProvider;
import com.graphhopper.routing.ch.PrepareCHEdgeExplorer;
import com.graphhopper.routing.ch.PrepareCHEdgeIterator;
import com.graphhopper.routing.ch.PrepareCHGraph;
import com.graphhopper.routing.util.AbstractAlgoPreparation;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.CHConfig;
import com.graphhopper.storage.CHGraph;
import com.graphhopper.storage.CHGraphImpl;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import com.graphhopper.util.StopWatch;
import java.util.Locale;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareContractionHierarchies
extends AbstractAlgoPreparation {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final CHConfig chConfig;
    private final CHGraph chGraph;
    private final PrepareCHGraph prepareGraph;
    private final Random rand = new Random(123L);
    private final IntSet updatedNeighbors;
    private final StopWatch allSW = new StopWatch();
    private final StopWatch periodicUpdateSW = new StopWatch();
    private final StopWatch lazyUpdateSW = new StopWatch();
    private final StopWatch neighborUpdateSW = new StopWatch();
    private final StopWatch contractionSW = new StopWatch();
    private final Params params;
    private final NodeContractor nodeContractor;
    private NodeOrderingProvider nodeOrderingProvider;
    private PrepareCHEdgeExplorer allEdgeExplorer;
    private PrepareCHEdgeExplorer disconnectExplorer;
    private int maxLevel;
    private GHTreeMapComposed sortedNodes;
    private float[] oldPriorities;
    private PMap pMap = new PMap();
    private int checkCounter;

    public static PrepareContractionHierarchies fromGraphHopperStorage(GraphHopperStorage ghStorage, CHConfig chConfig) {
        return new PrepareContractionHierarchies(ghStorage, chConfig);
    }

    private PrepareContractionHierarchies(GraphHopperStorage ghStorage, CHConfig chConfig) {
        this.chGraph = ghStorage.getCHGraph(chConfig);
        this.chConfig = chConfig;
        this.params = Params.forTraversalMode(chConfig.getTraversalMode());
        this.updatedNeighbors = new IntHashSet(50);
        if (chConfig.getTraversalMode().isEdgeBased()) {
            TurnCostStorage turnCostStorage = this.chGraph.getTurnCostStorage();
            if (turnCostStorage == null) {
                throw new IllegalArgumentException("For edge-based CH you need a turn cost storage");
            }
            this.prepareGraph = PrepareCHGraph.edgeBased(this.chGraph, chConfig.getWeighting());
            this.nodeContractor = new EdgeBasedNodeContractor(this.prepareGraph, this.pMap);
        } else {
            this.prepareGraph = PrepareCHGraph.nodeBased(this.chGraph, chConfig.getWeighting());
            this.nodeContractor = new NodeBasedNodeContractor(this.prepareGraph, this.pMap);
        }
    }

    public PrepareContractionHierarchies setParams(PMap pMap) {
        this.pMap = pMap;
        this.params.setPeriodicUpdatesPercentage(pMap.getInt("prepare.ch.updates.periodic", this.params.getPeriodicUpdatesPercentage()));
        this.params.setLastNodesLazyUpdatePercentage(pMap.getInt("prepare.ch.updates.lazy", this.params.getLastNodesLazyUpdatePercentage()));
        this.params.setNeighborUpdatePercentage(pMap.getInt("prepare.ch.updates.neighbor", this.params.getNeighborUpdatePercentage()));
        this.params.setNodesContractedPercentage(pMap.getInt("prepare.ch.contracted_nodes", this.params.getNodesContractedPercentage()));
        this.params.setLogMessagesPercentage(pMap.getInt("prepare.ch.log_messages", this.params.getLogMessagesPercentage()));
        return this;
    }

    public PrepareContractionHierarchies useFixedNodeOrdering(NodeOrderingProvider nodeOrderingProvider) {
        if (nodeOrderingProvider.getNumNodes() != this.prepareGraph.getNodes()) {
            throw new IllegalArgumentException("contraction order size (" + nodeOrderingProvider.getNumNodes() + ") must be equal to number of nodes in graph (" + this.prepareGraph.getNodes() + ").");
        }
        this.nodeOrderingProvider = nodeOrderingProvider;
        return this;
    }

    @Override
    public void doSpecificWork() {
        if (!this.prepareGraph.isReadyForContraction()) {
            throw new IllegalStateException("Given CHGraph has not been frozen yet");
        }
        if (this.prepareGraph.getEdges() > this.prepareGraph.getOriginalEdges()) {
            throw new IllegalStateException("Given CHGraph has been contracted already");
        }
        this.allSW.start();
        this.initFromGraph();
        this.runGraphContraction();
        this.allSW.stop();
        this.logFinalGraphStats();
    }

    private void logFinalGraphStats() {
        int edgeCount = this.prepareGraph.getOriginalEdges();
        this.logger.info("took: {}s, graph now - num edges: {}, num nodes: {}, num shortcuts: {}", new Object[]{(int)this.allSW.getSeconds(), Helper.nf((long)edgeCount), Helper.nf((long)this.prepareGraph.getNodes()), Helper.nf((long)(this.prepareGraph.getEdges() - edgeCount))});
    }

    private void runGraphContraction() {
        if (this.prepareGraph.getNodes() < 1) {
            return;
        }
        this.setMaxLevelOnAllNodes();
        if (this.nodeOrderingProvider != null) {
            this.contractNodesUsingFixedNodeOrdering();
        } else {
            this.contractNodesUsingHeuristicNodeOrdering();
        }
    }

    public boolean isEdgeBased() {
        return this.chConfig.isEdgeBased();
    }

    private void initFromGraph() {
        this.maxLevel = this.prepareGraph.getNodes();
        this.allEdgeExplorer = this.prepareGraph.createAllEdgeExplorer();
        this.disconnectExplorer = this.prepareGraph.createAllEdgeExplorer();
        this.sortedNodes = new GHTreeMapComposed();
        this.oldPriorities = new float[this.prepareGraph.getNodes()];
        this.nodeContractor.initFromGraph();
    }

    private void setMaxLevelOnAllNodes() {
        int nodes = this.prepareGraph.getNodes();
        for (int node = 0; node < nodes; ++node) {
            this.prepareGraph.setLevel(node, this.maxLevel);
        }
    }

    private void updatePrioritiesOfRemainingNodes() {
        this.periodicUpdateSW.start();
        this.sortedNodes.clear();
        int nodes = this.prepareGraph.getNodes();
        for (int node = 0; node < nodes; ++node) {
            if (this.prepareGraph.getLevel(node) != this.maxLevel) continue;
            float priority = this.oldPriorities[node] = this.calculatePriority(node);
            this.sortedNodes.insert(node, priority);
        }
        this.periodicUpdateSW.stop();
    }

    private void contractNodesUsingHeuristicNodeOrdering() {
        boolean neighborUpdate;
        this.updatePrioritiesOfRemainingNodes();
        this.nodeContractor.prepareContraction();
        int initSize = this.sortedNodes.getSize();
        int level = 0;
        this.checkCounter = 0;
        long logSize = this.params.getLogMessagesPercentage() == 0 ? Long.MAX_VALUE : Math.round(Math.max(10.0, (double)initSize * ((double)this.params.getLogMessagesPercentage() / 100.0)));
        long periodicUpdatesCount = this.params.getPeriodicUpdatesPercentage() == 0 ? Long.MAX_VALUE : Math.round(Math.max(10.0, (double)initSize * ((double)this.params.getPeriodicUpdatesPercentage() / 100.0)));
        int updateCounter = 0;
        long lastNodesLazyUpdates = Math.round((double)initSize * ((double)this.params.getLastNodesLazyUpdatePercentage() / 100.0));
        long nodesToAvoidContract = Math.round((double)initSize * ((double)(100 - this.params.getNodesContractedPercentage()) / 100.0));
        boolean bl = neighborUpdate = this.params.getNeighborUpdatePercentage() != 0;
        while (!this.sortedNodes.isEmpty()) {
            this.stopIfInterrupted();
            if (this.checkCounter > 0 && (long)this.checkCounter % periodicUpdatesCount == 0L) {
                this.updatePrioritiesOfRemainingNodes();
                ++updateCounter;
                if (this.sortedNodes.isEmpty()) {
                    throw new IllegalStateException("Cannot prepare as no unprepared nodes where found. Called preparation twice?");
                }
            }
            if ((long)this.checkCounter % logSize == 0L) {
                this.logHeuristicStats(updateCounter);
            }
            ++this.checkCounter;
            int polledNode = this.sortedNodes.pollKey();
            if (!this.sortedNodes.isEmpty() && (long)this.sortedNodes.getSize() < lastNodesLazyUpdates) {
                this.lazyUpdateSW.start();
                float priority = this.oldPriorities[polledNode] = this.calculatePriority(polledNode);
                if (priority > this.sortedNodes.peekValue()) {
                    this.sortedNodes.insert(polledNode, priority);
                    this.lazyUpdateSW.stop();
                    continue;
                }
                this.lazyUpdateSW.stop();
            }
            this.contractNode(polledNode, level);
            ++level;
            if ((long)this.sortedNodes.getSize() < nodesToAvoidContract) break;
            this.updatedNeighbors.clear();
            PrepareCHEdgeIterator iter = this.allEdgeExplorer.setBaseNode(polledNode);
            while (iter.next()) {
                int nn = iter.getAdjNode();
                if (this.prepareGraph.getLevel(nn) != this.maxLevel) continue;
                if (neighborUpdate && !this.updatedNeighbors.contains(nn) && this.rand.nextInt(100) < this.params.getNeighborUpdatePercentage()) {
                    this.neighborUpdateSW.start();
                    float oldPrio = this.oldPriorities[nn];
                    float priority = this.oldPriorities[nn] = this.calculatePriority(nn);
                    if (priority != oldPrio) {
                        this.sortedNodes.update(nn, oldPrio, priority);
                        this.updatedNeighbors.add(nn);
                    }
                    this.neighborUpdateSW.stop();
                }
                this.prepareGraph.disconnect(this.disconnectExplorer, iter);
            }
        }
        this.logHeuristicStats(updateCounter);
        this.logger.info("new shortcuts: " + Helper.nf((long)this.nodeContractor.getAddedShortcutsCount()) + ", initSize:" + Helper.nf((long)initSize) + ", " + this.chConfig.getWeighting() + ", periodic:" + this.params.getPeriodicUpdatesPercentage() + ", lazy:" + this.params.getLastNodesLazyUpdatePercentage() + ", neighbor:" + this.params.getNeighborUpdatePercentage() + ", " + this.getTimesAsString() + ", lazy-overhead: " + (int)(100.0 * ((double)this.checkCounter / (double)initSize - 1.0)) + "%, " + Helper.getMemInfo());
        this._close();
    }

    private void contractNodesUsingFixedNodeOrdering() {
        this.nodeContractor.prepareContraction();
        int nodesToContract = this.nodeOrderingProvider.getNumNodes();
        int logSize = Math.max(10, (int)((double)this.params.getLogMessagesPercentage() / 100.0 * (double)nodesToContract));
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        for (int i = 0; i < nodesToContract; ++i) {
            this.stopIfInterrupted();
            int node = this.nodeOrderingProvider.getNodeIdForLevel(i);
            this.contractNode(node, i);
            PrepareCHEdgeIterator iter = this.allEdgeExplorer.setBaseNode(node);
            while (iter.next()) {
                if (this.prepareGraph.getLevel(iter.getAdjNode()) != this.maxLevel) continue;
                this.prepareGraph.disconnect(this.disconnectExplorer, iter);
            }
            if (i % logSize != 0) continue;
            stopWatch.stop();
            this.logFixedNodeOrderingStats(i, logSize, stopWatch);
            stopWatch.start();
        }
    }

    private void stopIfInterrupted() {
        if (Thread.currentThread().isInterrupted()) {
            throw new RuntimeException("Thread was interrupted");
        }
    }

    private void contractNode(int node, int level) {
        this.contractionSW.start();
        this.nodeContractor.contractNode(node);
        this.prepareGraph.setLevel(node, level);
        this.contractionSW.stop();
    }

    private void logHeuristicStats(int updateCounter) {
        this.logger.info(String.format(Locale.ROOT, "%s, nodes: %10s, shortcuts: %10s, updates: %2d, checked-nodes: %10s, %s, %s, %s", this.isEdgeBased() ? "edge" : "node", Helper.nf((long)this.sortedNodes.getSize()), Helper.nf((long)this.nodeContractor.getAddedShortcutsCount()), updateCounter, Helper.nf((long)this.checkCounter), this.getTimesAsString(), this.nodeContractor.getStatisticsString(), Helper.getMemInfo()));
    }

    private void logFixedNodeOrderingStats(int nodesContracted, int logSize, StopWatch stopWatch) {
        this.logger.info(String.format(Locale.ROOT, "nodes: %10s / %10s (%6.2f%%), shortcuts: %10s, speed = %6.2f nodes/ms, %s, %s", Helper.nf((long)nodesContracted), Helper.nf((long)this.prepareGraph.getNodes()), 100.0 * (double)nodesContracted / (double)this.prepareGraph.getNodes(), Helper.nf((long)this.nodeContractor.getAddedShortcutsCount()), nodesContracted == 0 ? 0.0 : (double)logSize / (double)stopWatch.getMillis(), this.nodeContractor.getStatisticsString(), Helper.getMemInfo()));
    }

    public long getDijkstraCount() {
        return this.nodeContractor.getDijkstraCount();
    }

    public long getShortcuts() {
        return this.nodeContractor.getAddedShortcutsCount();
    }

    public double getLazyTime() {
        return this.lazyUpdateSW.getCurrentSeconds();
    }

    public double getPeriodTime() {
        return this.periodicUpdateSW.getCurrentSeconds();
    }

    public double getNeighborTime() {
        return this.neighborUpdateSW.getCurrentSeconds();
    }

    public Weighting getWeighting() {
        return this.chConfig.getWeighting();
    }

    public CHConfig getCHConfig() {
        return this.chConfig;
    }

    private String getTimesAsString() {
        float totalTime = this.allSW.getCurrentSeconds();
        float periodicUpdateTime = this.periodicUpdateSW.getCurrentSeconds();
        float lazyUpdateTime = this.lazyUpdateSW.getCurrentSeconds();
        float neighborUpdateTime = this.neighborUpdateSW.getCurrentSeconds();
        float contractionTime = this.contractionSW.getCurrentSeconds();
        float otherTime = totalTime - (periodicUpdateTime + lazyUpdateTime + neighborUpdateTime + contractionTime);
        float dijkstraTime = this.nodeContractor.getDijkstraSeconds();
        return String.format(Locale.ROOT, "t(total): %6.2f,  t(period): %6.2f, t(lazy): %6.2f, t(neighbor): %6.2f, t(contr): %6.2f, t(other) : %6.2f, dijkstra-ratio: %6.2f%%", Float.valueOf(totalTime), Float.valueOf(periodicUpdateTime), Float.valueOf(lazyUpdateTime), Float.valueOf(neighborUpdateTime), Float.valueOf(contractionTime), Float.valueOf(otherTime), Float.valueOf(dijkstraTime / totalTime * 100.0f));
    }

    public long getTotalPrepareTime() {
        return this.allSW.getMillis();
    }

    private float calculatePriority(int node) {
        return this.nodeContractor.calculatePriority(node);
    }

    public String toString() {
        return this.chConfig.isEdgeBased() ? "prepare|dijkstrabi|edge|ch" : "prepare|dijkstrabi|ch";
    }

    private void _close() {
        this.nodeContractor.close();
        this.sortedNodes = null;
        this.oldPriorities = null;
    }

    void close() {
        CHGraphImpl cg = (CHGraphImpl)this.chGraph;
        cg.flush();
        cg.close();
    }

    public RoutingAlgorithmFactory getRoutingAlgorithmFactory() {
        return new CHRoutingAlgorithmFactory(this.chGraph);
    }

    private static class Params {
        private int periodicUpdatesPercentage;
        private int lastNodesLazyUpdatePercentage;
        private int neighborUpdatePercentage;
        private int nodesContractedPercentage;
        private int logMessagesPercentage;

        static Params forTraversalMode(TraversalMode traversalMode) {
            if (traversalMode.isEdgeBased()) {
                return new Params(0, 100, 0, 100, 5);
            }
            return new Params(20, 10, 20, 100, 20);
        }

        private Params(int periodicUpdatesPercentage, int lastNodesLazyUpdatePercentage, int neighborUpdatePercentage, int nodesContractedPercentage, int logMessagesPercentage) {
            this.setPeriodicUpdatesPercentage(periodicUpdatesPercentage);
            this.setLastNodesLazyUpdatePercentage(lastNodesLazyUpdatePercentage);
            this.setNeighborUpdatePercentage(neighborUpdatePercentage);
            this.setNodesContractedPercentage(nodesContractedPercentage);
            this.setLogMessagesPercentage(logMessagesPercentage);
        }

        int getPeriodicUpdatesPercentage() {
            return this.periodicUpdatesPercentage;
        }

        void setPeriodicUpdatesPercentage(int periodicUpdatesPercentage) {
            this.checkPercentage("prepare.ch.updates.periodic", periodicUpdatesPercentage);
            this.periodicUpdatesPercentage = periodicUpdatesPercentage;
        }

        int getLastNodesLazyUpdatePercentage() {
            return this.lastNodesLazyUpdatePercentage;
        }

        void setLastNodesLazyUpdatePercentage(int lastNodesLazyUpdatePercentage) {
            this.checkPercentage("prepare.ch.updates.lazy", lastNodesLazyUpdatePercentage);
            this.lastNodesLazyUpdatePercentage = lastNodesLazyUpdatePercentage;
        }

        int getNeighborUpdatePercentage() {
            return this.neighborUpdatePercentage;
        }

        void setNeighborUpdatePercentage(int neighborUpdatePercentage) {
            this.checkPercentage("prepare.ch.updates.neighbor", neighborUpdatePercentage);
            this.neighborUpdatePercentage = neighborUpdatePercentage;
        }

        int getNodesContractedPercentage() {
            return this.nodesContractedPercentage;
        }

        void setNodesContractedPercentage(int nodesContractedPercentage) {
            this.checkPercentage("prepare.ch.contracted_nodes", nodesContractedPercentage);
            this.nodesContractedPercentage = nodesContractedPercentage;
        }

        int getLogMessagesPercentage() {
            return this.logMessagesPercentage;
        }

        void setLogMessagesPercentage(int logMessagesPercentage) {
            this.checkPercentage("prepare.ch.log_messages", logMessagesPercentage);
            this.logMessagesPercentage = logMessagesPercentage;
        }

        private void checkPercentage(String name, int value) {
            if (value < 0 || value > 100) {
                throw new IllegalArgumentException(name + " has to be in [0, 100], to disable it use 0");
            }
        }
    }
}

