/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.graphhopper.routing.ch.PrepareCHEdgeExplorer;
import com.graphhopper.routing.ch.PrepareCHEdgeIterator;
import com.graphhopper.routing.ch.PrepareCHEdgeIteratorImpl;
import com.graphhopper.routing.util.AllCHEdgesIterator;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.CHGraph;
import com.graphhopper.storage.NodeAccess;

public class PrepareCHGraph {
    private final CHGraph chGraph;
    private final Weighting weighting;

    public static PrepareCHGraph nodeBased(CHGraph chGraph, Weighting weighting) {
        if (chGraph.getCHConfig().isEdgeBased()) {
            throw new IllegalArgumentException("Expected node-based CHGraph, but was edge-based");
        }
        return new PrepareCHGraph(chGraph, weighting);
    }

    public static PrepareCHGraph edgeBased(CHGraph chGraph, Weighting weighting) {
        if (!chGraph.getCHConfig().isEdgeBased()) {
            throw new IllegalArgumentException("Expected edge-based CHGraph, but was node-based");
        }
        return new PrepareCHGraph(chGraph, weighting);
    }

    private PrepareCHGraph(CHGraph chGraph, Weighting weighting) {
        this.chGraph = chGraph;
        this.weighting = weighting;
    }

    public PrepareCHEdgeExplorer createInEdgeExplorer() {
        return PrepareCHEdgeIteratorImpl.inEdges(this.chGraph.createEdgeExplorer(), this.weighting);
    }

    public PrepareCHEdgeExplorer createOutEdgeExplorer() {
        return PrepareCHEdgeIteratorImpl.outEdges(this.chGraph.createEdgeExplorer(), this.weighting);
    }

    public PrepareCHEdgeExplorer createAllEdgeExplorer() {
        return PrepareCHEdgeIteratorImpl.allEdges(this.chGraph.createEdgeExplorer(), this.weighting);
    }

    public PrepareCHEdgeExplorer createOriginalInEdgeExplorer() {
        return PrepareCHEdgeIteratorImpl.inEdges(this.chGraph.createOriginalEdgeExplorer(), this.weighting);
    }

    public PrepareCHEdgeExplorer createOriginalOutEdgeExplorer() {
        return PrepareCHEdgeIteratorImpl.outEdges(this.chGraph.createOriginalEdgeExplorer(), this.weighting);
    }

    public int getNodes() {
        return this.chGraph.getNodes();
    }

    public int getEdges() {
        return this.chGraph.getEdges();
    }

    public int getOriginalEdges() {
        return this.chGraph.getOriginalEdges();
    }

    public int getLevel(int node) {
        return this.chGraph.getLevel(node);
    }

    public void setLevel(int node, int level) {
        this.chGraph.setLevel(node, level);
    }

    public int shortcut(int a, int b, int accessFlags, double weight, int skippedEdge1, int skippedEdge2) {
        return this.chGraph.shortcut(a, b, accessFlags, weight, skippedEdge1, skippedEdge2);
    }

    public int shortcutEdgeBased(int a, int b, int accessFlags, double weight, int skippedEdge1, int skippedEdge2, int origFirst, int origLast) {
        return this.chGraph.shortcutEdgeBased(a, b, accessFlags, weight, skippedEdge1, skippedEdge2, origFirst, origLast);
    }

    public int getOtherNode(int edge, int adjNode) {
        return this.chGraph.getOtherNode(edge, adjNode);
    }

    public NodeAccess getNodeAccess() {
        return this.chGraph.getNodeAccess();
    }

    double getTurnWeight(int inEdge, int viaNode, int outEdge) {
        return this.weighting.calcTurnWeight(inEdge, viaNode, outEdge);
    }

    public AllCHEdgesIterator getAllEdges() {
        return this.chGraph.getAllEdges();
    }

    boolean isReadyForContraction() {
        return this.chGraph.isReadyForContraction();
    }

    public void disconnect(PrepareCHEdgeExplorer explorer, PrepareCHEdgeIterator edgeState) {
        PrepareCHEdgeIterator tmpIter = explorer.setBaseNode(edgeState.getAdjNode());
        int prevEdge = -1;
        while (tmpIter.next()) {
            if (tmpIter.isShortcut() && tmpIter.getEdge() == edgeState.getEdge()) {
                this.chGraph.disconnectEdge(edgeState.getEdge(), edgeState.getAdjNode(), prevEdge);
                break;
            }
            prevEdge = tmpIter.getEdge();
        }
    }
}

