/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.IntSet;
import com.graphhopper.routing.ch.AbstractNodeContractor;
import com.graphhopper.routing.ch.CHEntry;
import com.graphhopper.routing.ch.EdgeBasedWitnessPathSearcher;
import com.graphhopper.routing.ch.PrepareCHEdgeExplorer;
import com.graphhopper.routing.ch.PrepareCHEdgeIterator;
import com.graphhopper.routing.ch.PrepareCHGraph;
import com.graphhopper.routing.ch.PrepareEncoder;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import com.graphhopper.util.StopWatch;
import java.util.HashSet;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EdgeBasedNodeContractor
extends AbstractNodeContractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(EdgeBasedNodeContractor.class);
    private final ShortcutHandler addingShortcutHandler = new AddingShortcutHandler();
    private final ShortcutHandler countingShortcutHandler = new CountingShortcutHandler();
    private final Params params = new Params();
    private final PMap pMap;
    private ShortcutHandler activeShortcutHandler;
    private final StopWatch dijkstraSW = new StopWatch();
    private final SearchStrategy activeStrategy = new AggressiveStrategy();
    private int[] hierarchyDepths;
    private EdgeBasedWitnessPathSearcher witnessPathSearcher;
    private PrepareCHEdgeExplorer existingShortcutExplorer;
    private PrepareCHEdgeExplorer allEdgeExplorer;
    private PrepareCHEdgeExplorer sourceNodeOrigInEdgeExplorer;
    private PrepareCHEdgeExplorer targetNodeOrigOutEdgeExplorer;
    private PrepareCHEdgeExplorer loopAvoidanceInEdgeExplorer;
    private PrepareCHEdgeExplorer loopAvoidanceOutEdgeExplorer;
    private int addedShortcutsCount;
    private int numShortcuts;
    private int numPrevEdges;
    private int numOrigEdges;
    private int numPrevOrigEdges;
    private int numPolledEdges;

    public EdgeBasedNodeContractor(PrepareCHGraph prepareGraph, PMap pMap) {
        super(prepareGraph);
        this.pMap = pMap;
        this.extractParams(pMap);
    }

    private void extractParams(PMap pMap) {
        this.params.edgeQuotientWeight = pMap.getFloat("prepare.ch.edge.edge_quotient_weight", this.params.edgeQuotientWeight);
        this.params.originalEdgeQuotientWeight = pMap.getFloat("prepare.ch.edge.original_edge_quotient_weight", this.params.originalEdgeQuotientWeight);
        this.params.hierarchyDepthWeight = pMap.getFloat("prepare.ch.edge.hierarchy_depth_weight", this.params.hierarchyDepthWeight);
    }

    @Override
    public void initFromGraph() {
        super.initFromGraph();
        this.witnessPathSearcher = new EdgeBasedWitnessPathSearcher(this.prepareGraph, this.pMap);
        this.inEdgeExplorer = this.prepareGraph.createInEdgeExplorer();
        this.outEdgeExplorer = this.prepareGraph.createOutEdgeExplorer();
        this.allEdgeExplorer = this.prepareGraph.createAllEdgeExplorer();
        this.existingShortcutExplorer = this.prepareGraph.createOutEdgeExplorer();
        this.sourceNodeOrigInEdgeExplorer = this.prepareGraph.createOriginalInEdgeExplorer();
        this.targetNodeOrigOutEdgeExplorer = this.prepareGraph.createOriginalOutEdgeExplorer();
        this.loopAvoidanceInEdgeExplorer = this.prepareGraph.createOriginalInEdgeExplorer();
        this.loopAvoidanceOutEdgeExplorer = this.prepareGraph.createOriginalOutEdgeExplorer();
        this.hierarchyDepths = new int[this.prepareGraph.getNodes()];
    }

    @Override
    public void prepareContraction() {
    }

    @Override
    public float calculatePriority(int node) {
        this.activeShortcutHandler = this.countingShortcutHandler;
        this.stats().stopWatch.start();
        this.findAndHandleShortcuts(node);
        this.stats().stopWatch.stop();
        this.countPreviousEdges(node);
        float edgeQuotient = (float)this.numShortcuts / (float)this.numPrevEdges;
        float origEdgeQuotient = (float)this.numOrigEdges / (float)this.numPrevOrigEdges;
        int hierarchyDepth = this.hierarchyDepths[node];
        float priority = this.params.edgeQuotientWeight * edgeQuotient + this.params.originalEdgeQuotientWeight * origEdgeQuotient + this.params.hierarchyDepthWeight * (float)hierarchyDepth;
        LOGGER.trace(String.format(Locale.ROOT, "node: %d, eq: %d / %d = %f, oeq: %d / %d = %f, depth: %d --> %f\n", node, this.numShortcuts, this.numPrevEdges, Float.valueOf(edgeQuotient), this.numOrigEdges, this.numPrevOrigEdges, Float.valueOf(origEdgeQuotient), hierarchyDepth, Float.valueOf(priority)));
        return priority;
    }

    @Override
    public void contractNode(int node) {
        this.activeShortcutHandler = this.addingShortcutHandler;
        this.stats().stopWatch.start();
        this.findAndHandleShortcuts(node);
        this.updateHierarchyDepthsOfNeighbors(node);
        this.stats().stopWatch.stop();
    }

    @Override
    public long getAddedShortcutsCount() {
        return this.addedShortcutsCount;
    }

    @Override
    public long getDijkstraCount() {
        return this.witnessPathSearcher.getTotalNumSearches();
    }

    @Override
    public float getDijkstraSeconds() {
        return this.dijkstraSW.getCurrentSeconds();
    }

    @Override
    public String getStatisticsString() {
        String result = "sc-handler-count: " + this.countingShortcutHandler.getStats() + ", sc-handler-contract: " + this.addingShortcutHandler.getStats() + ", " + this.activeStrategy.getStatisticsString();
        this.activeStrategy.resetStats();
        return result;
    }

    public int getNumPolledEdges() {
        return this.numPolledEdges;
    }

    private void findAndHandleShortcuts(int node) {
        this.numPolledEdges = 0;
        this.activeStrategy.findAndHandleShortcuts(node);
    }

    private void countPreviousEdges(int node) {
        PrepareCHEdgeIterator outIter = this.outEdgeExplorer.setBaseNode(node);
        while (outIter.next()) {
            if (this.isContracted(outIter.getAdjNode())) continue;
            ++this.numPrevEdges;
            if (outIter.isShortcut()) continue;
            ++this.numPrevOrigEdges;
        }
        PrepareCHEdgeIterator inIter = this.inEdgeExplorer.setBaseNode(node);
        while (inIter.next()) {
            if (this.isContracted(inIter.getAdjNode()) || inIter.getBaseNode() == inIter.getAdjNode()) continue;
            ++this.numPrevEdges;
            if (inIter.isShortcut()) continue;
            ++this.numPrevOrigEdges;
        }
        PrepareCHEdgeIterator allIter = this.allEdgeExplorer.setBaseNode(node);
        while (allIter.next()) {
            if (this.isContracted(allIter.getAdjNode()) || !allIter.isShortcut()) continue;
            this.numPrevOrigEdges += this.getOrigEdgeCount(allIter.getEdge());
        }
    }

    private void updateHierarchyDepthsOfNeighbors(int node) {
        PrepareCHEdgeIterator iter = this.allEdgeExplorer.setBaseNode(node);
        while (iter.next()) {
            if (this.isContracted(iter.getAdjNode()) || iter.getAdjNode() == node) continue;
            this.hierarchyDepths[iter.getAdjNode()] = Math.max(this.hierarchyDepths[iter.getAdjNode()], this.hierarchyDepths[node] + 1);
        }
    }

    private void handleShortcuts(CHEntry chEntry, CHEntry root) {
        LOGGER.trace("Adding shortcuts for target entry {}", (Object)chEntry);
        if (root.parent.adjNode == chEntry.adjNode && !this.loopShortcutNecessary(chEntry.adjNode, root.getParent().incEdge, chEntry.incEdge, chEntry.weight)) {
            ++this.stats().loopsAvoided;
            return;
        }
        this.activeShortcutHandler.handleShortcut(root, chEntry);
    }

    private boolean loopShortcutNecessary(int node, int firstOrigEdge, int lastOrigEdge, double loopWeight) {
        PrepareCHEdgeIterator inIter = this.loopAvoidanceInEdgeExplorer.setBaseNode(node);
        while (inIter.next()) {
            PrepareCHEdgeIterator outIter = this.loopAvoidanceOutEdgeExplorer.setBaseNode(node);
            double inTurnCost = this.getTurnCost(inIter.getEdge(), node, firstOrigEdge);
            while (outIter.next()) {
                double directTurnCost;
                double totalLoopCost = inTurnCost + loopWeight + this.getTurnCost(lastOrigEdge, node, outIter.getEdge());
                if (!(totalLoopCost < (directTurnCost = this.getTurnCost(inIter.getEdge(), node, outIter.getEdge())))) continue;
                return true;
            }
        }
        LOGGER.trace("Loop avoidance -> no shortcut");
        return false;
    }

    private CHEntry addShortcut(CHEntry edgeFrom, CHEntry edgeTo) {
        if (edgeTo.parent.edge != edgeFrom.edge) {
            CHEntry prev = this.addShortcut(edgeFrom, edgeTo.getParent());
            return this.doAddShortcut(prev, edgeTo);
        }
        return this.doAddShortcut(edgeFrom, edgeTo);
    }

    private CHEntry doAddShortcut(CHEntry edgeFrom, CHEntry edgeTo) {
        int from = edgeFrom.parent.adjNode;
        int adjNode = edgeTo.adjNode;
        PrepareCHEdgeIterator iter = this.existingShortcutExplorer.setBaseNode(from);
        while (iter.next()) {
            if (!this.isSameShortcut(iter, adjNode, edgeFrom.getParent().incEdge, edgeTo.incEdge)) continue;
            double existingWeight = iter.getWeight(false);
            if (existingWeight <= edgeTo.weight) {
                CHEntry entry = new CHEntry(iter.getEdge(), iter.getOrigEdgeLast(), adjNode, existingWeight);
                entry.parent = edgeFrom.parent;
                return entry;
            }
            iter.setSkippedEdges(edgeFrom.edge, edgeTo.edge);
            iter.setWeight(edgeTo.weight);
            CHEntry entry = new CHEntry(iter.getEdge(), iter.getOrigEdgeLast(), adjNode, edgeTo.weight);
            entry.parent = edgeFrom.parent;
            return entry;
        }
        int origFirst = edgeFrom.getParent().incEdge;
        LOGGER.trace("Adding shortcut from {} to {}, weight: {}, firstOrigEdge: {}, lastOrigEdge: {}", new Object[]{from, adjNode, edgeTo.weight, edgeFrom.getParent().incEdge, edgeTo.incEdge});
        int accessFlags = PrepareEncoder.getScFwdDir();
        int shortcutId = this.prepareGraph.shortcutEdgeBased(from, adjNode, accessFlags, edgeTo.weight, edgeFrom.edge, edgeTo.edge, origFirst, edgeTo.incEdge);
        int origEdgeCount = this.getOrigEdgeCount(edgeFrom.edge) + this.getOrigEdgeCount(edgeTo.edge);
        this.setOrigEdgeCount(shortcutId, origEdgeCount);
        ++this.addedShortcutsCount;
        CHEntry entry = new CHEntry(shortcutId, shortcutId, edgeTo.adjNode, edgeTo.weight);
        entry.parent = edgeFrom.parent;
        return entry;
    }

    private boolean isSameShortcut(PrepareCHEdgeIterator iter, int adjNode, int firstOrigEdge, int lastOrigEdge) {
        return iter.isShortcut() && iter.getAdjNode() == adjNode && iter.getOrigEdgeFirst() == firstOrigEdge && iter.getOrigEdgeLast() == lastOrigEdge;
    }

    private double getTurnCost(int inEdge, int node, int outEdge) {
        return this.prepareGraph.getTurnWeight(inEdge, node, outEdge);
    }

    private void resetEdgeCounters() {
        this.numShortcuts = 0;
        this.numPrevEdges = 0;
        this.numOrigEdges = 0;
        this.numPrevOrigEdges = 0;
    }

    private Stats stats() {
        return this.activeShortcutHandler.getStats();
    }

    private static class AddedShortcut {
        int startNode;
        int startEdge;
        int endNode;
        int targetEdge;

        public AddedShortcut(int startNode, int startEdge, int endNode, int targetEdge) {
            this.startNode = startNode;
            this.startEdge = startEdge;
            this.endNode = endNode;
            this.targetEdge = targetEdge;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AddedShortcut that = (AddedShortcut)o;
            return this.startNode == that.startNode && this.startEdge == that.startEdge && this.endNode == that.endNode && this.targetEdge == that.targetEdge;
        }

        public int hashCode() {
            return 31 * this.startNode + this.endNode;
        }
    }

    private class AggressiveStrategy
    implements SearchStrategy {
        private IntSet sourceNodes = new IntHashSet(10);
        private IntSet toNodes = new IntHashSet(10);

        private AggressiveStrategy() {
        }

        @Override
        public String getStatisticsString() {
            return EdgeBasedNodeContractor.this.witnessPathSearcher.getStatisticsString();
        }

        @Override
        public void resetStats() {
            EdgeBasedNodeContractor.this.witnessPathSearcher.resetStats();
        }

        @Override
        public void findAndHandleShortcuts(int node) {
            LOGGER.trace("Finding shortcuts (aggressive) for node {}, required shortcuts will be {}ed", (Object)node, (Object)EdgeBasedNodeContractor.this.activeShortcutHandler.getAction());
            ++((EdgeBasedNodeContractor)EdgeBasedNodeContractor.this).stats().nodes;
            EdgeBasedNodeContractor.this.resetEdgeCounters();
            HashSet<AddedShortcut> addedShortcuts = new HashSet<AddedShortcut>();
            this.sourceNodes.clear();
            PrepareCHEdgeIterator incomingEdges = EdgeBasedNodeContractor.this.inEdgeExplorer.setBaseNode(node);
            while (incomingEdges.next()) {
                boolean isNewSourceNode;
                int sourceNode = incomingEdges.getAdjNode();
                if (EdgeBasedNodeContractor.this.isContracted(sourceNode) || sourceNode == node || !(isNewSourceNode = this.sourceNodes.add(sourceNode))) continue;
                PrepareCHEdgeIterator origInIter = EdgeBasedNodeContractor.this.sourceNodeOrigInEdgeExplorer.setBaseNode(sourceNode);
                while (origInIter.next()) {
                    int numInitialEntries = EdgeBasedNodeContractor.this.witnessPathSearcher.initSearch(node, sourceNode, origInIter.getOrigEdgeLast());
                    if (numInitialEntries < 1) continue;
                    this.toNodes.clear();
                    PrepareCHEdgeIterator outgoingEdges = EdgeBasedNodeContractor.this.outEdgeExplorer.setBaseNode(node);
                    while (outgoingEdges.next()) {
                        boolean isNewTargetNode;
                        int targetNode = outgoingEdges.getAdjNode();
                        if (EdgeBasedNodeContractor.this.isContracted(targetNode) || targetNode == node || !(isNewTargetNode = this.toNodes.add(targetNode))) continue;
                        PrepareCHEdgeIterator targetEdgeIter = EdgeBasedNodeContractor.this.targetNodeOrigOutEdgeExplorer.setBaseNode(targetNode);
                        while (targetEdgeIter.next()) {
                            int targetEdge = targetEdgeIter.getOrigEdgeFirst();
                            EdgeBasedNodeContractor.this.dijkstraSW.start();
                            CHEntry entry = EdgeBasedNodeContractor.this.witnessPathSearcher.runSearch(targetNode, targetEdge);
                            EdgeBasedNodeContractor.this.dijkstraSW.stop();
                            if (entry == null || Double.isInfinite(entry.weight)) continue;
                            CHEntry root = entry.getParent();
                            while (EdgeIterator.Edge.isValid(root.parent.edge)) {
                                root = root.getParent();
                            }
                            AddedShortcut addedShortcut = new AddedShortcut(sourceNode, root.getParent().incEdge, targetNode, entry.incEdge);
                            if (addedShortcuts.contains(addedShortcut)) continue;
                            double initialTurnCost = root.getParent().weight;
                            entry.weight -= initialTurnCost;
                            EdgeBasedNodeContractor.this.handleShortcuts(entry, root);
                            addedShortcuts.add(addedShortcut);
                        }
                    }
                    EdgeBasedNodeContractor.this.numPolledEdges = (int)((long)EdgeBasedNodeContractor.this.numPolledEdges + EdgeBasedNodeContractor.this.witnessPathSearcher.getNumPolledEdges());
                }
            }
        }
    }

    private static interface SearchStrategy {
        public void findAndHandleShortcuts(int var1);

        public String getStatisticsString();

        public void resetStats();
    }

    private static class Stats {
        int nodes;
        long loopsAvoided;
        StopWatch stopWatch = new StopWatch();

        private Stats() {
        }

        public String toString() {
            return String.format(Locale.ROOT, "time: %7.2fs, nodes-handled: %10s, loopsAvoided: %10s", Float.valueOf(this.stopWatch.getCurrentSeconds()), Helper.nf((long)this.nodes), Helper.nf((long)this.loopsAvoided));
        }
    }

    public static class Params {
        private float edgeQuotientWeight = 1.0f;
        private float originalEdgeQuotientWeight = 3.0f;
        private float hierarchyDepthWeight = 2.0f;
    }

    private class CountingShortcutHandler
    implements ShortcutHandler {
        private Stats stats = new Stats();

        private CountingShortcutHandler() {
        }

        @Override
        public void handleShortcut(CHEntry edgeFrom, CHEntry edgeTo) {
            int fromNode = edgeFrom.parent.adjNode;
            int toNode = edgeTo.adjNode;
            int firstOrigEdge = edgeFrom.getParent().incEdge;
            int lastOrigEdge = edgeTo.incEdge;
            PrepareCHEdgeIterator iter = EdgeBasedNodeContractor.this.existingShortcutExplorer.setBaseNode(fromNode);
            while (iter.next()) {
                if (!EdgeBasedNodeContractor.this.isSameShortcut(iter, toNode, firstOrigEdge, lastOrigEdge)) continue;
                return;
            }
            EdgeBasedNodeContractor.this.numShortcuts++;
            EdgeBasedNodeContractor.this.numOrigEdges = EdgeBasedNodeContractor.this.numOrigEdges + (EdgeBasedNodeContractor.this.getOrigEdgeCount(edgeFrom.edge) + EdgeBasedNodeContractor.this.getOrigEdgeCount(edgeTo.edge));
        }

        @Override
        public Stats getStats() {
            return this.stats;
        }

        @Override
        public String getAction() {
            return "count";
        }
    }

    private class AddingShortcutHandler
    implements ShortcutHandler {
        private Stats stats = new Stats();

        private AddingShortcutHandler() {
        }

        @Override
        public void handleShortcut(CHEntry edgeFrom, CHEntry edgeTo) {
            EdgeBasedNodeContractor.this.addShortcut(edgeFrom, edgeTo);
        }

        @Override
        public Stats getStats() {
            return this.stats;
        }

        @Override
        public String getAction() {
            return "add";
        }
    }

    private static interface ShortcutHandler {
        public void handleShortcut(CHEntry var1, CHEntry var2);

        public Stats getStats();

        public String getAction();
    }
}

