/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.graphhopper.routing.AStarBidirectionCH;
import com.graphhopper.routing.AStarBidirectionEdgeCHNoSOD;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.AlternativeRouteCH;
import com.graphhopper.routing.AlternativeRouteEdgeCH;
import com.graphhopper.routing.DijkstraBidirectionCH;
import com.graphhopper.routing.DijkstraBidirectionCHNoSOD;
import com.graphhopper.routing.DijkstraBidirectionEdgeCHNoSOD;
import com.graphhopper.routing.RoutingAlgorithm;
import com.graphhopper.routing.RoutingAlgorithmFactory;
import com.graphhopper.routing.RoutingAlgorithmFactorySimple;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.CHConfig;
import com.graphhopper.storage.CHGraph;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.storage.RoutingCHGraphImpl;
import com.graphhopper.storage.TurnCostStorage;

public class CHRoutingAlgorithmFactory
implements RoutingAlgorithmFactory {
    private final CHConfig chConfig;

    public CHRoutingAlgorithmFactory(CHGraph chGraph) {
        this.chConfig = chGraph.getCHConfig();
    }

    @Override
    public RoutingAlgorithm createAlgo(Graph graph, AlgorithmOptions opts) {
        RoutingAlgorithm algo = this.doCreateAlgo(graph, opts);
        algo.setMaxVisitedNodes(opts.getMaxVisitedNodes());
        return algo;
    }

    private RoutingAlgorithm doCreateAlgo(Graph graph, AlgorithmOptions opts) {
        if (this.chConfig.isEdgeBased()) {
            TurnCostStorage turnCostStorage = graph.getTurnCostStorage();
            if (turnCostStorage == null) {
                throw new IllegalArgumentException("For edge-based CH you need a turn cost extension");
            }
            RoutingCHGraphImpl g = new RoutingCHGraphImpl(graph, graph.wrapWeighting(this.getWeighting()));
            return this.createAlgoEdgeBased(g, opts);
        }
        RoutingCHGraphImpl g = new RoutingCHGraphImpl(graph, this.chConfig.getWeighting());
        return this.createAlgoNodeBased(g, opts);
    }

    private RoutingAlgorithm createAlgoEdgeBased(RoutingCHGraph g, AlgorithmOptions opts) {
        if ("astarbi".equals(opts.getAlgorithm())) {
            return new AStarBidirectionEdgeCHNoSOD(g).setApproximation(RoutingAlgorithmFactorySimple.getApproximation("astarbi", opts, g.getGraph().getNodeAccess()));
        }
        if ("dijkstrabi".equals(opts.getAlgorithm())) {
            return new DijkstraBidirectionEdgeCHNoSOD(g);
        }
        if ("alternative_route".equalsIgnoreCase(opts.getAlgorithm())) {
            return new AlternativeRouteEdgeCH(g, opts.getHints());
        }
        throw new IllegalArgumentException("Algorithm " + opts.getAlgorithm() + " not supported for edge-based Contraction Hierarchies. Try with ch.disable=true");
    }

    private RoutingAlgorithm createAlgoNodeBased(RoutingCHGraph g, AlgorithmOptions opts) {
        if ("astarbi".equals(opts.getAlgorithm())) {
            return new AStarBidirectionCH(g).setApproximation(RoutingAlgorithmFactorySimple.getApproximation("astarbi", opts, g.getGraph().getNodeAccess()));
        }
        if ("dijkstrabi".equals(opts.getAlgorithm())) {
            if (opts.getHints().getBool("stall_on_demand", true)) {
                return new DijkstraBidirectionCH(g);
            }
            return new DijkstraBidirectionCHNoSOD(g);
        }
        if ("alternative_route".equalsIgnoreCase(opts.getAlgorithm())) {
            return new AlternativeRouteCH(g, opts.getHints());
        }
        throw new IllegalArgumentException("Algorithm " + opts.getAlgorithm() + " not supported for node-based Contraction Hierarchies. Try with ch.disable=true");
    }

    public Weighting getWeighting() {
        return this.chConfig.getWeighting();
    }

    public CHConfig getCHConfig() {
        return this.chConfig;
    }
}

