/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.graphhopper.routing.ch.NodeContractor;
import com.graphhopper.routing.ch.PrepareCHEdgeExplorer;
import com.graphhopper.routing.ch.PrepareCHGraph;
import com.graphhopper.storage.DAType;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.GHDirectory;

abstract class AbstractNodeContractor
implements NodeContractor {
    final PrepareCHGraph prepareGraph;
    PrepareCHEdgeExplorer inEdgeExplorer;
    PrepareCHEdgeExplorer outEdgeExplorer;
    private final DataAccess originalEdges;
    int maxLevel;
    private int maxEdgesCount;

    public AbstractNodeContractor(PrepareCHGraph prepareGraph) {
        this.prepareGraph = prepareGraph;
        this.originalEdges = new GHDirectory("", DAType.RAM_INT).find("");
        this.originalEdges.create(1000L);
    }

    @Override
    public void initFromGraph() {
        this.inEdgeExplorer = this.prepareGraph.createInEdgeExplorer();
        this.outEdgeExplorer = this.prepareGraph.createOutEdgeExplorer();
        this.maxLevel = this.prepareGraph.getNodes();
        this.maxEdgesCount = this.prepareGraph.getOriginalEdges();
    }

    @Override
    public void close() {
        this.originalEdges.close();
    }

    boolean isContracted(int node) {
        return this.prepareGraph.getLevel(node) != this.maxLevel;
    }

    void setOrigEdgeCount(int edgeId, int value) {
        if ((edgeId -= this.maxEdgesCount) < 0) {
            if (value != 1) {
                throw new IllegalStateException("Trying to set original edge count for normal edge to a value = " + value + ", edge:" + (edgeId + this.maxEdgesCount) + ", max:" + this.maxEdgesCount + ", graph.max:" + this.prepareGraph.getEdges());
            }
            return;
        }
        long tmp = (long)edgeId * 4L;
        this.originalEdges.ensureCapacity(tmp + 4L);
        this.originalEdges.setInt(tmp, value);
    }

    int getOrigEdgeCount(int edgeId) {
        if ((edgeId -= this.maxEdgesCount) < 0) {
            return 1;
        }
        long tmp = (long)edgeId * 4L;
        this.originalEdges.ensureCapacity(tmp + 4L);
        return this.originalEdges.getInt(tmp);
    }
}

