/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.Path;
import com.graphhopper.routing.SPTEntry;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.StopWatch;

public class PathExtractor {
    private final Graph graph;
    private final Weighting weighting;
    protected final Path path;

    public static Path extractPath(Graph graph, Weighting weighting, SPTEntry sptEntry) {
        return new PathExtractor(graph, weighting).extract(sptEntry);
    }

    protected PathExtractor(Graph graph, Weighting weighting) {
        this.graph = graph;
        this.weighting = weighting;
        this.path = new Path(graph);
    }

    protected Path extract(SPTEntry sptEntry) {
        if (sptEntry == null) {
            return this.path;
        }
        StopWatch sw = new StopWatch().start();
        this.extractPath(sptEntry);
        this.path.setFound(true);
        this.path.setWeight(sptEntry.weight);
        this.setExtractionTime(sw.stop().getNanos());
        return this.path;
    }

    private void extractPath(SPTEntry sptEntry) {
        SPTEntry currEdge = this.followParentsUntilRoot(sptEntry);
        this.path.reverseEdges();
        this.path.setFromNode(currEdge.adjNode);
        this.path.setEndNode(sptEntry.adjNode);
    }

    private SPTEntry followParentsUntilRoot(SPTEntry sptEntry) {
        SPTEntry currEntry = sptEntry;
        SPTEntry parentEntry = currEntry.parent;
        while (EdgeIterator.Edge.isValid(currEntry.edge)) {
            this.onEdge(currEntry.edge, currEntry.adjNode, parentEntry.edge);
            currEntry = currEntry.parent;
            parentEntry = currEntry.parent;
        }
        return currEntry;
    }

    private void setExtractionTime(long nanos) {
        this.path.setDebugInfo("path extraction: " + nanos / 1000L + " micros");
    }

    protected void onEdge(int edge, int adjNode, int prevEdge) {
        EdgeIteratorState edgeState = this.graph.getEdgeIteratorState(edge, adjNode);
        this.path.addDistance(edgeState.getDistance());
        this.path.addTime(GHUtility.calcMillisWithTurnMillis(this.weighting, edgeState, false, prevEdge));
        this.path.addEdge(edge);
    }
}

