/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.Path;
import com.graphhopper.routing.SPTEntry;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.StopWatch;

public class BidirPathExtractor {
    private final Graph graph;
    private final Weighting weighting;
    protected final Path path;

    public static Path extractPath(Graph graph, Weighting weighting, SPTEntry fwdEntry, SPTEntry bwdEntry, double weight) {
        return new BidirPathExtractor(graph, weighting).extract(fwdEntry, bwdEntry, weight);
    }

    protected BidirPathExtractor(Graph graph, Weighting weighting) {
        this.graph = graph;
        this.weighting = weighting;
        this.path = new Path(graph);
    }

    protected Path extract(SPTEntry fwdEntry, SPTEntry bwdEntry, double weight) {
        if (fwdEntry == null || bwdEntry == null) {
            return this.path;
        }
        if (fwdEntry.adjNode != bwdEntry.adjNode) {
            throw new IllegalStateException("forward and backward entries must have same adjacent nodes, fwdEntry:" + fwdEntry + ", bwdEntry:" + bwdEntry);
        }
        StopWatch sw = new StopWatch().start();
        this.extractFwdPath(fwdEntry);
        this.processMeetingPoint(fwdEntry, bwdEntry);
        this.extractBwdPath(bwdEntry);
        this.setExtractionTime(sw.stop().getNanos());
        this.path.setFound(true);
        this.path.setWeight(weight);
        return this.path;
    }

    protected void extractFwdPath(SPTEntry sptEntry) {
        SPTEntry fwdRoot = this.followParentsUntilRoot(sptEntry, false);
        this.onFwdTreeRoot(fwdRoot.adjNode);
        this.path.reverseEdges();
    }

    protected void extractBwdPath(SPTEntry sptEntry) {
        SPTEntry bwdRoot = this.followParentsUntilRoot(sptEntry, true);
        this.onBwdTreeRoot(bwdRoot.adjNode);
    }

    protected void processMeetingPoint(SPTEntry fwdEntry, SPTEntry bwdEntry) {
        int inEdge = this.getIncEdge(fwdEntry);
        int outEdge = this.getIncEdge(bwdEntry);
        this.onMeetingPoint(inEdge, fwdEntry.adjNode, outEdge);
    }

    protected SPTEntry followParentsUntilRoot(SPTEntry sptEntry, boolean reverse) {
        SPTEntry currEntry = sptEntry;
        SPTEntry parentEntry = currEntry.parent;
        while (EdgeIterator.Edge.isValid(currEntry.edge)) {
            this.onEdge(currEntry.edge, currEntry.adjNode, reverse, this.getIncEdge(parentEntry));
            currEntry = parentEntry;
            parentEntry = currEntry.parent;
        }
        return currEntry;
    }

    protected void setExtractionTime(long nanos) {
        this.path.setDebugInfo("path extraction: " + nanos / 1000L + " micros");
    }

    protected int getIncEdge(SPTEntry entry) {
        return entry.edge;
    }

    protected void onFwdTreeRoot(int node) {
        this.path.setFromNode(node);
    }

    protected void onBwdTreeRoot(int node) {
        this.path.setEndNode(node);
    }

    protected void onEdge(int edge, int adjNode, boolean reverse, int prevOrNextEdge) {
        EdgeIteratorState edgeState = this.graph.getEdgeIteratorState(edge, adjNode);
        this.path.addDistance(edgeState.getDistance());
        this.path.addTime(GHUtility.calcMillisWithTurnMillis(this.weighting, edgeState, reverse, prevOrNextEdge));
        this.path.addEdge(edge);
    }

    protected void onMeetingPoint(int inEdge, int viaNode, int outEdge) {
        if (!EdgeIterator.Edge.isValid(inEdge) || !EdgeIterator.Edge.isValid(outEdge)) {
            return;
        }
        this.path.addTime(this.weighting.calcTurnMillis(inEdge, viaNode, outEdge));
    }
}

