/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.AStar;
import com.graphhopper.routing.AbstractBidirCHAlgo;
import com.graphhopper.routing.SPTEntry;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.BalancedWeightApproximator;
import com.graphhopper.routing.weighting.BeelineWeightApproximator;
import com.graphhopper.routing.weighting.WeightApproximator;
import com.graphhopper.storage.RoutingCHEdgeIteratorState;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.Helper;

public class AStarBidirectionCH
extends AbstractBidirCHAlgo {
    private BalancedWeightApproximator weightApprox;

    public AStarBidirectionCH(RoutingCHGraph graph) {
        super(graph, TraversalMode.NODE_BASED);
        BeelineWeightApproximator defaultApprox = new BeelineWeightApproximator(this.nodeAccess, graph.getWeighting());
        defaultApprox.setDistanceCalc((DistanceCalc)Helper.DIST_PLANE);
        this.setApproximation(defaultApprox);
    }

    @Override
    void init(int from, double fromWeight, int to, double toWeight) {
        this.weightApprox.setFromTo(from, to);
        super.init(from, fromWeight, to, toWeight);
    }

    @Override
    protected SPTEntry createStartEntry(int node, double weight, boolean reverse) {
        double heapWeight = weight + this.weightApprox.approximate(node, reverse);
        return new AStar.AStarEntry(-1, node, heapWeight, weight);
    }

    @Override
    protected SPTEntry createEntry(RoutingCHEdgeIteratorState edge, int incEdge, double weight, SPTEntry parent, boolean reverse) {
        int neighborNode = edge.getAdjNode();
        double heapWeight = weight + this.weightApprox.approximate(neighborNode, reverse);
        AStar.AStarEntry entry = new AStar.AStarEntry(edge.getEdge(), neighborNode, heapWeight, weight);
        entry.parent = parent;
        return entry;
    }

    @Override
    protected void updateEntry(SPTEntry entry, RoutingCHEdgeIteratorState edge, int edgeId, double weight, SPTEntry parent, boolean reverse) {
        entry.edge = edge.getEdge();
        entry.weight = weight + this.weightApprox.approximate(edge.getAdjNode(), reverse);
        ((AStar.AStarEntry)entry).weightOfVisitedPath = weight;
        entry.parent = parent;
    }

    @Override
    protected double calcWeight(RoutingCHEdgeIteratorState iter, SPTEntry currEdge, boolean reverse) {
        return super.calcWeight(iter, currEdge, reverse);
    }

    public WeightApproximator getApproximation() {
        return this.weightApprox.getApproximation();
    }

    public AStarBidirectionCH setApproximation(WeightApproximator approx) {
        this.weightApprox = new BalancedWeightApproximator(approx);
        return this;
    }

    @Override
    public String getName() {
        return "astarbi|ch";
    }
}

