/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.reader.dem.AbstractSRTMElevationProvider;
import com.graphhopper.util.Helper;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class SRTMGL1Provider
extends AbstractSRTMElevationProvider {
    private final int latDegree = 1;
    private final int lonDegree = 1;

    public SRTMGL1Provider() {
        this("");
    }

    public SRTMGL1Provider(String cacheDir) {
        super("https://cloud.sdsc.edu/v1/AUTH_opentopography/Raster/SRTM_GL1/SRTM_GL1_srtm/", cacheDir.isEmpty() ? "/tmp/srtmgl1" : cacheDir, "GraphHopper SRTMReader", -56, 60, 3601);
    }

    public static void main(String[] args) throws IOException {
        SRTMGL1Provider provider = new SRTMGL1Provider();
        System.out.println(provider.getEle(49.949784, 11.57517));
        System.out.println(provider.getEle(49.968668, 11.575127));
        System.out.println(provider.getEle(49.968682, 11.574842));
        System.out.println(provider.getEle(-22.532854, -65.110474));
        System.out.println(provider.getEle(38.065392, -87.099609));
        System.out.println(provider.getEle(40.0, -105.2277023));
        System.out.println(provider.getEle(39.99999999, -105.2277023));
        System.out.println(provider.getEle(39.9999999, -105.2277023));
        System.out.println(provider.getEle(39.999999, -105.2277023));
        System.out.println(provider.getEle(47.468668, 14.575127));
        System.out.println(provider.getEle(47.467753, 14.573911));
        System.out.println(provider.getEle(46.468835, 12.578777));
        System.out.println(provider.getEle(48.469123, 9.576393));
    }

    @Override
    byte[] readFile(File file) throws IOException {
        int len;
        FileInputStream is = new FileInputStream(file);
        BufferedInputStream buff = new BufferedInputStream(is);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[65535];
        while ((len = buff.read(buffer)) > 0) {
            os.write(buffer, 0, len);
        }
        os.flush();
        Helper.close((Closeable)buff);
        return os.toByteArray();
    }

    int getMinLatForTile(double lat) {
        return (int)(Math.floor((90.0 + lat) / 1.0) * 1.0) - 90;
    }

    int getMinLonForTile(double lon) {
        return (int)(Math.floor((180.0 + lon) / 1.0) * 1.0) - 180;
    }

    @Override
    String getFileName(double lat, double lon) {
        int lonInt = this.getMinLonForTile(lon);
        int latInt = this.getMinLatForTile(lat);
        return Helper.toLowerCase((String)(this.getNorthString(latInt) + this.getPaddedLatString(latInt) + this.getEastString(lonInt) + this.getPaddedLonString(lonInt)));
    }

    @Override
    String getDownloadURL(double lat, double lon) {
        String dir;
        int lonInt = this.getMinLonForTile(lon);
        int latInt = this.getMinLatForTile(lat);
        String north = this.getNorthString(latInt);
        if (north.equals("N")) {
            dir = "North/";
            dir = lat >= 30.0 ? dir + "North_30_60/" : dir + "North_0_29/";
        } else {
            dir = "South/";
        }
        return dir + north + this.getPaddedLatString(latInt) + this.getEastString(lonInt) + this.getPaddedLonString(lonInt) + ".hgt";
    }

    private String getNorthString(int lat) {
        if (lat < 0) {
            return "S";
        }
        return "N";
    }

    private String getEastString(int lon) {
        if (lon < 0) {
            return "W";
        }
        return "E";
    }

    public String toString() {
        return "srtmgl1";
    }
}

