/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.reader.dem.CGIARProvider;
import com.graphhopper.reader.dem.ElevationProvider;
import com.graphhopper.reader.dem.GMTEDProvider;
import com.graphhopper.storage.DAType;

public class MultiSourceElevationProvider
implements ElevationProvider {
    private ElevationProvider srtmProvider;
    private ElevationProvider globalProvider;

    public MultiSourceElevationProvider(ElevationProvider srtmProvider, ElevationProvider globalProvider) {
        this.srtmProvider = srtmProvider;
        this.globalProvider = globalProvider;
    }

    public MultiSourceElevationProvider() {
        this(new CGIARProvider(), new GMTEDProvider());
    }

    public MultiSourceElevationProvider(String cacheDir) {
        this(new CGIARProvider(cacheDir), new GMTEDProvider(cacheDir));
    }

    @Override
    public double getEle(double lat, double lon) {
        if (lat < 59.999 && lat > -56.0) {
            return this.srtmProvider.getEle(lat, lon);
        }
        return this.globalProvider.getEle(lat, lon);
    }

    @Override
    public ElevationProvider setBaseURL(String baseURL) {
        String[] urls = baseURL.split(";");
        if (urls.length != 2) {
            throw new IllegalArgumentException("The base url must consist of two urls separated by a ';'. The first for cgiar, the second for gmted");
        }
        this.srtmProvider.setBaseURL(urls[0]);
        this.globalProvider.setBaseURL(urls[1]);
        return this;
    }

    @Override
    public ElevationProvider setDAType(DAType daType) {
        this.srtmProvider.setDAType(daType);
        this.globalProvider.setDAType(daType);
        return this;
    }

    @Override
    public void setInterpolate(boolean interpolate) {
        this.srtmProvider.setInterpolate(interpolate);
        this.globalProvider.setInterpolate(interpolate);
    }

    @Override
    public void release() {
        this.srtmProvider.release();
        this.globalProvider.release();
    }

    @Override
    public void setAutoRemoveTemporaryFiles(boolean autoRemoveTemporary) {
        this.srtmProvider.setAutoRemoveTemporaryFiles(autoRemoveTemporary);
        this.globalProvider.setAutoRemoveTemporaryFiles(autoRemoveTemporary);
    }

    public String toString() {
        return "multi";
    }
}

