/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.module.algo.generator.relationship;

import com.graphaware.common.util.SameTypePair;
import com.graphaware.common.util.UnorderedPair;
import com.graphaware.module.algo.generator.config.WattsStrogatzConfig;
import com.graphaware.module.algo.generator.relationship.BaseRelationshipGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class WattsStrogatzRelationshipGenerator
extends BaseRelationshipGenerator<WattsStrogatzConfig> {
    private Random random = new Random();

    public WattsStrogatzRelationshipGenerator(WattsStrogatzConfig configuration) {
        super(configuration);
    }

    @Override
    protected List<SameTypePair<Integer>> doGenerateEdges() {
        int numberOfNodes = ((WattsStrogatzConfig)this.getConfiguration()).getNumberOfNodes();
        int meanDegree = ((WattsStrogatzConfig)this.getConfiguration()).getMeanDegree();
        double beta = ((WattsStrogatzConfig)this.getConfiguration()).getBeta();
        HashSet<Object> ring = new HashSet<Object>(numberOfNodes);
        for (int i = 0; i < numberOfNodes; ++i) {
            for (int j = i + 1; j <= i + meanDegree / 2; ++j) {
                int friend = j % numberOfNodes;
                ring.add(new UnorderedPair((Object)i, (Object)friend));
            }
        }
        HashSet<UnorderedPair> newEdges = new HashSet<UnorderedPair>();
        Iterator iterator = ring.iterator();
        block2: while (iterator.hasNext()) {
            UnorderedPair trialPair;
            SameTypePair edge = (SameTypePair)iterator.next();
            if (!(this.random.nextDouble() <= beta)) continue;
            int choice = this.random.nextDouble() > 0.5 ? ((Integer)edge.first()).intValue() : ((Integer)edge.second()).intValue();
            do {
                int trial;
                int partner;
                int n = partner = (trial = this.random.nextInt(numberOfNodes - 1)) < choice ? trial : trial + 1;
                trialPair = new UnorderedPair((Object)choice, (Object)partner);
                if (trialPair.equals((Object)edge)) continue block2;
            } while (ring.contains(trialPair) || newEdges.contains(trialPair));
            iterator.remove();
            newEdges.add(trialPair);
        }
        ring.addAll(newEdges);
        return new ArrayList<SameTypePair<Integer>>(ring);
    }
}

