/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.module.algo.generator.relationship;

import com.graphaware.common.util.SameTypePair;
import com.graphaware.common.util.UnorderedPair;
import com.graphaware.module.algo.generator.config.ErdosRenyiConfig;
import com.graphaware.module.algo.generator.relationship.BaseRelationshipGenerator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class ErdosRenyiRelationshipGenerator
extends BaseRelationshipGenerator<ErdosRenyiConfig> {
    private final Random random = new Random();

    public ErdosRenyiRelationshipGenerator(ErdosRenyiConfig configuration) {
        super(configuration);
    }

    @Override
    protected List<SameTypePair<Integer>> doGenerateEdges() {
        long potentialEdges;
        long threshold = ((ErdosRenyiConfig)this.getConfiguration()).getNumberOfEdges() * 4;
        if (threshold > (potentialEdges = (long)(((ErdosRenyiConfig)this.getConfiguration()).getNumberOfNodes() * (((ErdosRenyiConfig)this.getConfiguration()).getNumberOfNodes() - 1)))) {
            return this.doGenerateEdgesWithOmitList();
        }
        return this.doGenerateEdgesSimpler();
    }

    private List<SameTypePair<Integer>> doGenerateEdgesSimpler() {
        int numberOfNodes = ((ErdosRenyiConfig)this.getConfiguration()).getNumberOfNodes();
        long numberOfEdges = ((ErdosRenyiConfig)this.getConfiguration()).getNumberOfEdges();
        HashSet<UnorderedPair> edges = new HashSet<UnorderedPair>();
        while ((long)edges.size() < numberOfEdges) {
            int origin = this.random.nextInt(numberOfNodes);
            int target = this.random.nextInt(numberOfNodes);
            if (target == origin) continue;
            edges.add(new UnorderedPair((Object)origin, (Object)target));
        }
        return new LinkedList<SameTypePair<Integer>>(edges);
    }

    protected List<SameTypePair<Integer>> doGenerateEdgesWithOmitList() {
        int numberOfNodes = ((ErdosRenyiConfig)this.getConfiguration()).getNumberOfNodes();
        int numberOfEdges = ((ErdosRenyiConfig)this.getConfiguration()).getNumberOfEdges();
        long maxEdges = numberOfNodes * (numberOfNodes - 1) / 2;
        LinkedList<SameTypePair<Integer>> edges = new LinkedList<SameTypePair<Integer>>();
        for (Long index : this.edgeIndices(numberOfEdges, maxEdges)) {
            edges.add((SameTypePair<Integer>)this.indexToEdgeBijection(index));
        }
        return edges;
    }

    private UnorderedPair<Integer> indexToEdgeBijection(long index) {
        long i = (long)Math.ceil((Math.sqrt(1L + 8L * (index + 1L)) - 1.0) / 2.0);
        long diff = index + 1L - i * (i - 1L) / 2L;
        return new UnorderedPair((Object)((int)i), (Object)((int)diff - 1));
    }

    private Set<Long> edgeIndices(int numberOfEdges, long maxEdges) {
        HashSet<Long> result = new HashSet<Long>(numberOfEdges);
        while (result.size() < numberOfEdges) {
            result.add(this.nextLong(maxEdges));
        }
        return result;
    }

    private long nextLong(long length) {
        return (long)(this.random.nextDouble() * (double)length);
    }
}

